/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.immutable;

import java.util.NoSuchElementException;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.ScalaObject;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.LinearSeqOptimized;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.RedBlackTree;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RedBlackTree$
implements ScalaObject {
    public static final RedBlackTree$ MODULE$;

    static {
        new RedBlackTree$();
    }

    public boolean isEmpty(RedBlackTree.Tree<?, ?> tree) {
        return tree == null;
    }

    public <A> boolean contains(RedBlackTree.Tree<A, ?> tree, A x2, Ordering<A> ordering) {
        return this.lookup(tree, x2, ordering) != null;
    }

    public <A, B> Option<B> get(RedBlackTree.Tree<A, B> tree, A x2, Ordering<A> ordering) {
        RedBlackTree.Tree<A, B> tree2 = this.lookup(tree, x2, ordering);
        return tree2 == null ? None$.MODULE$ : new Some(tree2.value);
    }

    public <A, B> RedBlackTree.Tree<A, B> lookup(RedBlackTree.Tree<A, B> tree, A x2, Ordering<A> ordering) {
        RedBlackTree.Tree<A, B> tree2;
        block3: {
            while (true) {
                if (tree == null) {
                    tree2 = null;
                    break block3;
                }
                int cmp = ordering.compare(x2, tree.key);
                if (cmp < 0) {
                    tree = tree.left;
                    continue;
                }
                if (cmp <= 0) break;
                tree = tree.right;
            }
            tree2 = tree;
        }
        return tree2;
    }

    public int count(RedBlackTree.Tree<?, ?> tree) {
        return tree == null ? 0 : tree.count();
    }

    public <A, B, B1> RedBlackTree.Tree<A, B1> update(RedBlackTree.Tree<A, B> tree, A k, B1 v, Ordering<A> ordering) {
        return this.blacken(this.upd(tree, k, v, ordering));
    }

    public <A, B> RedBlackTree.Tree<A, B> delete(RedBlackTree.Tree<A, B> tree, A k, Ordering<A> ordering) {
        return this.blacken(this.del(tree, k, ordering));
    }

    public <A, B> RedBlackTree.Tree<A, B> rangeImpl(RedBlackTree.Tree<A, B> tree, Option<A> from2, Option<A> until2, Ordering<A> evidence$1) {
        Tuple2<Option<A>, Option<A>> tuple2;
        block2: {
            block7: {
                block9: {
                    RedBlackTree.Tree<A, B> tree2;
                    block5: {
                        Option<A> option;
                        block8: {
                            Option<A> option2;
                            block3: {
                                block6: {
                                    Object a;
                                    block4: {
                                        tuple2 = new Tuple2<Option<A>, Option<A>>(from2, until2);
                                        if (tuple2 == null) break block2;
                                        option2 = tuple2._1();
                                        option = tuple2._2();
                                        if (!(option2 instanceof Some)) break block3;
                                        Some some = (Some)option2;
                                        a = some.x();
                                        if (!(option instanceof Some)) break block4;
                                        tree2 = this.range(tree, a, ((Some)option).x(), evidence$1);
                                        break block5;
                                    }
                                    None$ none$ = None$.MODULE$;
                                    Option<A> option3 = option;
                                    if (none$ != null ? !none$.equals(option3) : option3 != null) break block6;
                                    tree2 = this.from(tree, a, evidence$1);
                                    break block5;
                                }
                                throw new MatchError(tuple2);
                            }
                            None$ none$ = None$.MODULE$;
                            Option<A> option4 = option2;
                            if (none$ != null ? !none$.equals(option4) : option4 != null) break block7;
                            if (!(option instanceof Some)) break block8;
                            tree2 = this.until(tree, ((Some)option).x(), evidence$1);
                            break block5;
                        }
                        None$ none$ = None$.MODULE$;
                        Option<A> option5 = option;
                        if (none$ != null ? !none$.equals(option5) : option5 != null) break block9;
                        tree2 = tree;
                    }
                    return tree2;
                }
                throw new MatchError(tuple2);
            }
            throw new MatchError(tuple2);
        }
        throw new MatchError(tuple2);
    }

    public <A, B> RedBlackTree.Tree<A, B> range(RedBlackTree.Tree<A, B> tree, A from2, A until2, Ordering<A> evidence$2) {
        return this.blacken(this.doRange(tree, from2, until2, evidence$2));
    }

    public <A, B> RedBlackTree.Tree<A, B> from(RedBlackTree.Tree<A, B> tree, A from2, Ordering<A> evidence$3) {
        return this.blacken(this.doFrom(tree, from2, evidence$3));
    }

    public <A, B> RedBlackTree.Tree<A, B> to(RedBlackTree.Tree<A, B> tree, A to2, Ordering<A> evidence$4) {
        return this.blacken(this.doTo(tree, to2, evidence$4));
    }

    public <A, B> RedBlackTree.Tree<A, B> until(RedBlackTree.Tree<A, B> tree, A key, Ordering<A> evidence$5) {
        return this.blacken(this.doUntil(tree, key, evidence$5));
    }

    public <A, B> RedBlackTree.Tree<A, B> drop(RedBlackTree.Tree<A, B> tree, int n, Ordering<A> evidence$6) {
        return this.blacken(this.doDrop(tree, n, evidence$6));
    }

    public <A, B> RedBlackTree.Tree<A, B> take(RedBlackTree.Tree<A, B> tree, int n, Ordering<A> evidence$7) {
        return this.blacken(this.doTake(tree, n, evidence$7));
    }

    public <A, B> RedBlackTree.Tree<A, B> slice(RedBlackTree.Tree<A, B> tree, int from2, int until2, Ordering<A> evidence$8) {
        return this.blacken(this.doSlice(tree, from2, until2, evidence$8));
    }

    /*
     * WARNING - void declaration
     */
    public <A, B> RedBlackTree.Tree<A, B> smallest(RedBlackTree.Tree<A, B> tree) {
        void var2_2;
        if (tree == null) {
            throw new NoSuchElementException("empty map");
        }
        RedBlackTree.Tree<A, B> result2 = tree;
        while (result2.left != null) {
            result2 = result2.left;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public <A, B> RedBlackTree.Tree<A, B> greatest(RedBlackTree.Tree<A, B> tree) {
        void var2_2;
        if (tree == null) {
            throw new NoSuchElementException("empty map");
        }
        RedBlackTree.Tree<A, B> result2 = tree;
        while (result2.right != null) {
            result2 = result2.right;
        }
        return var2_2;
    }

    public <A, B, U> void foreach(RedBlackTree.Tree<A, B> tree, Function1<Tuple2<A, B>, U> f) {
        while (tree != null) {
            if (tree.left != null) {
                this.foreach(tree.left, f);
            }
            f.apply(new Tuple2(tree.key, tree.value));
            if (tree.right == null) break;
            tree = tree.right;
        }
    }

    public <A, U> void foreachKey(RedBlackTree.Tree<A, ?> tree, Function1<A, U> f) {
        while (tree != null) {
            if (tree.left != null) {
                this.foreachKey(tree.left, f);
            }
            f.apply(tree.key);
            if (tree.right == null) break;
            tree = tree.right;
        }
    }

    public <A, B> Iterator<Tuple2<A, B>> iterator(RedBlackTree.Tree<A, B> tree) {
        return new RedBlackTree.EntriesIterator<A, B>(tree);
    }

    public <A, _> Iterator<A> keysIterator(RedBlackTree.Tree<A, ?> tree) {
        return new RedBlackTree.KeysIterator(tree);
    }

    public <_, B> Iterator<B> valuesIterator(RedBlackTree.Tree<?, B> tree) {
        return new RedBlackTree.ValuesIterator(tree);
    }

    public <A, B> RedBlackTree.Tree<A, B> nth(RedBlackTree.Tree<A, B> tree, int n) {
        while (true) {
            int count2;
            if (n < (count2 = this.count(tree.left))) {
                tree = tree.left;
                continue;
            }
            if (n <= count2) break;
            n = n - count2 - 1;
            tree = tree.right;
        }
        return tree;
    }

    public boolean isBlack(RedBlackTree.Tree<?, ?> tree) {
        return tree == null || this.scala$collection$immutable$RedBlackTree$$isBlackTree(tree);
    }

    private boolean isRedTree(RedBlackTree.Tree<?, ?> tree) {
        return tree instanceof RedBlackTree.RedTree;
    }

    public boolean scala$collection$immutable$RedBlackTree$$isBlackTree(RedBlackTree.Tree<?, ?> tree) {
        return tree instanceof RedBlackTree.BlackTree;
    }

    private <A, B> RedBlackTree.Tree<A, B> blacken(RedBlackTree.Tree<A, B> t) {
        return t == null ? null : t.black();
    }

    private <A, B> RedBlackTree.Tree<A, B> mkTree(boolean isBlack, A k, B v, RedBlackTree.Tree<A, B> l, RedBlackTree.Tree<A, B> r) {
        RedBlackTree.Tree tree;
        if (isBlack) {
            RedBlackTree.Tree<A, B> tree2 = r;
            RedBlackTree.Tree<A, B> tree3 = l;
            B b = v;
            A a = k;
            tree = new RedBlackTree.BlackTree<A, B>(a, b, tree3, tree2);
        } else {
            RedBlackTree.Tree<A, B> tree4 = r;
            RedBlackTree.Tree<A, B> tree5 = l;
            B b = v;
            A a = k;
            tree = new RedBlackTree.RedTree<A, B>(a, b, tree5, tree4);
        }
        return tree;
    }

    public <A, B, B1> RedBlackTree.Tree<A, B1> scala$collection$immutable$RedBlackTree$$balanceLeft(boolean isBlack, A z, B zv, RedBlackTree.Tree<A, B1> l, RedBlackTree.Tree<A, B1> d) {
        RedBlackTree.RedTree redTree;
        if (this.isRedTree(l) && this.isRedTree(l.left)) {
            RedBlackTree.Tree<A, B1> tree = l.left().right();
            RedBlackTree.Tree<A, B1> tree2 = l.left().left();
            Object b = l.left.value();
            Object a = l.left.key;
            RedBlackTree.Tree<A, B1> tree3 = d;
            RedBlackTree.Tree tree4 = l.right;
            B b2 = zv;
            A a2 = z;
            RedBlackTree.BlackTree<A, B> blackTree = new RedBlackTree.BlackTree<A, B>(a2, b2, tree4, tree3);
            RedBlackTree.BlackTree blackTree2 = new RedBlackTree.BlackTree(a, b, tree2, tree);
            Object b3 = l.value;
            Object a3 = l.key;
            redTree = new RedBlackTree.RedTree(a3, b3, blackTree2, blackTree);
        } else if (this.isRedTree(l) && this.isRedTree(l.right)) {
            RedBlackTree.Tree<A, B1> tree = l.right().left();
            RedBlackTree.Tree<A, B1> tree5 = l.left();
            B1 B1 = l.value();
            Object a = l.key;
            RedBlackTree.Tree<A, B1> tree6 = d;
            RedBlackTree.Tree tree7 = l.right.right;
            B b = zv;
            A a4 = z;
            RedBlackTree.BlackTree<A, B> blackTree = new RedBlackTree.BlackTree<A, B>(a4, b, tree7, tree6);
            RedBlackTree.BlackTree blackTree3 = new RedBlackTree.BlackTree(a, B1, tree5, tree);
            Object b4 = l.right.value;
            Object a5 = l.right.key;
            redTree = new RedBlackTree.RedTree(a5, b4, blackTree3, blackTree);
        } else {
            redTree = this.mkTree(isBlack, z, zv, l, d);
        }
        return redTree;
    }

    public <A, B, B1> RedBlackTree.Tree<A, B1> scala$collection$immutable$RedBlackTree$$balanceRight(boolean isBlack, A x2, B xv, RedBlackTree.Tree<A, B1> a, RedBlackTree.Tree<A, B1> r) {
        RedBlackTree.RedTree redTree;
        if (this.isRedTree(r) && this.isRedTree(r.left)) {
            RedBlackTree.Tree<A, B1> tree = r.left().left();
            RedBlackTree.Tree<A, B1> tree2 = a;
            B b = xv;
            A a2 = x2;
            RedBlackTree.Tree<A, B1> tree3 = r.right();
            RedBlackTree.Tree tree4 = r.left.right;
            Object b2 = r.value;
            Object a3 = r.key;
            RedBlackTree.BlackTree blackTree = new RedBlackTree.BlackTree(a3, b2, tree4, tree3);
            RedBlackTree.BlackTree<A, B> blackTree2 = new RedBlackTree.BlackTree<A, B>(a2, b, tree2, tree);
            Object b3 = r.left.value;
            Object a4 = r.left.key;
            redTree = new RedBlackTree.RedTree(a4, b3, blackTree2, blackTree);
        } else if (this.isRedTree(r) && this.isRedTree(r.right)) {
            RedBlackTree.Tree tree = r.left;
            RedBlackTree.Tree<A, B1> tree5 = a;
            B b = xv;
            A a5 = x2;
            RedBlackTree.Tree<A, B1> tree6 = r.right().right();
            RedBlackTree.Tree<A, B1> tree7 = r.right().left();
            Object b4 = r.right.value;
            Object a6 = r.right.key;
            RedBlackTree.BlackTree blackTree = new RedBlackTree.BlackTree(a6, b4, tree7, tree6);
            RedBlackTree.BlackTree<A, B> blackTree3 = new RedBlackTree.BlackTree<A, B>(a5, b, tree5, tree);
            Object b5 = r.value;
            Object a7 = r.key;
            redTree = new RedBlackTree.RedTree(a7, b5, blackTree3, blackTree);
        } else {
            redTree = this.mkTree(isBlack, x2, xv, a, r);
        }
        return redTree;
    }

    private <A, B, B1> RedBlackTree.Tree<A, B1> upd(RedBlackTree.Tree<A, B> tree, A k, B1 v, Ordering<A> ordering) {
        RedBlackTree.Tree tree2;
        if (tree == null) {
            B1 B1 = v;
            A a = k;
            tree2 = new RedBlackTree.RedTree<A, B1>(a, B1, null, null);
        } else {
            int cmp = ordering.compare(k, tree.key);
            tree2 = cmp < 0 ? this.scala$collection$immutable$RedBlackTree$$balanceLeft(this.scala$collection$immutable$RedBlackTree$$isBlackTree(tree), tree.key, tree.value, this.upd(tree.left, k, v, ordering), tree.right) : (cmp > 0 ? this.scala$collection$immutable$RedBlackTree$$balanceRight(this.scala$collection$immutable$RedBlackTree$$isBlackTree(tree), tree.key, tree.value, tree.left, this.upd(tree.right, k, v, ordering)) : this.mkTree(this.scala$collection$immutable$RedBlackTree$$isBlackTree(tree), k, v, tree.left, tree.right));
        }
        return tree2;
    }

    private <A, B> RedBlackTree.Tree<A, B> del(RedBlackTree.Tree<A, B> tree$1, A k$1, Ordering<A> ordering$1) {
        int cmp;
        return tree$1 == null ? null : ((cmp = ordering$1.compare(k$1, tree$1.key)) < 0 ? this.delLeft$1(tree$1, k$1, ordering$1) : (cmp > 0 ? this.delRight$1(tree$1, k$1, ordering$1) : this.append$1(tree$1.left, tree$1.right)));
    }

    private <A, B> RedBlackTree.Tree<A, B> doFrom(RedBlackTree.Tree<A, B> tree, A from2, Ordering<A> ordering) {
        if (tree == null) {
            return null;
        }
        if (ordering.lt(tree.key, from2)) {
            return this.doFrom(tree.right, from2, ordering);
        }
        RedBlackTree.Tree newLeft = this.doFrom(tree.left, from2, ordering);
        return newLeft == tree.left ? tree : (newLeft == null ? this.upd(tree.right, tree.key, tree.value, ordering) : this.rebalance(tree, newLeft, tree.right));
    }

    private <A, B> RedBlackTree.Tree<A, B> doTo(RedBlackTree.Tree<A, B> tree, A to2, Ordering<A> ordering) {
        if (tree == null) {
            return null;
        }
        if (ordering.lt(to2, tree.key)) {
            return this.doTo(tree.left, to2, ordering);
        }
        RedBlackTree.Tree newRight = this.doTo(tree.right, to2, ordering);
        return newRight == tree.right ? tree : (newRight == null ? this.upd(tree.left, tree.key, tree.value, ordering) : this.rebalance(tree, tree.left, newRight));
    }

    private <A, B> RedBlackTree.Tree<A, B> doUntil(RedBlackTree.Tree<A, B> tree, A until2, Ordering<A> ordering) {
        if (tree == null) {
            return null;
        }
        if (ordering.lteq(until2, tree.key)) {
            return this.doUntil(tree.left, until2, ordering);
        }
        RedBlackTree.Tree newRight = this.doUntil(tree.right, until2, ordering);
        return newRight == tree.right ? tree : (newRight == null ? this.upd(tree.left, tree.key, tree.value, ordering) : this.rebalance(tree, tree.left, newRight));
    }

    private <A, B> RedBlackTree.Tree<A, B> doRange(RedBlackTree.Tree<A, B> tree, A from2, A until2, Ordering<A> ordering) {
        if (tree == null) {
            return null;
        }
        if (ordering.lt(tree.key, from2)) {
            return this.doRange(tree.right, from2, until2, ordering);
        }
        if (ordering.lteq(until2, tree.key)) {
            return this.doRange(tree.left, from2, until2, ordering);
        }
        RedBlackTree.Tree newLeft = this.doFrom(tree.left, from2, ordering);
        RedBlackTree.Tree newRight = this.doUntil(tree.right, until2, ordering);
        return newLeft == tree.left && newRight == tree.right ? tree : (newLeft == null ? this.upd(newRight, tree.key, tree.value, ordering) : (newRight == null ? this.upd(newLeft, tree.key, tree.value, ordering) : this.rebalance(tree, newLeft, newRight)));
    }

    private <A, B> RedBlackTree.Tree<A, B> doDrop(RedBlackTree.Tree<A, B> tree, int n, Ordering<A> evidence$9) {
        if (n <= 0) {
            return tree;
        }
        if (n >= this.count(tree)) {
            return null;
        }
        int count2 = this.count(tree.left);
        if (n > count2) {
            return this.doDrop(tree.right, n - count2 - 1, evidence$9);
        }
        RedBlackTree.Tree newLeft = this.doDrop(tree.left, n, evidence$9);
        return newLeft == tree.left ? tree : (newLeft == null ? this.upd(tree.right, tree.key, tree.value, evidence$9) : this.rebalance(tree, newLeft, tree.right));
    }

    private <A, B> RedBlackTree.Tree<A, B> doTake(RedBlackTree.Tree<A, B> tree, int n, Ordering<A> evidence$10) {
        if (n <= 0) {
            return null;
        }
        if (n >= this.count(tree)) {
            return tree;
        }
        int count2 = this.count(tree.left);
        if (n <= count2) {
            return this.doTake(tree.left, n, evidence$10);
        }
        RedBlackTree.Tree newRight = this.doTake(tree.right, n - count2 - 1, evidence$10);
        return newRight == tree.right ? tree : (newRight == null ? this.upd(tree.left, tree.key, tree.value, evidence$10) : this.rebalance(tree, tree.left, newRight));
    }

    private <A, B> RedBlackTree.Tree<A, B> doSlice(RedBlackTree.Tree<A, B> tree, int from2, int until2, Ordering<A> evidence$11) {
        if (tree == null) {
            return null;
        }
        int count2 = this.count(tree.left);
        if (from2 > count2) {
            return this.doSlice(tree.right, from2 - count2 - 1, until2 - count2 - 1, evidence$11);
        }
        if (until2 <= count2) {
            return this.doSlice(tree.left, from2, until2, evidence$11);
        }
        RedBlackTree.Tree newLeft = this.doDrop(tree.left, from2, evidence$11);
        RedBlackTree.Tree newRight = this.doTake(tree.right, until2 - count2 - 1, evidence$11);
        return newLeft == tree.left && newRight == tree.right ? tree : (newLeft == null ? this.upd(newRight, tree.key, tree.value, evidence$11) : (newRight == null ? this.upd(newLeft, tree.key, tree.value, evidence$11) : this.rebalance(tree, newLeft, newRight)));
    }

    private <A, B> Tuple4<List<RedBlackTree.Tree<A, B>>, Object, Object, Object> compareDepth(RedBlackTree.Tree<A, B> left, RedBlackTree.Tree<A, B> right) {
        return this.unzipBoth$1(left, right, Nil$.MODULE$, Nil$.MODULE$, 0);
    }

    private <A, B> RedBlackTree.Tree<A, B> rebalance(RedBlackTree.Tree<A, B> tree, RedBlackTree.Tree<A, B> newLeft, RedBlackTree.Tree<A, B> newRight) {
        RedBlackTree.Tree<A, B> blkNewRight;
        RedBlackTree.Tree<A, B> blkNewLeft = this.blacken(newLeft);
        Tuple4<List<RedBlackTree.Tree<A, B>>, Object, Object, Object> tuple4 = this.compareDepth(blkNewLeft, blkNewRight = this.blacken(newRight));
        if (tuple4 != null) {
            RedBlackTree.Tree tree2;
            Tuple4<List<RedBlackTree.Tree<A, B>>, Object, Object, Object> tuple42 = new Tuple4<List<RedBlackTree.Tree<A, B>>, Object, Object, Object>(tuple4._1(), tuple4._2(), tuple4._3(), tuple4._4());
            List<RedBlackTree.Tree<A, B>> zipper = tuple42._1();
            boolean levelled = BoxesRunTime.unboxToBoolean(tuple42._2());
            boolean leftMost$1 = BoxesRunTime.unboxToBoolean(tuple42._3());
            int smallerDepth = BoxesRunTime.unboxToInt(tuple42._4());
            if (levelled) {
                RedBlackTree.Tree<A, B> tree3 = blkNewRight;
                RedBlackTree.Tree<A, B> tree4 = blkNewLeft;
                Object b = tree.value;
                Object a = tree.key;
                tree2 = new RedBlackTree.BlackTree(a, b, tree4, tree3);
            } else {
                RedBlackTree.RedTree redTree;
                List zipFrom = this.findDepth$1(zipper, smallerDepth);
                if (leftMost$1) {
                    RedBlackTree.Tree tree5 = (RedBlackTree.Tree)zipFrom.head();
                    RedBlackTree.Tree<A, B> tree6 = blkNewLeft;
                    Object b = tree.value;
                    Object a = tree.key;
                    redTree = new RedBlackTree.RedTree(a, b, tree6, tree5);
                } else {
                    RedBlackTree.Tree<A, B> tree7 = blkNewRight;
                    RedBlackTree.Tree tree8 = (RedBlackTree.Tree)zipFrom.head();
                    Object b = tree.value;
                    Object a = tree.key;
                    redTree = new RedBlackTree.RedTree(a, b, tree8, tree7);
                }
                RedBlackTree.RedTree union2 = redTree;
                RedBlackTree.Tree zippedTree = ((LinearSeqOptimized)zipFrom.tail()).foldLeft(union2, new Serializable(leftMost$1){
                    public static final long serialVersionUID;
                    private final boolean leftMost$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final RedBlackTree.Tree<A, B> apply(RedBlackTree.Tree<A, B> tree, RedBlackTree.Tree<A, B> node) {
                        return this.leftMost$1 ? RedBlackTree$.MODULE$.scala$collection$immutable$RedBlackTree$$balanceLeft(RedBlackTree$.MODULE$.scala$collection$immutable$RedBlackTree$$isBlackTree(node), node.key, node.value, tree, node.right) : RedBlackTree$.MODULE$.scala$collection$immutable$RedBlackTree$$balanceRight(RedBlackTree$.MODULE$.scala$collection$immutable$RedBlackTree$$isBlackTree(node), node.key, node.value, node.left, tree);
                    }
                    {
                        this.leftMost$1 = bl;
                    }
                });
                tree2 = zippedTree;
            }
            return tree2;
        }
        throw new MatchError(tuple4);
    }

    private final RedBlackTree.Tree balance$1(Object x2, Object xv, RedBlackTree.Tree tl, RedBlackTree.Tree tr) {
        RedBlackTree.Tree tree;
        if (this.isRedTree(tl)) {
            if (this.isRedTree(tr)) {
                RedBlackTree.Tree tree2 = tr.black();
                RedBlackTree.Tree tree3 = tl.black();
                Object object = xv;
                Object object2 = x2;
                tree = new RedBlackTree.RedTree<Object, Object>(object2, object, tree3, tree2);
            } else if (this.isRedTree(tl.left)) {
                RedBlackTree.Tree tree4 = tr;
                RedBlackTree.Tree tree5 = tl.right();
                Object object = xv;
                Object object3 = x2;
                RedBlackTree.BlackTree<Object, Object> blackTree = new RedBlackTree.BlackTree<Object, Object>(object3, object, tree5, tree4);
                RedBlackTree.Tree tree6 = tl.left().black();
                Object b = tl.value;
                Object a = tl.key;
                tree = new RedBlackTree.RedTree<Object, Object>(a, b, tree6, blackTree);
            } else if (this.isRedTree(tl.right)) {
                RedBlackTree.Tree tree7 = tl.right().left();
                RedBlackTree.Tree tree8 = tl.left();
                Object b = tl.value();
                Object a = tl.key();
                RedBlackTree.Tree tree9 = tr;
                RedBlackTree.Tree tree10 = tl.right.right;
                Object object = xv;
                Object object4 = x2;
                RedBlackTree.BlackTree<Object, Object> blackTree = new RedBlackTree.BlackTree<Object, Object>(object4, object, tree10, tree9);
                RedBlackTree.BlackTree blackTree2 = new RedBlackTree.BlackTree(a, b, tree8, tree7);
                Object b2 = tl.right().value();
                Object a2 = tl.right.key;
                tree = new RedBlackTree.RedTree<Object, Object>(a2, b2, blackTree2, blackTree);
            } else {
                RedBlackTree.Tree tree11 = tr;
                RedBlackTree.Tree tree12 = tl;
                Object object = xv;
                Object object5 = x2;
                tree = new RedBlackTree.BlackTree<Object, Object>(object5, object, tree12, tree11);
            }
        } else if (this.isRedTree(tr)) {
            if (this.isRedTree(tr.right)) {
                RedBlackTree.Tree tree13 = tr.left();
                RedBlackTree.Tree tree14 = tl;
                Object object = xv;
                Object object6 = x2;
                RedBlackTree.Tree tree15 = tr.right.black();
                RedBlackTree.BlackTree<Object, Object> blackTree = new RedBlackTree.BlackTree<Object, Object>(object6, object, tree14, tree13);
                Object b = tr.value;
                Object a = tr.key;
                tree = new RedBlackTree.RedTree<Object, Object>(a, b, blackTree, tree15);
            } else if (this.isRedTree(tr.left)) {
                RedBlackTree.Tree tree16 = tr.left().left();
                RedBlackTree.Tree tree17 = tl;
                Object object = xv;
                Object object7 = x2;
                RedBlackTree.Tree tree18 = tr.right();
                RedBlackTree.Tree tree19 = tr.left().right();
                Object b = tr.value;
                Object a = tr.key;
                RedBlackTree.BlackTree blackTree = new RedBlackTree.BlackTree(a, b, tree19, tree18);
                RedBlackTree.BlackTree<Object, Object> blackTree3 = new RedBlackTree.BlackTree<Object, Object>(object7, object, tree17, tree16);
                Object b3 = tr.left().value();
                Object a3 = tr.left.key;
                tree = new RedBlackTree.RedTree<Object, Object>(a3, b3, blackTree3, blackTree);
            } else {
                RedBlackTree.Tree tree20 = tr;
                RedBlackTree.Tree tree21 = tl;
                Object object = xv;
                Object object8 = x2;
                tree = new RedBlackTree.BlackTree<Object, Object>(object8, object, tree21, tree20);
            }
        } else {
            RedBlackTree.Tree tree22 = tr;
            RedBlackTree.Tree tree23 = tl;
            Object object = xv;
            Object object9 = x2;
            tree = new RedBlackTree.BlackTree<Object, Object>(object9, object, tree23, tree22);
        }
        return tree;
    }

    private final RedBlackTree.Tree subl$1(RedBlackTree.Tree t) {
        if (t instanceof RedBlackTree.BlackTree) {
            return t.red();
        }
        throw package$.MODULE$.error(new StringBuilder().append((Object)"Defect: invariance violation; expected black, got ").append(t).toString());
    }

    private final RedBlackTree.Tree balLeft$1(Object x2, Object xv, RedBlackTree.Tree tl, RedBlackTree.Tree tr) {
        block5: {
            RedBlackTree.RedTree<Object, Object> redTree;
            block3: {
                block4: {
                    block2: {
                        if (!this.isRedTree(tl)) break block2;
                        RedBlackTree.Tree tree = tr;
                        RedBlackTree.Tree tree2 = tl.black();
                        Object object = xv;
                        Object object2 = x2;
                        redTree = new RedBlackTree.RedTree<Object, Object>(object2, object, tree2, tree);
                        break block3;
                    }
                    if (!this.scala$collection$immutable$RedBlackTree$$isBlackTree(tr)) break block4;
                    redTree = this.balance$1(x2, xv, tl, tr.red());
                    break block3;
                }
                if (!this.isRedTree(tr) || !this.scala$collection$immutable$RedBlackTree$$isBlackTree(tr.left)) break block5;
                RedBlackTree.Tree tree = tr.left.left;
                RedBlackTree.Tree tree3 = tl;
                Object object = xv;
                Object object3 = x2;
                RedBlackTree.Tree tree4 = this.balance$1(tr.key, tr.value, tr.left.right, this.subl$1(tr.right));
                RedBlackTree.BlackTree<Object, Object> blackTree = new RedBlackTree.BlackTree<Object, Object>(object3, object, tree3, tree);
                Object b = tr.left.value;
                Object a = tr.left.key;
                redTree = new RedBlackTree.RedTree<Object, Object>(a, b, blackTree, tree4);
            }
            return redTree;
        }
        throw package$.MODULE$.error("Defect: invariance violation");
    }

    private final RedBlackTree.Tree balRight$1(Object x2, Object xv, RedBlackTree.Tree tl, RedBlackTree.Tree tr) {
        block5: {
            RedBlackTree.RedTree<Object, Object> redTree;
            block3: {
                block4: {
                    block2: {
                        if (!this.isRedTree(tr)) break block2;
                        RedBlackTree.Tree tree = tr.black();
                        RedBlackTree.Tree tree2 = tl;
                        Object object = xv;
                        Object object2 = x2;
                        redTree = new RedBlackTree.RedTree<Object, Object>(object2, object, tree2, tree);
                        break block3;
                    }
                    if (!this.scala$collection$immutable$RedBlackTree$$isBlackTree(tl)) break block4;
                    redTree = this.balance$1(x2, xv, tl.red(), tr);
                    break block3;
                }
                if (!this.isRedTree(tl) || !this.scala$collection$immutable$RedBlackTree$$isBlackTree(tl.right)) break block5;
                RedBlackTree.Tree tree = tr;
                RedBlackTree.Tree tree3 = tl.right.right;
                Object object = xv;
                Object object3 = x2;
                RedBlackTree.BlackTree<Object, Object> blackTree = new RedBlackTree.BlackTree<Object, Object>(object3, object, tree3, tree);
                RedBlackTree.Tree tree4 = this.balance$1(tl.key, tl.value, this.subl$1(tl.left), tl.right.left);
                Object b = tl.right.value;
                Object a = tl.right.key;
                redTree = new RedBlackTree.RedTree<Object, Object>(a, b, tree4, blackTree);
            }
            return redTree;
        }
        throw package$.MODULE$.error("Defect: invariance violation");
    }

    private final RedBlackTree.Tree delLeft$1(RedBlackTree.Tree tree, Object object, Ordering ordering) {
        RedBlackTree.Tree tree2;
        if (this.scala$collection$immutable$RedBlackTree$$isBlackTree(tree.left)) {
            tree2 = this.balLeft$1(tree.key, tree.value, this.del(tree.left, object, ordering), tree.right);
        } else {
            RedBlackTree.Tree tree3 = tree.right;
            RedBlackTree.Tree tree4 = this.del(tree.left, object, ordering);
            Object b = tree.value;
            Object a = tree.key;
            tree2 = new RedBlackTree.RedTree(a, b, tree4, tree3);
        }
        return tree2;
    }

    private final RedBlackTree.Tree delRight$1(RedBlackTree.Tree tree, Object object, Ordering ordering) {
        RedBlackTree.Tree tree2;
        if (this.scala$collection$immutable$RedBlackTree$$isBlackTree(tree.right)) {
            tree2 = this.balRight$1(tree.key, tree.value, tree.left, this.del(tree.right, object, ordering));
        } else {
            RedBlackTree.Tree tree3 = this.del(tree.right, object, ordering);
            RedBlackTree.Tree tree4 = tree.left;
            Object b = tree.value;
            Object a = tree.key;
            tree2 = new RedBlackTree.RedTree(a, b, tree4, tree3);
        }
        return tree2;
    }

    private final RedBlackTree.Tree append$1(RedBlackTree.Tree tl, RedBlackTree.Tree tr) {
        block13: {
            RedBlackTree.Tree tree;
            block8: {
                block12: {
                    block11: {
                        block10: {
                            block9: {
                                block7: {
                                    if (tl != null) break block7;
                                    tree = tr;
                                    break block8;
                                }
                                if (tr != null) break block9;
                                tree = tl;
                                break block8;
                            }
                            if (!this.isRedTree(tl) || !this.isRedTree(tr)) break block10;
                            RedBlackTree.Tree bc = this.append$1(tl.right, tr.left);
                            if (this.isRedTree(bc)) {
                                RedBlackTree.Tree tree2 = bc.left();
                                RedBlackTree.Tree tree3 = tl.left();
                                Object b = tl.value();
                                Object a = tl.key();
                                RedBlackTree.Tree tree4 = tr.right();
                                RedBlackTree.Tree tree5 = bc.right();
                                Object b2 = tr.value;
                                Object a2 = tr.key;
                                RedBlackTree.RedTree redTree = new RedBlackTree.RedTree(a2, b2, tree5, tree4);
                                RedBlackTree.RedTree redTree2 = new RedBlackTree.RedTree(a, b, tree3, tree2);
                                Object b3 = bc.value;
                                Object a3 = bc.key;
                                tree = new RedBlackTree.RedTree(a3, b3, redTree2, redTree);
                            } else {
                                RedBlackTree.Tree tree6 = tr.right();
                                RedBlackTree.Tree tree7 = bc;
                                Object b = tr.value();
                                Object a = tr.key();
                                RedBlackTree.RedTree redTree = new RedBlackTree.RedTree(a, b, tree7, tree6);
                                RedBlackTree.Tree tree8 = tl.left();
                                Object b4 = tl.value;
                                Object a4 = tl.key;
                                tree = new RedBlackTree.RedTree(a4, b4, tree8, redTree);
                            }
                            break block8;
                        }
                        if (!this.scala$collection$immutable$RedBlackTree$$isBlackTree(tl) || !this.scala$collection$immutable$RedBlackTree$$isBlackTree(tr)) break block11;
                        RedBlackTree.Tree bc = this.append$1(tl.right, tr.left);
                        if (this.isRedTree(bc)) {
                            RedBlackTree.Tree tree9 = bc.left();
                            RedBlackTree.Tree tree10 = tl.left();
                            Object b = tl.value();
                            Object a = tl.key();
                            RedBlackTree.Tree tree11 = tr.right();
                            RedBlackTree.Tree tree12 = bc.right();
                            Object b5 = tr.value;
                            Object a5 = tr.key;
                            RedBlackTree.BlackTree blackTree = new RedBlackTree.BlackTree(a5, b5, tree12, tree11);
                            RedBlackTree.BlackTree blackTree2 = new RedBlackTree.BlackTree(a, b, tree10, tree9);
                            Object b6 = bc.value;
                            Object a6 = bc.key;
                            tree = new RedBlackTree.RedTree(a6, b6, blackTree2, blackTree);
                        } else {
                            RedBlackTree.Tree tree13 = tr.right();
                            RedBlackTree.Tree tree14 = bc;
                            Object b = tr.value();
                            Object a = tr.key();
                            tree = this.balLeft$1(tl.key, tl.value, tl.left(), new RedBlackTree.BlackTree(a, b, tree14, tree13));
                        }
                        break block8;
                    }
                    if (!this.isRedTree(tr)) break block12;
                    RedBlackTree.Tree tree15 = tr.right();
                    RedBlackTree.Tree tree16 = this.append$1(tl, tr.left());
                    Object b = tr.value;
                    Object a = tr.key;
                    tree = new RedBlackTree.RedTree(a, b, tree16, tree15);
                    break block8;
                }
                if (!this.isRedTree(tl)) break block13;
                RedBlackTree.Tree tree17 = this.append$1(tl.right(), tr);
                RedBlackTree.Tree tree18 = tl.left();
                Object b = tl.value;
                Object a = tl.key;
                tree = new RedBlackTree.RedTree(a, b, tree18, tree17);
            }
            return tree;
        }
        throw package$.MODULE$.error(new StringBuilder().append((Object)"unmatched tree on append: ").append(tl).append((Object)", ").append(tr).toString());
    }

    private final List unzip$1(List zipper, boolean leftMost) {
        RedBlackTree.Tree next2;
        RedBlackTree.Tree tree;
        while ((tree = (next2 = leftMost ? ((RedBlackTree.Tree)zipper.head()).left : ((RedBlackTree.Tree)zipper.head()).right)) != null) {
            RedBlackTree.Tree node;
            RedBlackTree.Tree tree2 = node = tree;
            zipper = zipper.$colon$colon(tree2);
        }
        return zipper;
    }

    private final Tuple4 unzipBoth$1(RedBlackTree.Tree left, RedBlackTree.Tree right, List leftZipper, List rightZipper, int smallerDepth) {
        block10: {
            Tuple4<Nil$, Boolean, Boolean, Integer> tuple4;
            block8: {
                block9: {
                    block7: {
                        while (true) {
                            if (this.scala$collection$immutable$RedBlackTree$$isBlackTree(left) && this.scala$collection$immutable$RedBlackTree$$isBlackTree(right)) {
                                RedBlackTree.Tree tree = left;
                                RedBlackTree.Tree tree2 = right;
                                ++smallerDepth;
                                rightZipper = rightZipper.$colon$colon(tree2);
                                leftZipper = leftZipper.$colon$colon(tree);
                                right = right.left;
                                left = left.right;
                                continue;
                            }
                            if (this.isRedTree(left) && this.isRedTree(right)) {
                                RedBlackTree.Tree tree = left;
                                RedBlackTree.Tree tree3 = right;
                                rightZipper = rightZipper.$colon$colon(tree3);
                                leftZipper = leftZipper.$colon$colon(tree);
                                right = right.left;
                                left = left.right;
                                continue;
                            }
                            if (this.isRedTree(right)) {
                                RedBlackTree.Tree tree = right;
                                rightZipper = rightZipper.$colon$colon(tree);
                                right = right.left;
                                continue;
                            }
                            if (!this.isRedTree(left)) break;
                            RedBlackTree.Tree tree = left;
                            leftZipper = leftZipper.$colon$colon(tree);
                            left = left.right;
                        }
                        if (left != null || right != null) break block7;
                        tuple4 = new Tuple4<Nil$, Boolean, Boolean, Integer>(Nil$.MODULE$, BoxesRunTime.boxToBoolean(true), BoxesRunTime.boxToBoolean(false), BoxesRunTime.boxToInteger(smallerDepth));
                        break block8;
                    }
                    if (left != null || !this.scala$collection$immutable$RedBlackTree$$isBlackTree(right)) break block9;
                    RedBlackTree.Tree tree = right;
                    Tuple4<List, Boolean, Boolean, Integer> tuple42 = new Tuple4<List, Boolean, Boolean, Integer>(this.unzip$1(rightZipper.$colon$colon(tree), true), BoxesRunTime.boxToBoolean(false), BoxesRunTime.boxToBoolean(true), BoxesRunTime.boxToInteger(smallerDepth));
                    tuple4 = tuple42;
                    break block8;
                }
                if (!this.scala$collection$immutable$RedBlackTree$$isBlackTree(left) || right != null) break block10;
                RedBlackTree.Tree tree = left;
                Tuple4<List, Boolean, Boolean, Integer> tuple43 = new Tuple4<List, Boolean, Boolean, Integer>(this.unzip$1(leftZipper.$colon$colon(tree), false), BoxesRunTime.boxToBoolean(false), BoxesRunTime.boxToBoolean(false), BoxesRunTime.boxToInteger(smallerDepth));
                tuple4 = tuple43;
            }
            return tuple4;
        }
        throw package$.MODULE$.error(new StringBuilder().append((Object)"unmatched trees in unzip: ").append(left).append((Object)", ").append(right).toString());
    }

    private final boolean gd1$1(RedBlackTree.Tree tree, List list2) {
        return this.scala$collection$immutable$RedBlackTree$$isBlackTree(tree);
    }

    private final List findDepth$1(List zipper, int depth) {
        List list2;
        while ((list2 = zipper) instanceof $colon$colon) {
            List list3;
            List tail2;
            $colon$colon $colon$colon = ($colon$colon)list2;
            RedBlackTree.Tree tree = (RedBlackTree.Tree)$colon$colon.hd$1();
            RedBlackTree.Tree head2 = tree;
            if (this.gd1$1(head2, tail2 = (list3 = $colon$colon.tl$1()))) {
                if (depth == 1) {
                    return zipper;
                }
                --depth;
                zipper = tail2;
                continue;
            }
            zipper = list3;
        }
        Nil$ nil$ = Nil$.MODULE$;
        List list4 = list2;
        if (!(nil$ != null ? !((Object)nil$).equals(list4) : list4 != null)) {
            throw package$.MODULE$.error("Defect: unexpected empty zipper while computing range");
        }
        throw new MatchError(list2);
    }

    private RedBlackTree$() {
        MODULE$ = this;
    }
}

