/*
 * Decompiled with CFR 0.152.
 */
package scala.actors.remote;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import scala.MatchError;
import scala.ScalaObject;
import scala.actors.Debug$;
import scala.actors.remote.Node;
import scala.actors.remote.TcpService;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.StringAdd;

@ScalaSignature(bytes="\u0006\u0001E4\u0011\"\u0001\u0002\u0005\u0002\u0003\u0005\t\u0001\u0002\u0005\u0003!Q\u001b\u0007oU3sm&\u001cWmV8sW\u0016\u0014(BA\u0002\u0005\u0003\u0019\u0011X-\\8uK*\u0011QAB\u0001\u0007C\u000e$xN]:\u000b\u0003\u001d\tQa]2bY\u0006\u001c2\u0001A\u0005\u0012!\tQq\"D\u0001\f\u0015\taQ\"\u0001\u0003mC:<'\"\u0001\b\u0002\t)\fg/Y\u0005\u0003!-\u0011a\u0001\u00165sK\u0006$\u0007C\u0001\n\u0014\u001b\u00051\u0011B\u0001\u000b\u0007\u0005-\u00196-\u00197b\u001f\nTWm\u0019;\t\u0011Y\u0001!\u0011!Q\u0001\na\ta\u0001]1sK:$8\u0001\u0001\t\u00033ii\u0011AA\u0005\u00037\t\u0011!\u0002V2q'\u0016\u0014h/[2f\u0011!i\u0002A!A!\u0002\u0013q\u0012AA:p!\ty\"%D\u0001!\u0015\t\tS\"A\u0002oKRL!a\t\u0011\u0003\rM{7m[3u\u0011\u0015)\u0003\u0001\"\u0001'\u0003\u0019a\u0014N\\5u}Q\u0019q\u0005K\u0015\u0011\u0005e\u0001\u0001\"\u0002\f%\u0001\u0004A\u0002\"B\u000f%\u0001\u0004q\u0002bB\u0016\u0001\u0005\u0004%\t\u0001L\u0001\u0007I\u0006$\u0018-\u001b8\u0016\u00035\u0002\"AL\u0019\u000e\u0003=R!\u0001M\u0007\u0002\u0005%|\u0017B\u0001\u001a0\u0005=!\u0015\r^1J]B,Ho\u0015;sK\u0006l\u0007B\u0002\u001b\u0001A\u0003%Q&A\u0004eCR\f\u0017N\u001c\u0011\t\u000fY\u0002!\u0019!C\u0001o\u00059A-\u0019;b_V$X#\u0001\u001d\u0011\u00059J\u0014B\u0001\u001e0\u0005A!\u0015\r^1PkR\u0004X\u000f^*ue\u0016\fW\u000e\u0003\u0004=\u0001\u0001\u0006I\u0001O\u0001\tI\u0006$\u0018m\\;uA!9a\b\u0001a\u0001\n\u0003y\u0014!D2p]:,7\r^3e\u001d>$W-F\u0001A!\tI\u0012)\u0003\u0002C\u0005\t!aj\u001c3f\u0011\u001d!\u0005\u00011A\u0005\u0002\u0015\u000b\u0011cY8o]\u0016\u001cG/\u001a3O_\u0012,w\fJ3r)\t1\u0015\n\u0005\u0002\u0013\u000f&\u0011\u0001J\u0002\u0002\u0005+:LG\u000fC\u0004K\u0007\u0006\u0005\t\u0019\u0001!\u0002\u0007a$\u0013\u0007\u0003\u0004M\u0001\u0001\u0006K\u0001Q\u0001\u000fG>tg.Z2uK\u0012tu\u000eZ3!\u0011\u0015q\u0005\u0001\"\u0001P\u0003!\u0019XM\u001c3O_\u0012,GC\u0001$Q\u0011\u0015\tV\n1\u0001A\u0003\u0005q\u0007\"B*\u0001\t\u0003!\u0016\u0001\u0003:fC\u0012tu\u000eZ3\u0016\u0003\u0019CQA\u0016\u0001\u0005\u0002]\u000b\u0001\u0002\u001e:b]Nl\u0017\u000e\u001e\u000b\u0003\rbCQ!W+A\u0002i\u000bA\u0001Z1uCB\u0019!cW/\n\u0005q3!!B!se\u0006L\bC\u0001\n_\u0013\tyfA\u0001\u0003CsR,\u0007bB1\u0001\u0001\u0004%\tAY\u0001\beVtg.\u001b8h+\u0005\u0019\u0007C\u0001\ne\u0013\t)gAA\u0004C_>dW-\u00198\t\u000f\u001d\u0004\u0001\u0019!C\u0001Q\u0006Y!/\u001e8oS:<w\fJ3r)\t1\u0015\u000eC\u0004KM\u0006\u0005\t\u0019A2\t\r-\u0004\u0001\u0015)\u0003d\u0003!\u0011XO\u001c8j]\u001e\u0004\u0003\"B7\u0001\t\u0003!\u0016\u0001\u00025bYRDQa\u001c\u0001\u0005BA\f1A];o)\u00051\u0005")
public class TcpServiceWorker
extends Thread
implements ScalaObject {
    private final TcpService parent;
    private final Socket so;
    private final DataInputStream datain;
    private final DataOutputStream dataout;
    private Node connectedNode;
    private boolean running;

    public DataInputStream datain() {
        return this.datain;
    }

    public DataOutputStream dataout() {
        return this.dataout;
    }

    public Node connectedNode() {
        return this.connectedNode;
    }

    public void connectedNode_$eq(Node node) {
        this.connectedNode = node;
    }

    public void sendNode(Node n) {
        this.connectedNode_$eq(n);
        this.parent.serializer().writeObject(this.dataout(), this.parent.node());
    }

    public void readNode() {
        Object node = this.parent.serializer().readObject(this.datain());
        if (node instanceof Node) {
            Node temp25 = (Node)node;
            this.connectedNode_$eq(temp25);
            this.parent.addConnection(temp25, this);
            return;
        }
        throw new MatchError(node);
    }

    public void transmit(byte[] data2) {
        synchronized (this) {
            Debug$.MODULE$.info(new StringAdd(this).$plus(": transmitting data..."));
            this.dataout().writeInt(data2.length);
            this.dataout().write(data2);
            this.dataout().flush();
            return;
        }
    }

    public boolean running() {
        return this.running;
    }

    public void running_$eq(boolean bl) {
        this.running = bl;
    }

    public void halt() {
        synchronized (this) {
            this.so.close();
            this.running_$eq(false);
            return;
        }
    }

    public void run() {
        try {
            while (this.running()) {
                Object msg = this.parent.serializer().readObject(this.datain());
                this.parent.kernel().processMsg(this.connectedNode(), msg);
            }
        }
        catch (Exception exception) {
            Debug$.MODULE$.info(new StringBuilder().append((Object)new StringAdd(this).$plus(": caught ")).append(exception).toString());
            this.parent.nodeDown(this.connectedNode());
        }
        catch (IOException iOException) {
            Debug$.MODULE$.info(new StringBuilder().append((Object)new StringAdd(this).$plus(": caught ")).append(iOException).toString());
            this.parent.nodeDown(this.connectedNode());
        }
        Debug$.MODULE$.info(new StringBuilder().append((Object)new StringAdd(this).$plus(": service terminated at ")).append(this.parent.node()).toString());
    }

    public TcpServiceWorker(TcpService parent, Socket so) {
        this.parent = parent;
        this.so = so;
        this.datain = new DataInputStream(so.getInputStream());
        this.dataout = new DataOutputStream(so.getOutputStream());
        this.running = true;
    }
}

