/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.server;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclEntryPermission;
import java.nio.file.attribute.AclEntryType;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.UserPrincipal;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.scalasbt.ipcsocket.UnixDomainServerSocket;
import org.scalasbt.ipcsocket.UnixDomainSocket;
import org.scalasbt.ipcsocket.UnixDomainSocketLibraryProvider;
import org.scalasbt.ipcsocket.Win32NamedPipeServerSocket;
import sbt.ConnectionType;
import sbt.ConnectionType$Local$;
import sbt.ConnectionType$Tcp$;
import sbt.ServerAuthentication;
import sbt.ServerAuthentication$Token$;
import sbt.internal.bsp.BuildServerConnection$;
import sbt.internal.protocol.PortFile;
import sbt.internal.protocol.PortFile$;
import sbt.internal.protocol.TokenFile;
import sbt.internal.protocol.TokenFile$;
import sbt.internal.server.AlreadyRunningException;
import sbt.internal.server.Server$;
import sbt.internal.server.Server$JsonProtocol$;
import sbt.internal.server.ServerConnection;
import sbt.internal.server.ServerInstance;
import sbt.internal.util.ErrorHandling$;
import sbt.internal.util.Util$;
import sbt.io.IO$;
import sbt.io.RichFile;
import sbt.io.syntax$;
import sbt.util.Logger;
import scala.Function0;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.collection.immutable.Set;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.sys.package$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import sjsonnew.shaded.scalajson.ast.unsafe.JValue;
import sjsonnew.support.scalajson.unsafe.CompactPrinter$;
import sjsonnew.support.scalajson.unsafe.Converter$;

public final class Server$ {
    public static Server$ MODULE$;

    static {
        new Server$();
    }

    public ServerInstance start(ServerConnection connection, Function2<Socket, ServerInstance, BoxedUnit> onIncomingSocket, Logger log) {
        return new ServerInstance(connection, log, onIncomingSocket){
            private final AtomicBoolean sbt$internal$server$Server$$anon$$running;
            private final Promise<BoxedUnit> sbt$internal$server$Server$$anon$$p;
            private final Future<BoxedUnit> ready;
            private final SecureRandom rand;
            private String token;
            public final AtomicReference<ServerSocket> sbt$internal$server$Server$$anon$$serverSocketHolder;
            private final Thread serverThread;
            public final ServerConnection connection$1;
            public final Logger log$1;
            public final Function2 onIncomingSocket$1;

            public AtomicBoolean sbt$internal$server$Server$$anon$$running() {
                return this.sbt$internal$server$Server$$anon$$running;
            }

            public Promise<BoxedUnit> sbt$internal$server$Server$$anon$$p() {
                return this.sbt$internal$server$Server$$anon$$p;
            }

            public Future<BoxedUnit> ready() {
                return this.ready;
            }

            private Thread serverThread() {
                return this.serverThread;
            }

            public void sbt$internal$server$Server$$anon$$tryClient(Function0<Socket> f) {
                if (this.connection$1.portfile().exists()) {
                    Try try_ = Try$.MODULE$.apply(f);
                    if (try_ instanceof Failure) {
                        return;
                    }
                    if (try_ instanceof Success) {
                        Success success = (Success)try_;
                        Socket socket = (Socket)success.value();
                        socket.close();
                        throw new AlreadyRunningException();
                    }
                    throw new MatchError((Object)try_);
                }
            }

            public ServerSocket sbt$internal$server$Server$$anon$$addServerError(Function0<ServerSocket> f) {
                return (ServerSocket)ErrorHandling$.MODULE$.translate((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("server failed to start on ").append($this.connection$1.shortName()).append(". ").toString(), f);
            }

            public synchronized boolean authenticate(String challenge) {
                String string = this.token;
                String string2 = challenge;
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    this.token = this.nextToken();
                    this.writeTokenfile();
                    return true;
                }
                return false;
            }

            private String nextToken() {
                return new BigInteger(128, this.rand).toString();
            }

            public void shutdown() {
                this.log$1.info((Function0 & Serializable & scala.Serializable)() -> "shutting down sbt server");
                if (this.connection$1.portfile().exists()) {
                    IO$.MODULE$.delete(this.connection$1.portfile());
                }
                if (this.connection$1.tokenfile().exists()) {
                    IO$.MODULE$.delete(this.connection$1.tokenfile());
                }
                this.sbt$internal$server$Server$$anon$$running().set(false);
                ServerSocket serverSocket = this.sbt$internal$server$Server$$anon$$serverSocketHolder.getAndSet(null);
                if (serverSocket == null) {
                    return;
                }
                serverSocket.close();
            }

            private void writeTokenfile() {
                String uri = this.connection$1.shortName();
                TokenFile t = TokenFile$.MODULE$.apply(uri, this.token);
                JValue jsonToken = (JValue)Converter$.MODULE$.toJson((Object)t, Server$JsonProtocol$.MODULE$.TokenFileFormat()).get();
                if (this.connection$1.tokenfile().exists()) {
                    IO$.MODULE$.delete(this.connection$1.tokenfile());
                }
                IO$.MODULE$.touch(this.connection$1.tokenfile(), IO$.MODULE$.touch$default$2());
                this.ownerOnly(this.connection$1.tokenfile());
                IO$.MODULE$.write(this.connection$1.tokenfile(), CompactPrinter$.MODULE$.apply(jsonToken), IO$.MODULE$.utf8(), true);
            }

            private void ownerOnly(File file) {
                File file2 = file;
                if (IO$.MODULE$.isPosix()) {
                    IO$.MODULE$.chmod("rw-------", file);
                    return;
                }
                if (IO$.MODULE$.hasAclFileAttributeView()) {
                    AclFileAttributeView view = new RichFile(syntax$.MODULE$.fileToRichFile(file)).aclFileAttributeView();
                    view.setAcl(Collections.singletonList(anon.1.acl$1(view.getOwner())));
                    return;
                }
            }

            public void sbt$internal$server$Server$$anon$$writePortfile() {
                PortFile portFile;
                String uri = this.connection$1.shortName();
                Set<ServerAuthentication> set = this.connection$1.auth();
                if (this.connection$1.auth().apply((Object)ServerAuthentication$Token$.MODULE$)) {
                    this.writeTokenfile();
                    portFile = PortFile$.MODULE$.apply(uri, Option$.MODULE$.apply((Object)this.connection$1.tokenfile().toString()), Option$.MODULE$.apply((Object)IO$.MODULE$.toURI(this.connection$1.tokenfile()).toString()));
                } else {
                    portFile = PortFile$.MODULE$.apply(uri, (Option)None$.MODULE$, (Option)None$.MODULE$);
                }
                PortFile p = portFile;
                JValue json = (JValue)Converter$.MODULE$.toJson((Object)p, Server$JsonProtocol$.MODULE$.PortFileFormat()).get();
                IO$.MODULE$.write(this.connection$1.portfile(), CompactPrinter$.MODULE$.apply(json), IO$.MODULE$.write$default$3(), IO$.MODULE$.write$default$4());
            }

            public void prepareSocketfile() {
                if (this.connection$1.socketfile().exists()) {
                    IO$.MODULE$.delete(this.connection$1.socketfile());
                }
                IO$.MODULE$.createDirectory(this.connection$1.socketfile().getParentFile());
            }

            private static final AclEntry acl$1(UserPrincipal owner) {
                AclEntry.Builder builder = AclEntry.newBuilder();
                builder.setPrincipal(owner);
                builder.setPermissions(AclEntryPermission.values());
                builder.setType(AclEntryType.ALLOW);
                return builder.build();
            }
            {
                this.connection$1 = connection$1;
                this.log$1 = log$1;
                this.onIncomingSocket$1 = onIncomingSocket$1;
                this.sbt$internal$server$Server$$anon$$running = new AtomicBoolean(false);
                this.sbt$internal$server$Server$$anon$$p = Promise$.MODULE$.apply();
                this.ready = this.sbt$internal$server$Server$$anon$$p().future();
                this.rand = new SecureRandom();
                this.token = this.nextToken();
                this.sbt$internal$server$Server$$anon$$serverSocketHolder = new AtomicReference<V>();
                this.serverThread = new Thread(this){
                    private final /* synthetic */ anon.1 $outer;

                    public void run() {
                        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                            boolean bl = false;
                            ConnectionType connectionType = null;
                            ConnectionType connectionType2 = $this.$outer.connection$1.connectionType();
                            if (ConnectionType$Local$.MODULE$.equals(connectionType2)) {
                                bl = true;
                                connectionType = connectionType2;
                                if (Util$.MODULE$.isWindows()) {
                                    return $this.$outer.sbt$internal$server$Server$$anon$$addServerError((Function0<ServerSocket>)(Function0 & Serializable & scala.Serializable)() -> new Win32NamedPipeServerSocket($this.$outer.connection$1.pipeName(), $this.$outer.connection$1.useJni(), $this.$outer.connection$1.windowsServerSecurityLevel()));
                                }
                            }
                            if (bl) {
                                int maxSocketLength = UnixDomainSocketLibraryProvider.maxSocketLength((boolean)$this.$outer.connection$1.useJni()) - 1;
                                String path = $this.$outer.connection$1.socketfile().getAbsolutePath();
                                if (path.length() > maxSocketLength) {
                                    throw package$.MODULE$.error(new StringBuilder(140).append("socket file absolute path too long; either switch to another connection type or define a short \"SBT_GLOBAL_SERVER_DIR\" value. ").append("Current path: ").append(path).toString());
                                }
                                $this.$outer.sbt$internal$server$Server$$anon$$tryClient((Function0<Socket>)(Function0 & Serializable & scala.Serializable)() -> new UnixDomainSocket(path, $this.$outer.connection$1.useJni()));
                                $this.$outer.prepareSocketfile();
                                return $this.$outer.sbt$internal$server$Server$$anon$$addServerError((Function0<ServerSocket>)(Function0 & Serializable & scala.Serializable)() -> new UnixDomainServerSocket(path, $this.$outer.connection$1.useJni()));
                            }
                            if (ConnectionType$Tcp$.MODULE$.equals(connectionType2)) {
                                $this.$outer.sbt$internal$server$Server$$anon$$tryClient((Function0<Socket>)(Function0 & Serializable & scala.Serializable)() -> new Socket(InetAddress.getByName($this.$outer.connection$1.host()), $this.$outer.connection$1.port()));
                                return $this.$outer.sbt$internal$server$Server$$anon$$addServerError((Function0<ServerSocket>)(Function0 & Serializable & scala.Serializable)() -> new ServerSocket($this.$outer.connection$1.port(), 50, InetAddress.getByName($this.$outer.connection$1.host())));
                            }
                            throw new MatchError((Object)connectionType2);
                        });
                        if (try_ instanceof Failure) {
                            Failure failure = (Failure)try_;
                            Throwable e = failure.exception();
                            this.$outer.sbt$internal$server$Server$$anon$$p().failure(e);
                            return;
                        }
                        if (try_ instanceof Success) {
                            Success success = (Success)try_;
                            ServerSocket serverSocket = (ServerSocket)success.value();
                            serverSocket.setSoTimeout(5000);
                            ServerSocket serverSocket2 = this.$outer.sbt$internal$server$Server$$anon$$serverSocketHolder.getAndSet(serverSocket);
                            if (serverSocket2 == null) {
                            } else {
                                serverSocket2.close();
                            }
                            this.$outer.log$1.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("sbt server started at ").append($this.$outer.connection$1.shortName()).toString());
                            this.$outer.sbt$internal$server$Server$$anon$$writePortfile();
                            if (this.$outer.connection$1.bspEnabled()) {
                                this.$outer.log$1.debug((Function0 & Serializable & scala.Serializable)() -> "Writing bsp connection file");
                                BuildServerConnection$.MODULE$.writeConnectionFile(this.$outer.connection$1.appConfiguration().provider().id().version(), this.$outer.connection$1.appConfiguration().baseDirectory());
                            }
                            this.$outer.sbt$internal$server$Server$$anon$$running().set(true);
                            this.$outer.sbt$internal$server$Server$$anon$$p().success((Object)BoxedUnit.UNIT);
                            while (this.$outer.sbt$internal$server$Server$$anon$$running().get()) {
                                Object object;
                                try {
                                    Socket socket = serverSocket.accept();
                                    object = this.$outer.onIncomingSocket$1.apply((Object)socket, (Object)this.$outer);
                                }
                                catch (Throwable throwable) {
                                    IOException iOException;
                                    Throwable throwable2 = throwable;
                                    if (throwable2 instanceof IOException && (iOException = (IOException)throwable2).getMessage().contains("connect")) {
                                    } else if (throwable2 instanceof SocketTimeoutException) {
                                    } else if (throwable2 instanceof SocketException && !this.$outer.sbt$internal$server$Server$$anon$$running().get()) {
                                    } else {
                                        throw throwable;
                                    }
                                    object = BoxedUnit.UNIT;
                                }
                            }
                            ServerSocket serverSocket3 = this.$outer.sbt$internal$server$Server$$anon$$serverSocketHolder.get();
                            if (serverSocket3 == null) {
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            } else {
                                serverSocket3.close();
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            }
                            return;
                        }
                        throw new MatchError((Object)try_);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        super("sbt-socket-server");
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(sbt.internal.server.Server$$anon$1$$anon$2 ), $anonfun$run$7(sbt.internal.server.Server$$anon$1$$anon$2 ), $anonfun$run$8(), $anonfun$run$2(sbt.internal.server.Server$$anon$1$$anon$2 ), $anonfun$run$3(sbt.internal.server.Server$$anon$1$$anon$2 java.lang.String ), $anonfun$run$4(sbt.internal.server.Server$$anon$1$$anon$2 java.lang.String ), $anonfun$run$5(sbt.internal.server.Server$$anon$1$$anon$2 ), $anonfun$run$6(sbt.internal.server.Server$$anon$1$$anon$2 )}, serializedLambda);
                    }
                };
                this.serverThread().start();
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$addServerError$1(sbt.internal.server.Server$$anon$1 ), $anonfun$shutdown$1()}, serializedLambda);
            }
        };
    }

    private Server$() {
        MODULE$ = this;
    }
}

