/*
 * Decompiled with CFR 0.152.
 */
package sbt.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Properties;
import java.util.Random;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import sbt.internal.io.ErrorHandling$;
import sbt.internal.io.Milli$;
import sbt.internal.io.Retry$;
import sbt.io.AllPassFilter$;
import sbt.io.CopyOptions;
import sbt.io.CopyOptions$;
import sbt.io.GlobFilter$;
import sbt.io.NameFilter;
import sbt.io.Path$;
import sbt.io.PathFinder;
import sbt.io.PathFinder$;
import sbt.io.RichFile;
import sbt.io.Using;
import sbt.io.Using$;
import sbt.nio.file.FileAttributes;
import sbt.nio.file.FileTreeView$;
import scala.Function$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.Set;
import scala.collection.SetOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.TreeSet;
import scala.collection.immutable.TreeSet$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.control.Exception$;
import scala.util.control.NonFatal$;

public final class IO$ {
    public static final IO$ MODULE$ = new IO$();
    private static Random random;
    private static FileSystem jrtFs;
    private static boolean hasPosixFileAttributeView;
    private static boolean hasFileOwnerAttributeView;
    private static boolean hasDosFileAttributeView;
    private static boolean hasAclFileAttributeView;
    private static boolean hasBasicFileAttributeView;
    private static boolean hasUserDefinedFileAttributeView;
    private static scala.collection.immutable.Set<String> supportedFileAttributeViews;
    private static final int MaximumTries;
    private static final File temporaryDirectory;
    private static final int BufferSize;
    private static final String FileScheme;
    private static final String Newline;
    private static final Charset utf8;
    private static final Pattern PathSeparatorPattern;
    private static volatile int bitmap$0;

    static {
        MaximumTries = 10;
        temporaryDirectory = new File(System.getProperty("java.io.tmpdir"));
        BufferSize = 8192;
        FileScheme = "file";
        Newline = System.getProperty("line.separator");
        utf8 = Charset.forName("UTF-8");
        PathSeparatorPattern = Pattern.compile(File.pathSeparator);
    }

    private int MaximumTries() {
        return MaximumTries;
    }

    private Random random$lzycompute() {
        IO$ iO$ = this;
        synchronized (iO$) {
            if ((bitmap$0 & 1) == 0) {
                random = new Random();
                bitmap$0 |= 1;
            }
        }
        return random;
    }

    private Random random() {
        return (bitmap$0 & 1) == 0 ? this.random$lzycompute() : random;
    }

    public File temporaryDirectory() {
        return temporaryDirectory;
    }

    private int BufferSize() {
        return BufferSize;
    }

    public String FileScheme() {
        return FileScheme;
    }

    public String Newline() {
        return Newline;
    }

    public Charset utf8() {
        return utf8;
    }

    private FileSystem jrtFs$lzycompute() {
        IO$ iO$ = this;
        synchronized (iO$) {
            if ((bitmap$0 & 2) == 0) {
                jrtFs = FileSystems.getFileSystem(URI.create("jrt:/"));
                bitmap$0 |= 2;
            }
        }
        return jrtFs;
    }

    private FileSystem jrtFs() {
        return (bitmap$0 & 2) == 0 ? this.jrtFs$lzycompute() : jrtFs;
    }

    public Path classLocationPath(Class<?> cl) {
        URL u = this.classLocation(cl);
        String string = u.getProtocol();
        String string2 = this.FileScheme();
        String string3 = string;
        Object object = !(string2 != null ? !string2.equals(string3) : string3 != null) ? Option$.MODULE$.apply((Object)this.toFile(u).toPath()) : ("jar".equals(string) ? this.urlAsFile(u).map((Function1 & Serializable)x$1 -> x$1.toPath()) : ("jrt".equals(string) ? Option$.MODULE$.apply((Object)this.jrtFs().getPath(u.getPath(), new String[0])) : None$.MODULE$));
        Option p = object;
        return (Path)p.getOrElse((Function0 & Serializable)() -> scala.sys.package$.MODULE$.error(new StringBuilder(32).append("Unable to create File from ").append(u).append(" for ").append(cl).toString()));
    }

    public <A> Path classLocationPath(Manifest<A> mf) {
        return this.classLocationPath(mf.runtimeClass());
    }

    public Option<File> classLocationFileOption(Class<?> cl) {
        URL u = this.classLocation(cl);
        return this.urlAsFile(u);
    }

    public <A> Option<File> classLocationFileOption(Manifest<A> mf) {
        return this.classLocationFileOption(mf.runtimeClass());
    }

    public File classLocationFile(Class<?> cl) {
        return (File)this.classLocationFileOption(cl).getOrElse((Function0 & Serializable)() -> scala.sys.package$.MODULE$.error(new StringBuilder(27).append("Unable to create File from ").append(cl).toString()));
    }

    public <T> File classLocationFile(Manifest<T> mf) {
        return this.classLocationFile(mf.runtimeClass());
    }

    public URL classLocation(Class<?> cl) {
        URL uRL;
        String clsfile = new StringBuilder(6).append(cl.getName().replace('.', '/')).append(".class").toString();
        try {
            uRL = (URL)IO$.localcl$1(cl).orElse((Function0 & Serializable)() -> IO$.syscl$1(clsfile)).map((Function1 & Serializable)url -> {
                String path;
                int end;
                String path2;
                int end2;
                String string = url.getProtocol();
                URL uRL = "jar".equals(string) ? new URL((end2 = (path2 = url.getPath()).indexOf(33)) == -1 ? path2 : path2.substring(0, end2)) : ("jrt".equals(string) ? new URL("jrt", null, (end = (path = url.getPath()).indexOf(47, 1)) == -1 ? path : path.substring(0, end)) : url);
                return uRL;
            }).getOrElse((Function0 & Serializable)() -> scala.sys.package$.MODULE$.error(new StringBuilder(22).append("No class location for ").append(cl).toString()));
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable e = (Throwable)option.get();
                e.printStackTrace();
                throw e;
            }
            throw throwable;
        }
        return uRL;
    }

    public <A> URL classLocation(Manifest<A> mf) {
        return this.classLocation(mf.runtimeClass());
    }

    public <T> URL classfileLocation(Manifest<T> mf) {
        return this.classfileLocation(mf.runtimeClass());
    }

    public URL classfileLocation(Class<?> cl) {
        URL uRL;
        String clsfile = new StringBuilder(6).append(cl.getName().replace('.', '/')).append(".class").toString();
        try {
            uRL = (URL)IO$.localcl$2(cl, clsfile).orElse((Function0 & Serializable)() -> IO$.syscl$2(clsfile)).getOrElse((Function0 & Serializable)() -> scala.sys.package$.MODULE$.error(new StringBuilder(22).append("No class location for ").append(cl).toString()));
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable e = (Throwable)option.get();
                e.printStackTrace();
                throw e;
            }
            throw throwable;
        }
        return uRL;
    }

    public File toFile(URL url) {
        File file;
        try {
            file = this.uriToFile(url.toURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            file = new File(url.getPath());
        }
        return file;
    }

    public File toFile(URI uri) {
        File file;
        try {
            file = this.uriToFile(uri);
        }
        catch (URISyntaxException uRISyntaxException) {
            file = new File(uri.getPath());
        }
        return file;
    }

    public File asFile(URL url) {
        return (File)this.urlAsFile(url).getOrElse((Function0 & Serializable)() -> scala.sys.package$.MODULE$.error(new StringBuilder(19).append("URL is not a file: ").append(url).toString()));
    }

    public Option<File> urlAsFile(URL url) {
        String path;
        int end;
        String string = url.getProtocol();
        String string2 = this.FileScheme();
        String string3 = string;
        Object object = !(string2 != null ? !string2.equals(string3) : string3 != null) ? new Some((Object)this.toFile(url)) : ("jar".equals(string) ? new Some((Object)this.uriToFile((end = (path = url.getPath()).indexOf(33)) == -1 ? path : path.substring(0, end))) : None$.MODULE$);
        return object;
    }

    private File uriToFile(String uriString) {
        return this.uriToFile(new URI(uriString));
    }

    /*
     * Unable to fully structure code
     */
    private File uriToFile(URI uri) {
        block3: {
            block2: {
                part = uri.getSchemeSpecificPart();
                var6_3 = Option$.MODULE$.apply((Object)uri.getScheme());
                if (!None$.MODULE$.equals(var6_3)) break block2;
                var4_4 = true;
                break block3;
            }
            if (!(var6_3 instanceof Some)) ** GOTO lbl-1000
            var7_5 = (Some)var6_3;
            var8_6 = (String)var7_5.value();
            v0 = this.FileScheme();
            var9_7 = var8_6;
            if (!(v0 != null ? v0.equals(var9_7) == false : var9_7 != null)) {
                var4_4 = true;
            } else lbl-1000:
            // 2 sources

            {
                var4_4 = false;
            }
        }
        var3_8 = var4_4 != false;
        Predef$.MODULE$.assert(var3_8, (Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$uriToFile$1(java.net.URI ), ()Ljava/lang/String;)((URI)uri));
        var10_9 = Option$.MODULE$.apply((Object)uri.getAuthority());
        var2_10 = None$.MODULE$.equals(var10_9) && part.startsWith("/") ? new File(uri) : (part.startsWith("/") == false && part.contains(":") != false ? new File(new StringBuilder(2).append("//").append(part).toString()) : new File(part));
        return var2_10;
    }

    public void assertDirectory(File file) {
        Predef$.MODULE$.assert(file.isDirectory(), (Function0 & Serializable)() -> new StringBuilder(0).append(file.exists() ? "Not a directory: " : "Directory not found: ").append(file).toString());
    }

    public void assertDirectories(Seq<File> file2) {
        file2.foreach((Function1 & Serializable)file -> {
            IO$.MODULE$.assertDirectory(file);
            return BoxedUnit.UNIT;
        });
    }

    public Tuple2<String, String> split(String name) {
        int lastDot = name.lastIndexOf(46);
        return lastDot >= 0 ? new Tuple2((Object)name.substring(0, lastDot), (Object)name.substring(lastDot + 1)) : new Tuple2((Object)name, (Object)"");
    }

    public void touch(Iterable<File> files) {
        files.foreach((Function1 & Serializable)f -> {
            IO$.MODULE$.touch(f, IO$.MODULE$.touch$default$2());
            return BoxedUnit.UNIT;
        });
    }

    public void touch(File file, boolean setModified) {
        Retry$.MODULE$.apply((JFunction0.mcV.sp & Serializable)() -> {
            File absFile = file.getAbsoluteFile();
            MODULE$.createDirectory(absFile.getParentFile());
            boolean created = BoxesRunTime.unboxToBoolean(ErrorHandling$.MODULE$.translate((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(22).append("Could not create file ").append(absFile).toString(), (JFunction0.mcZ.sp & Serializable)() -> absFile.createNewFile()));
            if (!created && !absFile.isDirectory() && setModified && !MODULE$.setModifiedTimeOrFalse(absFile, System.currentTimeMillis())) {
                throw scala.sys.package$.MODULE$.error(new StringBuilder(45).append("Could not update last modified time for file ").append(absFile).toString());
            }
        }, (Seq<Class<? extends IOException>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[0]));
    }

    public boolean touch$default$2() {
        return true;
    }

    public void createDirectories(Iterable<File> dirs) {
        dirs.foreach((Function1 & Serializable)dir -> {
            IO$.MODULE$.createDirectory(dir);
            return BoxedUnit.UNIT;
        });
    }

    public void createDirectory(File dir) {
        Path path = dir.toPath();
        try {
            Retry$.MODULE$.apply((Function0 & Serializable)() -> {
                Path path;
                try {
                    path = Files.createDirectories(path, new FileAttribute[0]);
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (!(throwable2 instanceof IOException) || !Files.isDirectory(path, new LinkOption[0])) {
                        throw throwable;
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    path = boxedUnit;
                }
                return path;
            }, (Seq<Class<? extends IOException>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{FileAlreadyExistsException.class}));
        }
        catch (IOException e) {
            throw new IOException(new StringBuilder(2).append(IO$.failBase$1(dir)).append(": ").append(e).toString(), e);
        }
    }

    public void gzip(File in, File out) {
        File file = in;
        File file2 = out;
        Predef$.MODULE$.require(file == null ? file2 != null : !((Object)file).equals(file2), (Function0 & Serializable)() -> "Input file cannot be the same as the output file.");
        ((Using)((Object)Using$.MODULE$.fileInputStream())).apply(in, (Function1 & Serializable)inputStream -> {
            IO$.$anonfun$gzip$2(out, inputStream);
            return BoxedUnit.UNIT;
        });
    }

    public void gzip(InputStream input, OutputStream output) {
        Using$.MODULE$.gzipOutputStream().apply(output, (Function1 & Serializable)gzStream -> {
            IO$.MODULE$.transfer(input, (OutputStream)gzStream);
            return BoxedUnit.UNIT;
        });
    }

    public void gunzip(File in, File out) {
        File file = in;
        File file2 = out;
        Predef$.MODULE$.require(file == null ? file2 != null : !((Object)file).equals(file2), (Function0 & Serializable)() -> "Input file cannot be the same as the output file.");
        ((Using)((Object)Using$.MODULE$.fileInputStream())).apply(in, (Function1 & Serializable)inputStream -> {
            IO$.$anonfun$gunzip$2(out, inputStream);
            return BoxedUnit.UNIT;
        });
    }

    public void gunzip(InputStream input, OutputStream output) {
        Using$.MODULE$.gzipInputStream().apply(input, (Function1 & Serializable)gzStream -> {
            IO$.MODULE$.transfer((InputStream)gzStream, output);
            return BoxedUnit.UNIT;
        });
    }

    public scala.collection.immutable.Set<File> unzip(File from, File toDirectory, NameFilter filter, boolean preserveLastModified) {
        return (scala.collection.immutable.Set)((Using)((Object)Using$.MODULE$.fileInputStream())).apply(from, (Function1 & Serializable)in -> MODULE$.unzipStream((InputStream)in, toDirectory, filter, preserveLastModified));
    }

    public NameFilter unzip$default$3() {
        return AllPassFilter$.MODULE$;
    }

    public boolean unzip$default$4() {
        return true;
    }

    public scala.collection.immutable.Set<File> unzipURL(URL from, File toDirectory, NameFilter filter, boolean preserveLastModified) {
        return (scala.collection.immutable.Set)Using$.MODULE$.urlInputStream().apply(from, (Function1 & Serializable)in -> MODULE$.unzipStream((InputStream)in, toDirectory, filter, preserveLastModified));
    }

    public NameFilter unzipURL$default$3() {
        return AllPassFilter$.MODULE$;
    }

    public boolean unzipURL$default$4() {
        return true;
    }

    public scala.collection.immutable.Set<File> unzipStream(InputStream from, File toDirectory, NameFilter filter, boolean preserveLastModified) {
        this.createDirectory(toDirectory);
        return (scala.collection.immutable.Set)Using$.MODULE$.zipInputStream().apply(from, (Function1 & Serializable)zipInput -> MODULE$.extract((ZipInputStream)zipInput, toDirectory, filter, preserveLastModified));
    }

    public NameFilter unzipStream$default$3() {
        return AllPassFilter$.MODULE$;
    }

    public boolean unzipStream$default$4() {
        return true;
    }

    private scala.collection.immutable.Set<File> extract(ZipInputStream from, File toDirectory, NameFilter filter, boolean preserveLastModified) {
        HashSet set = new HashSet();
        this.next$1(from, filter, toDirectory, set, preserveLastModified);
        return (scala.collection.immutable.Set)((SetOps)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)).$plus$plus((IterableOnce)set);
    }

    public void transfer(File in2, File out) {
        ((Using)((Object)Using$.MODULE$.fileInputStream())).apply(in2, (Function1 & Serializable)in -> {
            IO$.MODULE$.transfer((InputStream)in, out);
            return BoxedUnit.UNIT;
        });
    }

    public void transfer(File in2, OutputStream out) {
        ((Using)((Object)Using$.MODULE$.fileInputStream())).apply(in2, (Function1 & Serializable)in -> {
            IO$.MODULE$.transfer((InputStream)in, out);
            return BoxedUnit.UNIT;
        });
    }

    public void transfer(InputStream in, File to) {
        ((Using)((Object)Using$.MODULE$.fileOutputStream(Using$.MODULE$.fileOutputStream$default$1()))).apply(to, (Function1 & Serializable)outputStream -> {
            IO$.MODULE$.transfer(in, (OutputStream)outputStream);
            return BoxedUnit.UNIT;
        });
    }

    public void transfer(InputStream in, OutputStream out) {
        this.transferImpl(in, out, false);
    }

    public void transferAndClose(InputStream in, OutputStream out) {
        this.transferImpl(in, out, true);
    }

    private void transferImpl(InputStream in, OutputStream out, boolean close) {
        try {
            byte[] buffer = new byte[this.BufferSize()];
            this.read$1(in, buffer, out);
        }
        finally {
            if (close) {
                in.close();
            }
        }
    }

    public <T> T withTemporaryDirectory(Function1<File, T> action, boolean keepDirectory) {
        Object object;
        File dir = this.createTemporaryDirectory();
        try {
            object = action.apply((Object)dir);
        }
        finally {
            if (!keepDirectory) {
                this.delete(dir);
            }
        }
        return (T)object;
    }

    public <T> T withTemporaryDirectory(Function1<File, T> action) {
        return this.withTemporaryDirectory(action, false);
    }

    public File createTemporaryDirectory() {
        return this.createUniqueDirectory(this.temporaryDirectory());
    }

    public File createUniqueDirectory(File baseDirectory) {
        return this.create$1(0, baseDirectory);
    }

    public <T> T withTemporaryFile(String prefix, String postfix, boolean keepFile, Function1<File, T> action) {
        Object object;
        File file = File.createTempFile(prefix, postfix);
        try {
            object = action.apply((Object)file);
        }
        catch (Throwable throwable) {
            Object object2 = !keepFile ? BoxesRunTime.boxToBoolean((boolean)file.delete()) : BoxedUnit.UNIT;
            throw throwable;
        }
        Object object3 = !keepFile ? BoxesRunTime.boxToBoolean((boolean)file.delete()) : BoxedUnit.UNIT;
        return (T)object;
    }

    public <T> T withTemporaryFile(String prefix, String postfix, Function1<File, T> action) {
        return this.withTemporaryFile(prefix, postfix, false, action);
    }

    public Iterable<File> jars(File dir) {
        return Predef$.MODULE$.wrapRefArray((Object[])this.listFiles(dir, GlobFilter$.MODULE$.apply("*.jar")));
    }

    public void deleteIfEmpty(Set<File> dirs) {
        HashMap isEmpty = new HashMap();
        dirs.foreach((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)IO$.visit$1(f, isEmpty, dirs)));
        isEmpty.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)IO$.$anonfun$deleteIfEmpty$4(check$ifrefutable$1))).foreach((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)IO$.$anonfun$deleteIfEmpty$5(x$2)));
    }

    public void delete(Iterable<File> files) {
        files.foreach((Function1 & Serializable)file -> {
            IO$.MODULE$.delete(file);
            return BoxedUnit.UNIT;
        });
    }

    public void deleteFilesEmptyDirs(Iterable<File> files) {
        this.delete(files);
        this.deleteEmpty$1(IO$.parents$1(files.toSet()));
    }

    public void delete(File file) {
        Retry$.MODULE$.apply((JFunction0.mcV.sp & Serializable)() -> {
            Object object;
            try {
                FileTreeView$.MODULE$.default().list(file.toPath()).foreach((Function1 & Serializable)x0$1 -> {
                    Boolean bl;
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        Path dir = (Path)tuple2._1();
                        FileAttributes attrs = (FileAttributes)tuple2._2();
                        if (attrs.isDirectory()) {
                            MODULE$.delete(dir.toFile());
                            return BoxedUnit.UNIT;
                        }
                    }
                    if (tuple2 == null) throw new MatchError((Object)tuple2);
                    Path f = (Path)tuple2._1();
                    try {
                        bl = BoxesRunTime.boxToBoolean((boolean)Files.deleteIfExists(f));
                        return bl;
                    }
                    catch (IOException iOException) {
                        bl = BoxedUnit.UNIT;
                    }
                    return bl;
                });
            }
            catch (NotDirectoryException notDirectoryException) {}
            try {
                object = BoxesRunTime.boxToBoolean((boolean)Files.deleteIfExists(file.toPath()));
            }
            catch (IOException iOException) {
                object = BoxedUnit.UNIT;
            }
        }, (Seq<Class<? extends IOException>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[0]));
    }

    public File[] listFiles(FileFilter filter, File dir) {
        return this.wrapNull(dir.listFiles(filter));
    }

    public File[] listFiles(File dir, FileFilter filter) {
        return this.wrapNull(dir.listFiles(filter));
    }

    public File[] listFiles(File dir) {
        return this.wrapNull(dir.listFiles());
    }

    public File[] wrapNull(File[] a) {
        return a == null ? new File[]{} : a;
    }

    public void jar(Iterable<Tuple2<File, String>> sources, File outputJar, java.util.jar.Manifest manifest) {
        this.archive((Seq<Tuple2<File, String>>)sources.toSeq(), outputJar, (Option<java.util.jar.Manifest>)new Some((Object)manifest));
    }

    public void zip(Iterable<Tuple2<File, String>> sources, File outputZip) {
        this.archive((Seq<Tuple2<File, String>>)sources.toSeq(), outputZip, (Option<java.util.jar.Manifest>)None$.MODULE$);
    }

    private void archive(Seq<Tuple2<File, String>> sources, File outputFile, Option<java.util.jar.Manifest> manifest) {
        if (outputFile.isDirectory()) {
            throw scala.sys.package$.MODULE$.error(new StringBuilder(38).append("Specified output file ").append(outputFile).append(" is a directory.").toString());
        }
        File file = outputFile.getParentFile();
        File file2 = file == null ? new File(".") : file;
        File outputDir = file2;
        this.createDirectory(outputDir);
        this.withZipOutput(outputFile, manifest, (Function1<ZipOutputStream, BoxedUnit>)(Function1 & Serializable)output -> {
            IO$.$anonfun$archive$1(manifest, sources, output);
            return BoxedUnit.UNIT;
        });
    }

    private void writeZip(Seq<Tuple2<File, String>> sources, ZipOutputStream output, Function1<String, ZipEntry> createEntry) {
        Seq files = (Seq)sources.flatMap((Function1 & Serializable)x0$1 -> {
            Nil$ nil$;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                File file = (File)tuple2._1();
                String name = (String)tuple2._2();
                if (file.isFile()) {
                    Tuple2 tuple22 = new Tuple2((Object)file, (Object)MODULE$.normalizeName(name));
                    nil$ = Nil$.MODULE$.$colon$colon((Object)tuple22);
                } else {
                    nil$ = Nil$.MODULE$;
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            Nil$ nil$2 = nil$;
            return nil$2;
        });
        long now = System.currentTimeMillis();
        long emptyCRC = new CRC32().getValue();
        this.allDirectoryPaths((Iterable<Tuple2<File, String>>)files).foreach((Function1 & Serializable)name -> {
            IO$.addDirectoryEntry$1(name, output, createEntry, now, emptyCRC);
            return BoxedUnit.UNIT;
        });
        files.foreach((Function1 & Serializable)x0$2 -> {
            IO$.$anonfun$writeZip$3(this, output, createEntry, x0$2);
            return BoxedUnit.UNIT;
        });
    }

    private List<String> relativeComponents(String path) {
        return (List)Predef$.MODULE$.wrapRefArray((Object[])path.split("/")).toList().dropRight(1);
    }

    private List<String> directories(List<String> path) {
        return (List)path.foldLeft((Object)new .colon.colon((Object)"", (List)Nil$.MODULE$), (Function2 & Serializable)(e, l) -> {
            String string = new StringBuilder(1).append((String)e.head()).append((String)l).append("/").toString();
            return e.$colon$colon((Object)string);
        });
    }

    private List<String> directoryPaths(String path) {
        return this.directories(this.relativeComponents(path)).filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)IO$.$anonfun$directoryPaths$1(x$6)));
    }

    private TreeSet<String> allDirectoryPaths(Iterable<Tuple2<File, String>> files) {
        return (TreeSet)((SetOps)TreeSet$.MODULE$.apply((Seq)Nil$.MODULE$, (Object)Ordering.String$.MODULE$)).$plus$plus((IterableOnce)files.flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String name = (String)tuple2._2();
            List<String> list = MODULE$.directoryPaths(name);
            return list;
        }));
    }

    private String normalizeName(String name) {
        char sep = File.separatorChar;
        return sep == '/' ? name : name.replace(sep, '/');
    }

    private void withZipOutput(File file, Option<java.util.jar.Manifest> manifest, Function1<ZipOutputStream, BoxedUnit> f) {
        ((Using)((Object)Using$.MODULE$.fileOutputStream(false))).apply(file, (Function1 & Serializable)fileOut -> {
            IO$.$anonfun$withZipOutput$1(manifest, f, fileOut);
            return BoxedUnit.UNIT;
        });
    }

    public Option<File> relativizeFile(File base, File file) {
        return this.relativize(base, file).map((Function1 & Serializable)path -> new File((String)path));
    }

    public Option<String> relativize(File base, File file) {
        None$ none$;
        Path basePath = IO$.toAbsolutePath$1(base).normalize();
        Path filePath = IO$.toAbsolutePath$1(file).normalize();
        if (filePath.startsWith(basePath)) {
            Option relativePath = Exception$.MODULE$.catching((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{IllegalArgumentException.class})).opt((Function0 & Serializable)() -> basePath.relativize(filePath));
            none$ = relativePath.map((Function1 & Serializable)x$7 -> ((Object)x$7).toString());
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public scala.collection.immutable.Set<File> copy(Iterable<Tuple2<File, File>> sources) {
        return this.copy(sources, CopyOptions$.MODULE$.apply());
    }

    public scala.collection.immutable.Set<File> copy(Iterable<Tuple2<File, File>> sources, CopyOptions options) {
        return this.copy(sources, options.overwrite(), options.preserveLastModified(), options.preserveExecutable());
    }

    public scala.collection.immutable.Set<File> copy(Iterable<Tuple2<File, File>> sources, boolean overwrite, boolean preserveLastModified, boolean preserveExecutable) {
        return ((IterableOnceOps)sources.map(Function$.MODULE$.tupled((Function2 & Serializable)(from, to) -> MODULE$.copyImpl(overwrite, preserveLastModified, preserveExecutable, (File)from, (File)to)))).toSet();
    }

    private File copyImpl(boolean overwrite, boolean preserveLastModified, boolean preserveExecutable, File from, File to) {
        block2: {
            if (!overwrite && to.exists() && this.getModifiedTimeOrZero(from) <= this.getModifiedTimeOrZero(to)) break block2;
            if (from.isDirectory()) {
                this.createDirectory(to);
            } else {
                this.createDirectory(to.getParentFile());
                this.copyFile(from, to, preserveLastModified, preserveExecutable);
            }
        }
        return to;
    }

    public void copyDirectory(File source, File target) {
        this.copyDirectory(source, target, CopyOptions$.MODULE$.apply());
    }

    public void copyDirectory(File source, File target, CopyOptions options) {
        this.copyDirectory(source, target, options.overwrite(), options.preserveLastModified(), options.preserveExecutable());
    }

    public void copyDirectory(File source, File target, boolean overwrite, boolean preserveLastModified, boolean preserveExecutable) {
        PathFinder qual$1 = PathFinder$.MODULE$.apply(source).allPaths();
        Function1<File, Option<File>> x$1 = Path$.MODULE$.rebase(source, target);
        boolean x$2 = qual$1.pair$default$2();
        Seq<Tuple2<File, File>> sources = qual$1.pair(x$1, x$2);
        this.copy((Iterable<Tuple2<File, File>>)sources, overwrite, preserveLastModified, preserveExecutable);
    }

    public boolean copyDirectory$default$3() {
        return false;
    }

    public boolean copyDirectory$default$4() {
        return false;
    }

    public boolean copyDirectory$default$5() {
        return true;
    }

    public void copyFile(File sourceFile, File targetFile) {
        this.copyFile(sourceFile, targetFile, CopyOptions$.MODULE$.apply());
    }

    public void copyFile(File sourceFile, File targetFile, CopyOptions options) {
        this.copyFile(sourceFile, targetFile, options.preserveLastModified(), options.preserveExecutable());
    }

    public void copyFile(File sourceFile, File targetFile, boolean preserveLastModified, boolean preserveExecutable) {
        block1: {
            Predef$.MODULE$.require(sourceFile.exists(), (Function0 & Serializable)() -> new StringBuilder(30).append("Source file '").append(sourceFile.getAbsolutePath()).append("' does not exist.").toString());
            Predef$.MODULE$.require(!sourceFile.isDirectory(), (Function0 & Serializable)() -> new StringBuilder(30).append("Source file '").append(sourceFile.getAbsolutePath()).append("' is a directory.").toString());
            ((Using)((Object)Using$.MODULE$.fileInputChannel())).apply(sourceFile, (Function1 & Serializable)in -> {
                IO$.$anonfun$copyFile$3(this, targetFile, sourceFile, in);
                return BoxedUnit.UNIT;
            });
            if (preserveLastModified) {
                this.copyLastModified(sourceFile, targetFile);
            }
            if (!preserveExecutable) break block1;
            this.copyExecutable(sourceFile, targetFile);
        }
    }

    public boolean copyFile$default$3() {
        return false;
    }

    public boolean copyFile$default$4() {
        return true;
    }

    public Object copyExecutable(File sourceFile, File targetFile) {
        boolean executable = sourceFile.canExecute();
        return executable ? BoxesRunTime.boxToBoolean((boolean)targetFile.setExecutable(true)) : BoxedUnit.UNIT;
    }

    public Charset defaultCharset() {
        return this.utf8();
    }

    public void write(File file, String content, Charset charset, boolean append) {
        this.writer(file, content, charset, append, (Function1 & Serializable)x$8 -> {
            x$8.write(content);
            return BoxedUnit.UNIT;
        });
    }

    public <T> T writer(File file, String content, Charset charset, boolean append, Function1<BufferedWriter, T> f) {
        if (!charset.newEncoder().canEncode(content)) {
            throw scala.sys.package$.MODULE$.error(new StringBuilder(36).append("String cannot be encoded by charset ").append(charset.name()).toString());
        }
        return ((Using)((Object)Using$.MODULE$.fileWriter(charset, append))).apply(file, f);
    }

    public <T> T reader(File file, Charset charset, Function1<BufferedReader, T> f) {
        return ((Using)((Object)Using$.MODULE$.fileReader(charset))).apply(file, f);
    }

    public String read(File file, Charset charset) {
        ByteArrayOutputStream out = new ByteArrayOutputStream((int)file.length());
        this.transfer(file, (OutputStream)out);
        return out.toString(charset.name());
    }

    public <T> Charset reader$default$2() {
        return this.defaultCharset();
    }

    public Charset read$default$2() {
        return this.defaultCharset();
    }

    public String readStream(InputStream in, Charset charset) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.transfer(in, (OutputStream)out);
        return out.toString(charset.name());
    }

    public Charset readStream$default$2() {
        return this.defaultCharset();
    }

    public byte[] readBytes(File file) {
        return (byte[])((Using)((Object)Using$.MODULE$.fileInputStream())).apply(file, (Function1 & Serializable)in -> MODULE$.readBytes((InputStream)in));
    }

    public byte[] readBytes(InputStream in) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.transfer(in, (OutputStream)out);
        return out.toByteArray();
    }

    public void append(File file, String content, Charset charset) {
        this.write(file, content, charset, true);
    }

    public void append(File file, byte[] bytes) {
        this.writeBytes(file, bytes, true);
    }

    public Charset append$default$3() {
        return this.defaultCharset();
    }

    public void write(File file, byte[] bytes) {
        this.writeBytes(file, bytes, false);
    }

    private void writeBytes(File file, byte[] bytes, boolean append) {
        ((Using)((Object)Using$.MODULE$.fileOutputStream(append))).apply(file, (Function1 & Serializable)x$9 -> {
            x$9.write(bytes);
            return BoxedUnit.UNIT;
        });
    }

    public List<String> readLinesURL(URL url, Charset charset) {
        return (List)Using$.MODULE$.urlReader(charset).apply(url, (Function1 & Serializable)in -> MODULE$.readLines((BufferedReader)in));
    }

    public List<String> readLines(File file, Charset charset) {
        return (List)((Using)((Object)Using$.MODULE$.fileReader(charset))).apply(file, (Function1 & Serializable)in -> MODULE$.readLines((BufferedReader)in));
    }

    public List<String> readLines(BufferedReader in) {
        return ((List)this.foldLines(in, Nil$.MODULE$, (Function2 & Serializable)(accum, line) -> {
            String string = line;
            return accum.$colon$colon((Object)string);
        })).reverse();
    }

    public Charset readLinesURL$default$2() {
        return this.defaultCharset();
    }

    public Charset readLines$default$2() {
        return this.defaultCharset();
    }

    public void foreachLine(BufferedReader in, Function1<String, BoxedUnit> f) {
        this.foldLines(in, BoxedUnit.UNIT, (Function2 & Serializable)(x$10, line) -> {
            f.apply((Object)line);
            return BoxedUnit.UNIT;
        });
    }

    public <T> T foldLines(BufferedReader in, T init, Function2<T, String, T> f) {
        return (T)this.readLine$1(init, in, f);
    }

    public void writeLines(File file, Seq<String> lines, Charset charset, boolean append) {
        this.writer(file, (String)lines.headOption().getOrElse((Function0 & Serializable)() -> ""), charset, append, (Function1 & Serializable)w -> {
            lines.foreach((Function1 & Serializable)line -> {
                IO$.$anonfun$writeLines$3(w, line);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
    }

    public void writeLines(PrintWriter writer, Seq<String> lines) {
        lines.foreach((Function1 & Serializable)x$1 -> {
            writer.println(x$1);
            return BoxedUnit.UNIT;
        });
    }

    public void write(Properties properties, String label, File to) {
        ((Using)((Object)Using$.MODULE$.fileOutputStream(Using$.MODULE$.fileOutputStream$default$1()))).apply(to, (Function1 & Serializable)output -> {
            properties.store(output, label);
            return BoxedUnit.UNIT;
        });
    }

    public Charset write$default$3() {
        return this.defaultCharset();
    }

    public boolean write$default$4() {
        return false;
    }

    public <T> boolean writer$default$4() {
        return false;
    }

    public Charset writeLines$default$3() {
        return this.defaultCharset();
    }

    public boolean writeLines$default$4() {
        return false;
    }

    public void load(Properties properties, File from) {
        block0: {
            if (!from.exists()) break block0;
            ((Using)((Object)Using$.MODULE$.fileInputStream())).apply(from, (Function1 & Serializable)input -> {
                properties.load(input);
                return BoxedUnit.UNIT;
            });
        }
    }

    private Pattern PathSeparatorPattern() {
        return PathSeparatorPattern;
    }

    public String[] pathSplit(String s) {
        return this.PathSeparatorPattern().split(s);
    }

    public <T> T stash(scala.collection.immutable.Set<File> files, Function0<T> f) {
        return this.withTemporaryDirectory((Function1 & Serializable)dir -> {
            Object object;
            Tuple2<File, File>[] stashed = MODULE$.stashLocations((File)dir, (File[])files.toArray(ClassTag$.MODULE$.apply(File.class)));
            MODULE$.move((Iterable<Tuple2<File, File>>)Predef$.MODULE$.wrapRefArray((Object[])stashed));
            try {
                object = f.apply();
            }
            catch (Exception e) {
                try {
                    MODULE$.move((Iterable<Tuple2<File, File>>)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])stashed), (Function1 & Serializable)x$11 -> x$11.swap(), ClassTag$.MODULE$.apply(Tuple2.class))));
                    throw e;
                }
                catch (Exception exception) {
                    throw e;
                }
            }
            return object;
        });
    }

    private Tuple2<File, File>[] stashLocations(File dir, File[] files) {
        return (Tuple2[])ArrayOps$.MODULE$.withFilter$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])files))), (Function1 & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)IO$.$anonfun$stashLocations$1(check$ifrefutable$2))).map((Function1 & Serializable)x$12 -> {
            Tuple2 tuple2 = x$12;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            File file = (File)tuple2._1();
            int index = tuple2._2$mcI$sp();
            Tuple2 tuple22 = new Tuple2((Object)file, (Object)new File(dir, RichInt$.MODULE$.toHexString$extension(Predef$.MODULE$.intWrapper(index))));
            return tuple22;
        }, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public void move(Iterable<Tuple2<File, File>> files) {
        files.foreach(Function$.MODULE$.tupled((Function2 & Serializable)(a, b) -> {
            IO$.MODULE$.move(a, b);
            return BoxedUnit.UNIT;
        }));
    }

    public void move(File a, File b) {
        block1: {
            if (b.exists()) {
                this.delete(b);
            }
            this.createDirectory(b.getParentFile());
            if (a.renameTo(b)) break block1;
            this.copyFile(a, b, true, this.copyFile$default$4());
            this.delete(a);
        }
    }

    public <T> T gzipFileOut(File file, Function1<OutputStream, T> f) {
        return (T)((Using)((Object)Using$.MODULE$.fileOutputStream(Using$.MODULE$.fileOutputStream$default$1()))).apply(file, (Function1 & Serializable)fout -> Using$.MODULE$.gzipOutputStream().apply((OutputStream)fout, (Function1 & Serializable)outg -> Using$.MODULE$.bufferedOutputStream().apply((OutputStream)outg, f)));
    }

    public <T> T gzipFileIn(File file, Function1<InputStream, T> f) {
        return (T)((Using)((Object)Using$.MODULE$.fileInputStream())).apply(file, (Function1 & Serializable)fin -> Using$.MODULE$.gzipInputStream().apply((InputStream)fin, (Function1 & Serializable)ing -> Using$.MODULE$.bufferedInputStream().apply((InputStream)ing, f)));
    }

    public URI directoryURI(File dir) {
        this.assertAbsolute(dir);
        return this.directoryURI(dir.toURI().normalize());
    }

    /*
     * Unable to fully structure code
     */
    public URI directoryURI(URI uri) {
        if (!uri.isAbsolute()) {
            return uri;
        }
        str = uri.toASCIIString();
        if (str.endsWith("/")) ** GOTO lbl-1000
        v0 = uri.getScheme();
        var4_3 = this.FileScheme();
        if ((v0 != null ? v0.equals(var4_3) == false : var4_3 != null) || uri.getRawFragment() != null) lbl-1000:
        // 2 sources

        {
            v1 = uri;
        } else {
            v1 = new URI(new StringBuilder(1).append(str).append("/").toString());
        }
        dirURI = v1;
        return dirURI.normalize();
    }

    public URI toURI(File f) {
        return f.isAbsolute() ? f.toPath().toUri() : new URI(null, this.normalizeName(f.getPath()), null);
    }

    /*
     * WARNING - void declaration
     */
    public File resolve(File base, File f) {
        void var3_3;
        this.assertAbsolute(base);
        File fabs = f.isAbsolute() ? f : new File(this.directoryURI(new File(base, f.getPath())));
        this.assertAbsolute(fabs);
        return var3_3;
    }

    public void assertAbsolute(File f) {
        Predef$.MODULE$.assert(f.isAbsolute(), (Function0 & Serializable)() -> new StringBuilder(14).append("Not absolute: ").append(f).toString());
    }

    public void assertAbsolute(URI uri) {
        Predef$.MODULE$.assert(uri.isAbsolute(), (Function0 & Serializable)() -> new StringBuilder(14).append("Not absolute: ").append(uri).toString());
    }

    public Seq<File> parseClasspath(String s) {
        return s.isEmpty() ? Nil$.MODULE$ : ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.pathSplit(s)), (Function1 & Serializable)x$13 -> new File((String)x$13), ClassTag$.MODULE$.apply(File.class))));
    }

    public ObjectInputStream objectInputStream(InputStream wrapped, ClassLoader loader) {
        return new ObjectInputStream(wrapped, loader){
            private final ClassLoader loader$1;

            /*
             * WARNING - void declaration
             */
            public Class<?> resolveClass(ObjectStreamClass osc) {
                void var2_2;
                Class<?> c = Class.forName(osc.getName(), false, this.loader$1);
                return c == null ? super.resolveClass(osc) : var2_2;
            }
            {
                this.loader$1 = loader$1;
                super(wrapped$1);
            }
        };
    }

    public boolean isPosix() {
        return this.hasPosixFileAttributeView();
    }

    private boolean hasPosixFileAttributeView$lzycompute() {
        IO$ iO$ = this;
        synchronized (iO$) {
            if ((bitmap$0 & 4) == 0) {
                hasPosixFileAttributeView = this.supportedFileAttributeViews().contains((Object)"posix");
                bitmap$0 |= 4;
            }
        }
        return hasPosixFileAttributeView;
    }

    public boolean hasPosixFileAttributeView() {
        return (bitmap$0 & 4) == 0 ? this.hasPosixFileAttributeView$lzycompute() : hasPosixFileAttributeView;
    }

    private boolean hasFileOwnerAttributeView$lzycompute() {
        IO$ iO$ = this;
        synchronized (iO$) {
            if ((bitmap$0 & 8) == 0) {
                hasFileOwnerAttributeView = this.supportedFileAttributeViews().contains((Object)"owner");
                bitmap$0 |= 8;
            }
        }
        return hasFileOwnerAttributeView;
    }

    public boolean hasFileOwnerAttributeView() {
        return (bitmap$0 & 8) == 0 ? this.hasFileOwnerAttributeView$lzycompute() : hasFileOwnerAttributeView;
    }

    private boolean hasDosFileAttributeView$lzycompute() {
        IO$ iO$ = this;
        synchronized (iO$) {
            if ((bitmap$0 & 0x10) == 0) {
                hasDosFileAttributeView = this.supportedFileAttributeViews().contains((Object)"dos");
                bitmap$0 |= 0x10;
            }
        }
        return hasDosFileAttributeView;
    }

    public boolean hasDosFileAttributeView() {
        return (bitmap$0 & 0x10) == 0 ? this.hasDosFileAttributeView$lzycompute() : hasDosFileAttributeView;
    }

    private boolean hasAclFileAttributeView$lzycompute() {
        IO$ iO$ = this;
        synchronized (iO$) {
            if ((bitmap$0 & 0x20) == 0) {
                hasAclFileAttributeView = this.supportedFileAttributeViews().contains((Object)"acl");
                bitmap$0 |= 0x20;
            }
        }
        return hasAclFileAttributeView;
    }

    public boolean hasAclFileAttributeView() {
        return (bitmap$0 & 0x20) == 0 ? this.hasAclFileAttributeView$lzycompute() : hasAclFileAttributeView;
    }

    private boolean hasBasicFileAttributeView$lzycompute() {
        IO$ iO$ = this;
        synchronized (iO$) {
            if ((bitmap$0 & 0x40) == 0) {
                hasBasicFileAttributeView = this.supportedFileAttributeViews().contains((Object)"basic");
                bitmap$0 |= 0x40;
            }
        }
        return hasBasicFileAttributeView;
    }

    public boolean hasBasicFileAttributeView() {
        return (bitmap$0 & 0x40) == 0 ? this.hasBasicFileAttributeView$lzycompute() : hasBasicFileAttributeView;
    }

    private boolean hasUserDefinedFileAttributeView$lzycompute() {
        IO$ iO$ = this;
        synchronized (iO$) {
            if ((bitmap$0 & 0x80) == 0) {
                hasUserDefinedFileAttributeView = this.supportedFileAttributeViews().contains((Object)"user");
                bitmap$0 |= 0x80;
            }
        }
        return hasUserDefinedFileAttributeView;
    }

    public boolean hasUserDefinedFileAttributeView() {
        return (bitmap$0 & 0x80) == 0 ? this.hasUserDefinedFileAttributeView$lzycompute() : hasUserDefinedFileAttributeView;
    }

    private scala.collection.immutable.Set<String> supportedFileAttributeViews$lzycompute() {
        IO$ iO$ = this;
        synchronized (iO$) {
            if ((bitmap$0 & 0x100) == 0) {
                supportedFileAttributeViews = ((IterableOnceOps)JavaConverters$.MODULE$.asScalaSetConverter(FileSystems.getDefault().supportedFileAttributeViews()).asScala()).toSet();
                bitmap$0 |= 0x100;
            }
        }
        return supportedFileAttributeViews;
    }

    private scala.collection.immutable.Set<String> supportedFileAttributeViews() {
        return (bitmap$0 & 0x100) == 0 ? this.supportedFileAttributeViews$lzycompute() : supportedFileAttributeViews;
    }

    public void setPermissions(File file, String permissions) {
        new RichFile(Path$.MODULE$.apply(file)).setPermissions((scala.collection.immutable.Set<PosixFilePermission>)((IterableOnceOps)JavaConverters$.MODULE$.asScalaSetConverter(PosixFilePermissions.fromString(permissions)).asScala()).toSet());
    }

    public void chmod(String permissions, File file) {
        this.setPermissions(file, permissions);
    }

    public void setOwner(File file, String owner) {
        new RichFile(Path$.MODULE$.apply(file)).setOwner(owner);
    }

    public void chown(String owner, File file) {
        this.setOwner(file, owner);
    }

    public void setGroup(File file, String group) {
        new RichFile(Path$.MODULE$.apply(file)).setGroup(group);
    }

    public void chgrp(String group, File file) {
        this.setGroup(file, group);
    }

    public long getModifiedTime(File file) {
        return Milli$.MODULE$.getModifiedTime(file);
    }

    public void setModifiedTime(File file, long mtime) {
        Milli$.MODULE$.setModifiedTime(file, mtime);
    }

    public void copyModifiedTime(File fromFile, File toFile) {
        Milli$.MODULE$.copyModifiedTime(fromFile, toFile);
    }

    public long getModifiedTimeOrZero(File file) {
        long l;
        try {
            l = BoxesRunTime.unboxToLong(Retry$.MODULE$.apply((JFunction0.mcJ.sp & Serializable)() -> Milli$.MODULE$.getModifiedTime(file), (Seq<Class<? extends IOException>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{FileNotFoundException.class})));
        }
        catch (FileNotFoundException fileNotFoundException) {
            l = 0L;
        }
        return l;
    }

    public boolean setModifiedTimeOrFalse(File file, long mtime) {
        boolean bl;
        try {
            Retry$.MODULE$.apply((JFunction0.mcV.sp & Serializable)() -> Milli$.MODULE$.setModifiedTime(file, mtime), (Seq<Class<? extends IOException>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{FileNotFoundException.class}));
            bl = true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            bl = false;
        }
        return bl;
    }

    public boolean copyLastModified(File sourceFile, File targetFile) {
        long last = this.getModifiedTimeOrZero(sourceFile);
        return this.setModifiedTimeOrFalse(targetFile, package$.MODULE$.max(last, 0L));
    }

    private static final Option localcl$1(Class cl$3) {
        return Option$.MODULE$.apply((Object)cl$3.getProtectionDomain().getCodeSource()).flatMap((Function1 & Serializable)codeSource -> Option$.MODULE$.apply((Object)codeSource.getLocation()));
    }

    private static final Option syscl$1(String clsfile$1) {
        return Option$.MODULE$.apply((Object)ClassLoader.getSystemClassLoader()).flatMap((Function1 & Serializable)classLoader -> Option$.MODULE$.apply((Object)classLoader.getResource(clsfile$1)));
    }

    private static final Option localcl$2(Class cl$4, String clsfile$2) {
        return Option$.MODULE$.apply((Object)cl$4.getClassLoader()).flatMap((Function1 & Serializable)classLoader -> Option$.MODULE$.apply((Object)classLoader.getResource(clsfile$2)));
    }

    private static final Option syscl$2(String clsfile$2) {
        return Option$.MODULE$.apply((Object)ClassLoader.getSystemClassLoader()).flatMap((Function1 & Serializable)classLoader -> Option$.MODULE$.apply((Object)classLoader.getResource(clsfile$2)));
    }

    public static final /* synthetic */ String $anonfun$uriToFile$1(URI uri$1) {
        return new StringBuilder(43).append("Expected protocol to be '").append(MODULE$.FileScheme()).append("' or empty in URI ").append(uri$1).toString();
    }

    private static final String failBase$1(File dir$1) {
        return new StringBuilder(27).append("Could not create directory ").append(dir$1).toString();
    }

    public static final /* synthetic */ void $anonfun$gzip$2(File out$1, BufferedInputStream inputStream) {
        ((Using)((Object)Using$.MODULE$.fileOutputStream(Using$.MODULE$.fileOutputStream$default$1()))).apply(out$1, (Function1 & Serializable)outputStream -> {
            IO$.MODULE$.gzip(inputStream, outputStream);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$gunzip$2(File out$2, BufferedInputStream inputStream) {
        ((Using)((Object)Using$.MODULE$.fileOutputStream(Using$.MODULE$.fileOutputStream$default$1()))).apply(out$2, (Function1 & Serializable)outputStream -> {
            IO$.MODULE$.gunzip(inputStream, outputStream);
            return BoxedUnit.UNIT;
        });
    }

    private final void next$1(ZipInputStream from$1, NameFilter filter$4, File toDirectory$4, HashSet set$1, boolean preserveLastModified$4) {
        ZipEntry entry;
        while ((entry = from$1.getNextEntry()) != null) {
            Object object;
            String name = entry.getName();
            if (filter$4.accept(name)) {
                Object object2;
                File target = new File(toDirectory$4, name);
                if (entry.isDirectory()) {
                    this.createDirectory(target);
                    object2 = BoxedUnit.UNIT;
                } else {
                    set$1.$plus$eq((Object)target);
                    object2 = ErrorHandling$.MODULE$.translate((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(37).append("Error extracting zip entry '").append(name).append("' to '").append(target).append("': ").toString(), (JFunction0.mcV.sp & Serializable)() -> ((Using)((Object)Using$.MODULE$.fileOutputStream(false))).apply(target, (Function1 & Serializable)out -> {
                        IO$.MODULE$.transfer((InputStream)from$1, (OutputStream)out);
                        return BoxedUnit.UNIT;
                    }));
                }
                object = preserveLastModified$4 ? BoxesRunTime.boxToBoolean((boolean)this.setModifiedTimeOrFalse(target, entry.getTime())) : BoxedUnit.UNIT;
            } else {
                object = BoxedUnit.UNIT;
            }
            from$1.closeEntry();
        }
    }

    private final void read$1(InputStream in$2, byte[] buffer$1, OutputStream out$5) {
        int byteCount;
        while ((byteCount = in$2.read(buffer$1)) >= 0) {
            out$5.write(buffer$1, 0, byteCount);
        }
    }

    private final File create$1(int tries, File baseDirectory$1) {
        File file;
        if (tries > this.MaximumTries()) {
            throw scala.sys.package$.MODULE$.error("Could not create temporary directory.");
        }
        String randomName = new StringBuilder(4).append("sbt_").append(Integer.toHexString(this.random().nextInt())).toString();
        File f = new File(baseDirectory$1, randomName);
        try {
            this.createDirectory(f);
            file = f;
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 == null || (option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                throw throwable;
            }
            File file2 = this.create$1(tries + 1, baseDirectory$1);
            file = file2;
        }
        return file;
    }

    private static final boolean visit$1(File f, HashMap isEmpty$1, Set dirs$1) {
        return BoxesRunTime.unboxToBoolean((Object)isEmpty$1.getOrElseUpdate((Object)f, (Function0)(JFunction0.mcZ.sp & Serializable)() -> dirs$1.apply((Object)f) && f.isDirectory() && ArrayOps$.MODULE$.forall$extension(Predef$.MODULE$.refArrayOps((Object[])f.listFiles()), (Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)IO$.visit$1(f, isEmpty$1, dirs$1)))));
    }

    public static final /* synthetic */ boolean $anonfun$deleteIfEmpty$4(Tuple2 check$ifrefutable$1) {
        boolean bl;
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl2 = tuple2 != null && (bl = tuple2._2$mcZ$sp());
        return bl2;
    }

    public static final /* synthetic */ boolean $anonfun$deleteIfEmpty$5(Tuple2 x$2) {
        File f;
        block3: {
            Tuple2 tuple2;
            block2: {
                tuple2 = x$2;
                if (tuple2 == null) break block2;
                f = (File)tuple2._1();
                boolean bl = tuple2._2$mcZ$sp();
                if (bl) break block3;
            }
            throw new MatchError((Object)tuple2);
        }
        boolean bl = f.delete();
        return bl;
    }

    private final boolean isEmptyDirectory$1(File dir) {
        return dir.isDirectory() && ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])this.listFiles(dir)));
    }

    private static final scala.collection.immutable.Set parents$1(scala.collection.immutable.Set fs) {
        return (scala.collection.immutable.Set)fs.flatMap((Function1 & Serializable)f -> Option$.MODULE$.apply((Object)f.getParentFile()));
    }

    private final void deleteEmpty$1(scala.collection.immutable.Set dirs) {
        scala.collection.immutable.Set empty2;
        while ((empty2 = (scala.collection.immutable.Set)dirs.filter((Function1 & Serializable)dir -> BoxesRunTime.boxToBoolean((boolean)this.isEmptyDirectory$1(dir)))).nonEmpty()) {
            empty2.foreach((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.delete()));
            dirs = IO$.parents$1(empty2);
        }
    }

    public static final /* synthetic */ void $anonfun$archive$1(Option manifest$1, Seq sources$1, ZipOutputStream output) {
        Function1 & Serializable createEntry = manifest$1.isDefined() ? (Function1 & Serializable)x$4 -> new JarEntry((String)x$4) : (Function1 & Serializable)x$5 -> new ZipEntry((String)x$5);
        MODULE$.writeZip((Seq<Tuple2<File, String>>)sources$1, output, (Function1<String, ZipEntry>)createEntry);
    }

    private static final void addDirectoryEntry$1(String name, ZipOutputStream output$2, Function1 createEntry$1, long now$1, long emptyCRC$1) {
        output$2.putNextEntry(IO$.makeDirectoryEntry$1(name, createEntry$1, now$1, emptyCRC$1));
        output$2.closeEntry();
    }

    private static final ZipEntry makeDirectoryEntry$1(String name, Function1 createEntry$1, long now$1, long emptyCRC$1) {
        ZipEntry e = (ZipEntry)createEntry$1.apply((Object)name);
        e.setTime(now$1);
        e.setSize(0L);
        e.setMethod(0);
        e.setCrc(emptyCRC$1);
        return e;
    }

    private final ZipEntry makeFileEntry$1(File file, String name, Function1 createEntry$1) {
        ZipEntry e = (ZipEntry)createEntry$1.apply((Object)name);
        e.setTime(this.getModifiedTimeOrZero(file));
        return e;
    }

    private final void addFileEntry$1(File file, String name, ZipOutputStream output$2, Function1 createEntry$1) {
        output$2.putNextEntry(this.makeFileEntry$1(file, name, createEntry$1));
        this.transfer(file, (OutputStream)output$2);
        output$2.closeEntry();
    }

    public static final /* synthetic */ void $anonfun$writeZip$3(IO$ $this, ZipOutputStream output$2, Function1 createEntry$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File file = (File)tuple2._1();
        String name = (String)tuple2._2();
        $this.addFileEntry$1(file, name, output$2, createEntry$1);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$directoryPaths$1(String x$6) {
        return x$6.length() > 1;
    }

    public static final /* synthetic */ void $anonfun$withZipOutput$1(Option manifest$2, Function1 f$2, BufferedOutputStream fileOut) {
        ZipOutputStream zipOut;
        Tuple2 tuple2;
        Option option = manifest$2;
        if (option instanceof Some) {
            Some some = (Some)option;
            java.util.jar.Manifest mf = (java.util.jar.Manifest)some.value();
            Attributes main = mf.getMainAttributes();
            Object object = !main.containsKey(Attributes.Name.MANIFEST_VERSION) ? main.put(Attributes.Name.MANIFEST_VERSION, "1.0") : BoxedUnit.UNIT;
            tuple2 = new Tuple2((Object)new JarOutputStream((OutputStream)fileOut, mf), (Object)"jar");
        } else if (None$.MODULE$.equals(option)) {
            tuple2 = new Tuple2((Object)new ZipOutputStream(fileOut), (Object)"zip");
        } else {
            throw new MatchError((Object)option);
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        ZipOutputStream zipOutputStream = zipOut = (ZipOutputStream)tuple22._1();
        try (ZipOutputStream zipOut2 = zipOutputStream;){
            f$2.apply((Object)zipOut2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final Path toAbsolutePath$1(File x) {
        void var1_1;
        Path p = x.toPath();
        return !p.isAbsolute() ? p.toAbsolutePath() : var1_1;
    }

    private final long loop$1(long offset, long total$1, FileChannel out$6, FileChannel in$3, long max$1) {
        while (offset < total$1) {
            offset += out$6.transferFrom(in$3, offset, max$1);
        }
        return offset;
    }

    public static final /* synthetic */ void $anonfun$copyFile$4(IO$ $this, FileChannel in$3, File sourceFile$1, File targetFile$1, FileChannel out) {
        long max = 67076096L;
        long total = in$3.size();
        long copied = $this.loop$1(0L, total, out, in$3, max);
        if (copied != in$3.size()) {
            throw scala.sys.package$.MODULE$.error(new StringBuilder(40).append("Could not copy '").append(sourceFile$1).append("' to '").append(targetFile$1).append("' (").append(copied).append("/").append(in$3.size()).append(" bytes copied)").toString());
        }
    }

    public static final /* synthetic */ void $anonfun$copyFile$3(IO$ $this, File targetFile$1, File sourceFile$1, FileChannel in) {
        ((Using)((Object)Using$.MODULE$.fileOutputChannel())).apply(targetFile$1, (Function1 & Serializable)out -> {
            IO$.$anonfun$copyFile$4($this, in, sourceFile$1, targetFile$1, out);
            return BoxedUnit.UNIT;
        });
    }

    private final Object readLine$1(Object accum, BufferedReader in$4, Function2 f$4) {
        String line;
        while ((line = in$4.readLine()) != null) {
            accum = f$4.apply(accum, (Object)line);
        }
        return accum;
    }

    public static final /* synthetic */ void $anonfun$writeLines$3(BufferedWriter w$1, String line) {
        w$1.write(line);
        w$1.newLine();
    }

    public static final /* synthetic */ boolean $anonfun$stashLocations$1(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        boolean bl = tuple2 != null;
        return bl;
    }

    private IO$() {
    }
}

