/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals;

import java.io.Serializable;
import java.nio.file.FileSystem;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.zip.ZipError;
import java.util.zip.ZipException;
import org.h2.jdbc.JdbcBatchUpdateException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Builder;
import scala.math.Numeric;
import scala.meta.internal.metals.JarTopLevels$;
import scala.meta.internal.metals.JarTypeHierarchy;
import scala.meta.internal.metals.JdbcEnrichments$;
import scala.meta.internal.mtags.OverriddenSymbol;
import scala.meta.io.AbsolutePath;
import scala.meta.io.AbsolutePath$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scribe.LogFeature;
import scribe.LogFeature$;
import scribe.mdc.MDC$;
import sourcecode.FileName;
import sourcecode.Line;
import sourcecode.Name;
import sourcecode.Pkg;

@ScalaSignature(bytes="\u0006\u0005\u0005ea\u0001B\u0007\u000f\u0005]A\u0001\u0002\b\u0001\u0003\u0002\u0003\u0006I!\b\u0005\u0006S\u0001!\tA\u000b\u0005\u0006[\u0001!\tA\f\u0005\u0006#\u0002!\tA\u0015\u0005\u0006M\u0002!\te\u001a\u0005\u0006U\u0002!\ta\u001b\u0005\u0006]\u0002!\ta\u001c\u0005\u0006k\u0002!\tA^\u0004\u0006u:A\ta\u001f\u0004\u0006\u001b9A\t\u0001 \u0005\u0007S)!\t!!\u0001\t\u000f\u0005\r!\u0002\"\u0001\u0002\u0006\ta!*\u0019:U_BdUM^3mg*\u0011q\u0002E\u0001\u0007[\u0016$\u0018\r\\:\u000b\u0005E\u0011\u0012\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005M!\u0012\u0001B7fi\u0006T\u0011!F\u0001\u0006g\u000e\fG.Y\u0002\u0001'\t\u0001\u0001\u0004\u0005\u0002\u001a55\ta\"\u0003\u0002\u001c\u001d\t\u0001\"*\u0019:UsB,\u0007*[3sCJ\u001c\u0007._\u0001\u0005G>tg\u000eE\u0002\u001f?\u0005j\u0011\u0001F\u0005\u0003AQ\u0011\u0011BR;oGRLwN\u001c\u0019\u0011\u0005\t:S\"A\u0012\u000b\u0005\u0011*\u0013aA:rY*\ta%\u0001\u0003kCZ\f\u0017B\u0001\u0015$\u0005)\u0019uN\u001c8fGRLwN\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005-b\u0003CA\r\u0001\u0011\u0015a\"\u00011\u0001\u001e\u000319W\r\u001e+pa2+g/\u001a7t)\tys\nE\u0002\u001faIJ!!\r\u000b\u0003\r=\u0003H/[8o!\r\u00194H\u0010\b\u0003ier!!\u000e\u001d\u000e\u0003YR!a\u000e\f\u0002\rq\u0012xn\u001c;?\u0013\u0005)\u0012B\u0001\u001e\u0015\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001P\u001f\u0003\t1K7\u000f\u001e\u0006\u0003uQ\u0001BAH B\u0013&\u0011\u0001\t\u0006\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0005\t3eBA\"E!\t)D#\u0003\u0002F)\u00051\u0001K]3eK\u001aL!a\u0012%\u0003\rM#(/\u001b8h\u0015\t)E\u0003\u0005\u0002K\u001b6\t1J\u0003\u0002M%\u0005\u0011\u0011n\\\u0005\u0003\u001d.\u0013A\"\u00112t_2,H/\u001a)bi\"DQ\u0001U\u0002A\u0002%\u000b1A[1s\u0003I\u0001X\u000f\u001e&be&sG-\u001a=j]\u001eLeNZ8\u0015\tM3\u0006L\u0017\t\u0003=QK!!\u0016\u000b\u0003\u0007%sG\u000fC\u0003X\t\u0001\u0007\u0011*\u0001\u0003qCRD\u0007\"B-\u0005\u0001\u0004\u0011\u0014!\u0003;pa2,g/\u001a7t\u0011\u0015YF\u00011\u0001]\u00039!\u0018\u0010]3`Q&,'/\u0019:dQf\u00042aM\u001e^!\u0015qb,S!a\u0013\tyFC\u0001\u0004UkBdWm\r\t\u0003C\u0012l\u0011A\u0019\u0006\u0003GB\tQ!\u001c;bONL!!\u001a2\u0003!=3XM\u001d:jI\u0012,gnU=nE>d\u0017\u0001F1eIRK\b/\u001a%jKJ\f'o\u00195z\u0013:4w\u000eF\u0002TQ&DQaV\u0003A\u0002%CQaW\u0003A\u0002q\u000bA\u0002];u)>\u0004H.\u001a<fYN$2a\u00157n\u0011\u0015\u0001f\u00011\u0001T\u0011\u0015If\u00011\u00013\u0003Y!W\r\\3uK:{G/V:fIR{\u0007\u000fT3wK2\u001cHCA*q\u0011\u0015\tx\u00011\u0001s\u0003%)8/\u001a3QCRD7\u000fE\u0002\u001fg&K!\u0001\u001e\u000b\u0003\u000b\u0005\u0013(/Y=\u0002\u0011\rdW-\u0019:BY2$\u0012a\u001e\t\u0003=aL!!\u001f\u000b\u0003\tUs\u0017\u000e^\u0001\r\u0015\u0006\u0014Hk\u001c9MKZ,Gn\u001d\t\u00033)\u0019\"AC?\u0011\u0005yq\u0018BA@\u0015\u0005\u0019\te.\u001f*fMR\t10A\u0007hKR4\u0015\u000e\\3TsN$X-\u001c\u000b\u0005\u0003\u000f\t9\u0002\u0005\u0003\u0002\n\u0005MQBAA\u0006\u0015\u0011\ti!a\u0004\u0002\t\u0019LG.\u001a\u0006\u0004\u0003#)\u0013a\u00018j_&!\u0011QCA\u0006\u0005)1\u0015\u000e\\3TsN$X-\u001c\u0005\u0006!2\u0001\r!\u0013")
public final class JarTopLevels
extends JarTypeHierarchy {
    private final Function0<Connection> conn;

    public static FileSystem getFileSystem(AbsolutePath jar) {
        return JarTopLevels$.MODULE$.getFileSystem(jar);
    }

    public Option<List<Tuple2<String, AbsolutePath>>> getTopLevels(AbsolutePath jar) {
        Option option;
        try {
            FileSystem fs = JarTopLevels$.MODULE$.getFileSystem(jar);
            Builder toplevels = package$.MODULE$.List().newBuilder();
            option = JdbcEnrichments$.MODULE$.XtensionConnection((Connection)this.conn.apply()).query(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("select ts.symbol, ts.path\n            |from indexed_jar ij\n            |left join toplevel_symbol ts\n            |on ij.id=ts.jar\n            |where ij.md5=?")), (Function1<PreparedStatement, BoxedUnit>)(Function1 & Serializable)x$1 -> {
                x$1.setString(1, this.getMD5Digest(jar));
                return BoxedUnit.UNIT;
            }, (Function1 & Serializable)rs -> {
                if (rs.getString(1) != null && rs.getString(2) != null) {
                    String symbol = rs.getString(1);
                    AbsolutePath path2 = AbsolutePath$.MODULE$.apply(fs.getPath(rs.getString(2), new String[0]), AbsolutePath$.MODULE$.workingDirectory());
                    return toplevels.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)symbol), (Object)path2));
                }
                return BoxedUnit.UNIT;
            }).headOption().map((Function1 & Serializable)x$2 -> (List)toplevels.result());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ZipError ? true : throwable2 instanceof ZipException) {
                scribe.package$.MODULE$.warn((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogFeature[]{LogFeature$.MODULE$.string2LoggableMessage((Function0 & Serializable)() -> "corrupted jar " + jar + ": " + throwable2)}), new Pkg("scala.meta.internal.metals"), new FileName("JarTopLevels.scala"), new Name("getTopLevels"), new Line(63), MDC$.MODULE$.instance());
                option = None$.MODULE$;
            }
            throw throwable;
        }
        return option;
    }

    public int putJarIndexingInfo(AbsolutePath path2, List<Tuple2<String, AbsolutePath>> toplevels, List<Tuple3<AbsolutePath, String, OverriddenSymbol>> type_hierarchy) {
        if (toplevels.isEmpty() && type_hierarchy.isEmpty()) {
            return 0;
        }
        Option<Object> jar2 = this.addJar(path2);
        return BoxesRunTime.unboxToInt((Object)jar2.map((Function1)(JFunction1.mcII.sp & Serializable)jar -> this.putToplevels(jar, toplevels) + this.putTypeHierarchyInfo(jar, type_hierarchy)).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0));
    }

    @Override
    public int addTypeHierarchyInfo(AbsolutePath path2, List<Tuple3<AbsolutePath, String, OverriddenSymbol>> type_hierarchy) {
        int n;
        try (Statement jarStmt = null;){
            String digest = this.getMD5Digest(path2);
            jarStmt = ((Connection)this.conn.apply()).prepareStatement("update indexed_jar set type_hierarchy_indexed = true where (md5) = (?)");
            jarStmt.setString(1, digest);
            jarStmt.executeUpdate();
            n = BoxesRunTime.unboxToInt((Object)JdbcEnrichments$.MODULE$.XtensionConnection((Connection)this.conn.apply()).query(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("select id\n              |from indexed_jar\n              |where md5=?")), (Function1<PreparedStatement, BoxedUnit>)(Function1 & Serializable)x$3 -> {
                x$3.setString(1, digest);
                return BoxedUnit.UNIT;
            }, (Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.getInt(1))).head());
        }
        int jar = n;
        return this.putTypeHierarchyInfo(jar, type_hierarchy);
    }

    public int putToplevels(int jar, List<Tuple2<String, AbsolutePath>> toplevels) {
        if (toplevels.nonEmpty()) {
            int n;
            ObjectRef symbolStmt = ObjectRef.create(null);
            try {
                try {
                    symbolStmt.elem = ((Connection)this.conn.apply()).prepareStatement("insert into toplevel_symbol (symbol, path, jar) values (?, ?, ?)");
                    toplevels.foreach((Function1 & Serializable)x0$1 -> {
                        JarTopLevels.$anonfun$putToplevels$1(symbolStmt, jar, x0$1);
                        return BoxedUnit.UNIT;
                    });
                    n = BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.wrapIntArray(((PreparedStatement)symbolStmt.elem).executeBatch()).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
                }
                catch (JdbcBatchUpdateException e) {
                    scribe.package$.MODULE$.warn((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogFeature[]{LogFeature$.MODULE$.throwable2LoggableMessage((Function0 & Serializable)() -> e)}), new Pkg("scala.meta.internal.metals"), new FileName("JarTopLevels.scala"), new Name("putToplevels"), new Line(142), MDC$.MODULE$.instance());
                    n = 0;
                }
            }
            finally {
                if ((PreparedStatement)symbolStmt.elem != null) {
                    ((PreparedStatement)symbolStmt.elem).close();
                }
            }
            return n;
        }
        return 0;
    }

    public int deleteNotUsedTopLevels(AbsolutePath[] usedPaths) {
        String md5s = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])usedPaths), (Function1 & Serializable)path2 -> this.getMD5Digest((AbsolutePath)path2), ClassTag$.MODULE$.apply(String.class))), (Function1 & Serializable)x$5 -> "'" + x$5 + "'", ClassTag$.MODULE$.apply(String.class))).mkString(",");
        return JdbcEnrichments$.MODULE$.XtensionConnection((Connection)this.conn.apply()).update("delete from indexed_jar where md5 not in (" + md5s + ")", (Function1<PreparedStatement, BoxedUnit>)(Function1 & Serializable)x$6 -> {
            JarTopLevels.$anonfun$deleteNotUsedTopLevels$3(x$6);
            return BoxedUnit.UNIT;
        });
    }

    public void clearAll() {
        PreparedStatement statement1 = ((Connection)this.conn.apply()).prepareStatement("truncate table toplevel_symbol");
        statement1.execute();
        PreparedStatement statement2 = ((Connection)this.conn.apply()).prepareStatement("truncate table type_hierarchy");
        statement2.execute();
        PreparedStatement statement3 = ((Connection)this.conn.apply()).prepareStatement("delete from indexed_jar");
        statement3.execute();
    }

    public static final /* synthetic */ void $anonfun$putToplevels$1(ObjectRef symbolStmt$1, int jar$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String symbol = (String)tuple2._1();
            AbsolutePath source = (AbsolutePath)tuple2._2();
            ((PreparedStatement)symbolStmt$1.elem).setString(1, symbol);
            ((PreparedStatement)symbolStmt$1.elem).setString(2, source.toString());
            ((PreparedStatement)symbolStmt$1.elem).setInt(3, jar$2);
            ((PreparedStatement)symbolStmt$1.elem).addBatch();
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$deleteNotUsedTopLevels$3(PreparedStatement x$6) {
    }

    public JarTopLevels(Function0<Connection> conn) {
        this.conn = conn;
        super(conn);
    }
}

