/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals.doctor;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.lsp4j.ExecuteCommandParams;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.meta.internal.metals.BuildInfo$;
import scala.meta.internal.metals.ClientCommands$;
import scala.meta.internal.metals.ClientConfiguration;
import scala.meta.internal.metals.HtmlBuilder;
import scala.meta.internal.metals.HtmlBuilder$;
import scala.meta.internal.metals.MetalsHttpServer;
import scala.meta.internal.metals.ParametrizedCommand;
import scala.meta.internal.metals.Urls$;
import scala.meta.internal.metals.clients.language.MetalsLanguageClient;
import scala.meta.internal.metals.config.DoctorFormat;
import scala.meta.internal.metals.config.DoctorFormat$Html$;
import scala.meta.internal.metals.config.DoctorFormat$Json$;
import scala.meta.internal.metals.doctor.Doctor;
import scala.meta.internal.metals.doctor.DoctorFolderResults;
import scala.meta.internal.metals.doctor.DoctorHeader;
import scala.meta.internal.metals.doctor.DoctorResults;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scribe.LogFeature;
import scribe.LogFeature$;
import scribe.mdc.MDC$;
import sourcecode.FileName;
import sourcecode.Line;
import sourcecode.Name;
import sourcecode.Pkg;
import ujson.Obj;
import ujson.Value;
import ujson.package$;

@ScalaSignature(bytes="\u0006\u0005\u0005]c\u0001B\r\u001b\u0001\u0015B\u0001B\u000b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\t}\u0001\u0011\t\u0011)A\u0005\u007f!Aq\t\u0001B\u0001B\u0003%\u0001\n\u0003\u0005L\u0001\t\u0005\t\u0015!\u0003M\u0011\u0015!\u0006\u0001\"\u0001V\u0011\u001dY\u0006A1A\u0005\nqCa!\u001b\u0001!\u0002\u0013i\u0006\"\u00026\u0001\t\u0003Y\u0007\"\u0002;\u0001\t\u0003)\bbBA\u0001\u0001\u0011\u0005\u00111\u0001\u0005\b\u0003\u000b\u0001A\u0011AA\u0002\u0011\u001d\t9\u0001\u0001C\u0005\u0003\u0013Aq!a\b\u0001\t\u0013\t\t\u0003C\u0004\u0002$\u0001!I!!\n\t\u000f\u0005E\u0002\u0001\"\u0003\u0002\"!9\u00111\u0007\u0001\u0005\n\u0005U\u0002bBA\u001d\u0001\u0011%\u00111\b\u0005\n\u0003{\u0001!\u0019!C\u0005\u0003\u007fA\u0001\"a\u0013\u0001A\u0003%\u0011\u0011\t\u0005\n\u0003\u001b\u0002!\u0019!C\u0005\u0003\u007fA\u0001\"a\u0014\u0001A\u0003%\u0011\u0011\t\u0005\n\u0003#\u0002!\u0019!C\u0005\u0003\u007fA\u0001\"a\u0015\u0001A\u0003%\u0011\u0011\t\u0005\b\u0003+\u0002A\u0011BA \u0005)AU-\u00193E_\u000e$xN\u001d\u0006\u00037q\ta\u0001Z8di>\u0014(BA\u000f\u001f\u0003\u0019iW\r^1mg*\u0011q\u0004I\u0001\tS:$XM\u001d8bY*\u0011\u0011EI\u0001\u0005[\u0016$\u0018MC\u0001$\u0003\u0015\u00198-\u00197b\u0007\u0001\u0019\"\u0001\u0001\u0014\u0011\u0005\u001dBS\"\u0001\u0012\n\u0005%\u0012#AB!osJ+g-A\u0004e_\u000e$xN]:\u0011\u0007\u001dbc&\u0003\u0002.E\tIa)\u001e8di&|g\u000e\r\t\u0004_]RdB\u0001\u00196\u001d\t\tD'D\u00013\u0015\t\u0019D%\u0001\u0004=e>|GOP\u0005\u0002G%\u0011aGI\u0001\ba\u0006\u001c7.Y4f\u0013\tA\u0014H\u0001\u0003MSN$(B\u0001\u001c#!\tYD(D\u0001\u001b\u0013\ti$D\u0001\u0004E_\u000e$xN]\u0001\u000bQR$\boU3sm\u0016\u0014\bcA\u0014-\u0001B\u0019q%Q\"\n\u0005\t\u0013#AB(qi&|g\u000e\u0005\u0002E\u000b6\tA$\u0003\u0002G9\t\u0001R*\u001a;bYNDE\u000f\u001e9TKJ4XM]\u0001\rG2LWM\u001c;D_:4\u0017n\u001a\t\u0003\t&K!A\u0013\u000f\u0003'\rc\u0017.\u001a8u\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0002\u001d1\fgnZ;bO\u0016\u001cE.[3oiB\u0011QJU\u0007\u0002\u001d*\u0011q\nU\u0001\tY\u0006tw-^1hK*\u0011\u0011\u000bH\u0001\bG2LWM\u001c;t\u0013\t\u0019fJ\u0001\u000bNKR\fGn\u001d'b]\u001e,\u0018mZ3DY&,g\u000e^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000bY;\u0006,\u0017.\u0011\u0005m\u0002\u0001\"\u0002\u0016\u0006\u0001\u0004Y\u0003\"\u0002 \u0006\u0001\u0004y\u0004\"B$\u0006\u0001\u0004A\u0005\"B&\u0006\u0001\u0004a\u0015!C5t-&\u001c\u0018N\u00197f+\u0005i\u0006C\u00010h\u001b\u0005y&B\u00011b\u0003\u0019\tGo\\7jG*\u0011!mY\u0001\u000bG>t7-\u001e:sK:$(B\u00013f\u0003\u0011)H/\u001b7\u000b\u0003\u0019\fAA[1wC&\u0011\u0001n\u0018\u0002\u000e\u0003R|W.[2C_>dW-\u00198\u0002\u0015%\u001ch+[:jE2,\u0007%A\u000bp]ZK7/\u001b2jY&$\u0018\u0010R5e\u0007\"\fgnZ3\u0015\u00051|\u0007CA\u0014n\u0013\tq'E\u0001\u0003V]&$\b\"\u00029\t\u0001\u0004\t\u0018\u0001\u00038foN#\u0018\r^3\u0011\u0005\u001d\u0012\u0018BA:#\u0005\u001d\u0011un\u001c7fC:\f\u0001\u0003\u001d:pE2,Wn\u001d%u[2\u0004\u0016mZ3\u0015\u0005Yt\bCA<|\u001d\tA\u0018\u0010\u0005\u00022E%\u0011!PI\u0001\u0007!J,G-\u001a4\n\u0005ql(AB*ue&twM\u0003\u0002{E!)q0\u0003a\u0001m\u0006\u0019QO\u001d7\u0002!\u0015DXmY;uKJ+h\u000eR8di>\u0014H#\u00017\u0002)\u0015DXmY;uKJ+gM]3tQ\u0012{7\r^8s\u00035)\u00070Z2vi\u0016$un\u0019;peR)A.a\u0003\u0002\u0016!9\u0011Q\u0002\u0007A\u0002\u0005=\u0011!D2mS\u0016tGoQ8n[\u0006tG\r\u0005\u0003E\u0003#1\u0018bAA\n9\t\u0019\u0002+\u0019:b[\u0016$(/\u001b>fI\u000e{W.\\1oI\"9\u0011q\u0003\u0007A\u0002\u0005e\u0011\u0001C8o'\u0016\u0014h/\u001a:\u0011\u000b\u001d\nYb\u00117\n\u0007\u0005u!EA\u0005Gk:\u001cG/[8oc\u0005\u0001\"-^5mIR\u000b'oZ3ug\"#X\u000e\u001c\u000b\u0002m\u0006\t\"-^5mIR\u000b'oZ3ugR\u000b'\r\\3\u0015\u00071\f9\u0003C\u0004\u0002*9\u0001\r!a\u000b\u0002\t!$X\u000e\u001c\t\u0004\t\u00065\u0012bAA\u00189\tY\u0001\n^7m\u0005VLG\u000eZ3s\u0003A\u0011W/\u001b7e)\u0006\u0014x-\u001a;t\u0015N|g.\u0001\u0006hKRTEm[%oM>$\"!a\u000e\u0011\u0007\u001d\ne/A\u000ebe\u0016lU\u000f\u001c;ja2,wk\u001c:lgB\f7-\u001a$pY\u0012,'o]\u000b\u0002c\u0006YAm\\2u_J$\u0016\u000e\u001e7f+\t\t\t\u0005\u0005\u0003\u0002D\u0005%SBAA#\u0015\r\t9%Z\u0001\u0005Y\u0006tw-C\u0002}\u0003\u000b\nA\u0002Z8di>\u0014H+\u001b;mK\u0002\nqB\u001b3l-\u0016\u00148/[8o)&$H.Z\u0001\u0011U\u0012\\g+\u001a:tS>tG+\u001b;mK\u0002\n!c]3sm\u0016\u0014h+\u001a:tS>tG+\u001b;mK\u0006\u00192/\u001a:wKJ4VM]:j_:$\u0016\u000e\u001e7fA\u00051\"-^5mIR\u000b'oZ3u\t\u0016\u001c8M]5qi&|g\u000e")
public class HeadDoctor {
    private final Function0<List<Doctor>> doctors;
    private final Function0<Option<MetalsHttpServer>> httpServer;
    private final ClientConfiguration clientConfig;
    private final MetalsLanguageClient languageClient;
    private final AtomicBoolean isVisible;
    private final String doctorTitle;
    private final String jdkVersionTitle;
    private final String serverVersionTitle;

    private AtomicBoolean isVisible() {
        return this.isVisible;
    }

    public void onVisibilityDidChange(boolean newState) {
        this.isVisible().set(newState);
    }

    public String problemsHtmlPage(String url) {
        String livereload = Urls$.MODULE$.livereload(url);
        return HtmlBuilder$.MODULE$.apply().page(this.doctorTitle(), (List)new .colon.colon((Object)livereload, (List)new .colon.colon((Object)HtmlBuilder$.MODULE$.htmlCSS(), (List)Nil$.MODULE$)), "style='padding: .75rem; font-size: 10px'", (Function1 & Serializable)html -> {
            html.section("Build targets", (Function1 & Serializable)html -> {
                $this.buildTargetsTable(html);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        }).render();
    }

    public void executeRunDoctor() {
        this.onVisibilityDidChange(true);
        this.executeDoctor(ClientCommands$.MODULE$.RunDoctor(), (Function1<MetalsHttpServer, BoxedUnit>)(Function1 & Serializable)server -> {
            Urls$.MODULE$.openBrowser(server.address() + "/doctor");
            return BoxedUnit.UNIT;
        });
    }

    public void executeRefreshDoctor() {
        this.executeDoctor(ClientCommands$.MODULE$.ReloadDoctor(), (Function1<MetalsHttpServer, BoxedUnit>)(Function1 & Serializable)server -> {
            server.reload();
            return BoxedUnit.UNIT;
        });
    }

    private void executeDoctor(ParametrizedCommand<String> clientCommand, Function1<MetalsHttpServer, BoxedUnit> onServer) {
        boolean shouldDisplay;
        boolean isVisibilityProvider = this.clientConfig.isDoctorVisibilityProvider();
        boolean bl = shouldDisplay = isVisibilityProvider && this.isVisible().get();
        if (shouldDisplay || !isVisibilityProvider) {
            if (this.clientConfig.isExecuteClientCommandProvider() && !this.clientConfig.isHttpEnabled()) {
                String string;
                DoctorFormat.DoctorFormat doctorFormat = this.clientConfig.doctorFormat();
                if (DoctorFormat$Json$.MODULE$.equals(doctorFormat)) {
                    string = this.buildTargetsJson();
                } else if (DoctorFormat$Html$.MODULE$.equals(doctorFormat)) {
                    string = this.buildTargetsHtml();
                } else {
                    throw new MatchError((Object)doctorFormat);
                }
                String output = string;
                ExecuteCommandParams params = clientCommand.toExecuteCommandParams(output);
                this.languageClient.metalsExecuteClientCommand(params);
                return;
            }
            Option option = (Option)this.httpServer.apply();
            if (option instanceof Some) {
                Some some = (Some)option;
                MetalsHttpServer server = (MetalsHttpServer)some.value();
                BoxedUnit cfr_ignored_0 = (BoxedUnit)onServer.apply((Object)server);
                return;
            }
            if (None$.MODULE$.equals(option)) {
                BoxedUnit cfr_ignored_1 = (BoxedUnit)scribe.package$.MODULE$.warn((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogFeature[]{LogFeature$.MODULE$.string2LoggableMessage((Function0 & Serializable)() -> "Unable to run doctor. Make sure `isHttpEnabled` is set to `true`.")}), new Pkg("scala.meta.internal.metals.doctor"), new FileName("HeadDoctor.scala"), new Name("executeDoctor"), new Line(89), MDC$.MODULE$.instance());
                return;
            }
            throw new MatchError((Object)option);
        }
    }

    private String buildTargetsHtml() {
        HtmlBuilder qual$1 = new HtmlBuilder();
        String x$12 = "h1";
        String x$2 = qual$1.element$default$2();
        Function1 & Serializable x$3 = (Function1 & Serializable)x$1 -> {
            x$1.text(this.doctorTitle());
            return BoxedUnit.UNIT;
        };
        return qual$1.element("h1", x$2, (Function1)x$3).call((Function1 & Serializable)html -> {
            this.buildTargetsTable(html);
            return BoxedUnit.UNIT;
        }).render();
    }

    private void buildTargetsTable(HtmlBuilder html) {
        Option<String> jdkInfo = this.getJdkInfo();
        jdkInfo.foreach((Function1 & Serializable)jdkMsg -> html.element("p", html.element$default$2(), (Function1 & Serializable)builder -> {
            HeadDoctor.$anonfun$buildTargetsTable$2(this, jdkMsg, builder);
            return BoxedUnit.UNIT;
        }));
        html.element("p", html.element$default$2(), (Function1 & Serializable)builder -> {
            HeadDoctor.$anonfun$buildTargetsTable$3(this, builder);
            return BoxedUnit.UNIT;
        });
        html.element("p", html.element$default$2(), (Function1 & Serializable)x$2 -> {
            x$2.text(this.buildTargetDescription());
            return BoxedUnit.UNIT;
        });
        boolean includeWorkspaceFolderName = this.areMultipleWorkspaceFolders();
        ((List)this.doctors.apply()).foreach((Function1 & Serializable)x$3 -> {
            x$3.buildTargetsTable(html, includeWorkspaceFolderName);
            return BoxedUnit.UNIT;
        });
    }

    private String buildTargetsJson() {
        List results = ((List)this.doctors.apply()).map((Function1 & Serializable)x$4 -> x$4.buildTargetsJson());
        Option jdkInfo = this.getJdkInfo().map((Function1 & Serializable)info -> this.jdkVersionTitle() + info);
        String serverInfo = this.serverVersionTitle() + BuildInfo$.MODULE$.metalsVersion();
        DoctorHeader header = new DoctorHeader((Option<String>)jdkInfo, serverInfo, this.buildTargetDescription());
        Obj result = new DoctorResults(this.doctorTitle(), header, (List<DoctorFolderResults>)results).toJson();
        return package$.MODULE$.write((Value)result, package$.MODULE$.write$default$2(), package$.MODULE$.write$default$3(), package$.MODULE$.write$default$4());
    }

    private Option<String> getJdkInfo() {
        return Option$.MODULE$.apply((Object)System.getProperty("java.version")).flatMap((Function1 & Serializable)version -> Option$.MODULE$.apply((Object)System.getProperty("java.vendor")).flatMap((Function1 & Serializable)vendor -> Option$.MODULE$.apply((Object)System.getProperty("java.home")).map((Function1 & Serializable)home -> version + " from " + vendor + " located at " + home)));
    }

    private boolean areMultipleWorkspaceFolders() {
        return ((List)this.doctors.apply()).length() > 1;
    }

    private String doctorTitle() {
        return this.doctorTitle;
    }

    private String jdkVersionTitle() {
        return this.jdkVersionTitle;
    }

    private String serverVersionTitle() {
        return this.serverVersionTitle;
    }

    private String buildTargetDescription() {
        return "Below are listed the build targets " + (this.areMultipleWorkspaceFolders() ? "for each workspace folder. " : "for this workspace. ") + "One build target corresponds to one classpath. For example, normally one sbt project maps to two build targets: main and test.";
    }

    public static final /* synthetic */ void $anonfun$buildTargetsTable$2(HeadDoctor $this, String jdkMsg$1, HtmlBuilder builder) {
        builder.bold($this.jdkVersionTitle());
        builder.text(jdkMsg$1);
    }

    public static final /* synthetic */ void $anonfun$buildTargetsTable$3(HeadDoctor $this, HtmlBuilder builder) {
        builder.bold($this.serverVersionTitle());
        builder.text(BuildInfo$.MODULE$.metalsVersion());
    }

    public HeadDoctor(Function0<List<Doctor>> doctors, Function0<Option<MetalsHttpServer>> httpServer, ClientConfiguration clientConfig, MetalsLanguageClient languageClient) {
        this.doctors = doctors;
        this.httpServer = httpServer;
        this.clientConfig = clientConfig;
        this.languageClient = languageClient;
        this.isVisible = new AtomicBoolean(false);
        this.doctorTitle = "Metals Doctor";
        this.jdkVersionTitle = "Metals Java: ";
        this.serverVersionTitle = "Metals Server version: ";
    }
}

