/*
 * Decompiled with CFR 0.152.
 */
package org.scalafmt.cli;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.file.Path;
import java.util.Date;
import org.scalafmt.Versions$;
import org.scalafmt.cli.CliArgParser$;
import org.scalafmt.cli.CliOptions;
import org.scalafmt.cli.CommonOptions;
import org.scalafmt.cli.Override$;
import org.scalafmt.cli.Stdout$;
import org.scalafmt.cli.WriteMode;
import org.scalafmt.util.AbsoluteFile;
import org.scalafmt.util.AbsoluteFile$;
import org.scalafmt.util.GitOps;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scopt.OptionParser;
import scopt.Read$;

public final class CliArgParser$ {
    public static CliArgParser$ MODULE$;
    private final String usageExamples;
    private final OptionParser<CliOptions> scoptParser;

    static {
        new CliArgParser$();
    }

    public String usageExamples() {
        return this.usageExamples;
    }

    public OptionParser<CliOptions> scoptParser() {
        return this.scoptParser;
    }

    public String buildInfo() {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(35).append("build commit: ").append(Versions$.MODULE$.commit()).append("\n       |build time: ").append(new Date(new StringOps(Predef$.MODULE$.augmentString(Versions$.MODULE$.timestamp())).toLong())).toString())).stripMargin();
    }

    private CliArgParser$() {
        MODULE$ = this;
        this.usageExamples = new StringOps(Predef$.MODULE$.augmentString("|scalafmt # Format all files in the current project, configuration is determined in this order:\n       |         # 1. .scalafmt.conf file in current directory\n       |         # 2. .scalafmt.conf inside root directory of current git repo\n       |         # 3. no configuration, default style\n       |scalafmt --test # throw exception on mis-formatted files, won't write to files.\n       |scalafmt --diff # Format all files that were edited in git diff against master branch.\n       |scalafmt --diff-branch 2.x # same as --diff, except against branch 2.x\n       |scalafmt --stdin # read from stdin and print to stdout\n       |scalafmt --stdin --assume-filename foo.sbt < foo.sbt # required when using --stdin to format .sbt files.\n       |scalafmt Code1.scala A.scala       # write formatted contents to file.\n       |scalafmt --stdout Code.scala       # print formatted contents to stdout.\n       |scalafmt --exclude target          # format all files in directory excluding target\n       |scalafmt --config .scalafmt.conf   # read custom style from file.\n       |scalafmt --config-str \"style=IntelliJ\" # define custom style as a flag, must be quoted.")).stripMargin();
        this.scoptParser = new OptionParser<CliOptions>(){

            public boolean showUsageOnError() {
                return false;
            }

            private CliOptions printAndExit(boolean inludeUsage, BoxedUnit ignore, CliOptions c) {
                if (inludeUsage) {
                    this.showUsage();
                } else {
                    this.showHeader();
                }
                throw scala.sys.package$.MODULE$.exit();
            }

            private CliOptions readConfig(String contents, CliOptions c) {
                Some x$1 = new Some((Object)contents);
                Option<Path> x$2 = c.copy$default$1();
                Set<Range> x$3 = c.copy$default$3();
                Seq<AbsoluteFile> x$4 = c.copy$default$4();
                Seq<String> x$5 = c.copy$default$5();
                WriteMode x$6 = c.copy$default$6();
                boolean x$7 = c.copy$default$7();
                boolean x$8 = c.copy$default$8();
                boolean x$9 = c.copy$default$9();
                boolean x$10 = c.copy$default$10();
                Option<Object> x$11 = c.copy$default$11();
                boolean x$12 = c.copy$default$12();
                Option<String> x$13 = c.copy$default$13();
                String x$14 = c.copy$default$14();
                Option<AbsoluteFile> x$15 = c.copy$default$15();
                CommonOptions x$16 = c.copy$default$16();
                Function1<AbsoluteFile, GitOps> x$17 = c.copy$default$17();
                boolean x$18 = c.copy$default$18();
                return c.copy(x$2, (Option<String>)x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18);
            }

            private CliOptions readConfigFromFile(String file, CliOptions c) {
                AbsoluteFile configFile = AbsoluteFile$.MODULE$.fromFile(new File(file), c.common().workingDirectory());
                return c.copy((Option<Path>)new Some((Object)configFile.jfile().toPath()), c.copy$default$2(), c.copy$default$3(), c.copy$default$4(), c.copy$default$5(), c.copy$default$6(), c.copy$default$7(), c.copy$default$8(), c.copy$default$9(), c.copy$default$10(), c.copy$default$11(), c.copy$default$12(), c.copy$default$13(), c.copy$default$14(), c.copy$default$15(), c.copy$default$16(), c.copy$default$17(), c.copy$default$18());
            }

            private CliOptions addFile(File file, CliOptions c) {
                AbsoluteFile absFile = AbsoluteFile$.MODULE$.fromFile(file, c.common().workingDirectory());
                Seq x$1 = (Seq)c.customFiles().$colon$plus((Object)absFile, Seq$.MODULE$.canBuildFrom());
                Option<Path> x$2 = c.copy$default$1();
                Option<String> x$3 = c.copy$default$2();
                Set<Range> x$4 = c.copy$default$3();
                Seq<String> x$5 = c.copy$default$5();
                WriteMode x$6 = c.copy$default$6();
                boolean x$7 = c.copy$default$7();
                boolean x$8 = c.copy$default$8();
                boolean x$9 = c.copy$default$9();
                boolean x$10 = c.copy$default$10();
                Option<Object> x$11 = c.copy$default$11();
                boolean x$12 = c.copy$default$12();
                Option<String> x$13 = c.copy$default$13();
                String x$14 = c.copy$default$14();
                Option<AbsoluteFile> x$15 = c.copy$default$15();
                CommonOptions x$16 = c.copy$default$16();
                Function1<AbsoluteFile, GitOps> x$17 = c.copy$default$17();
                boolean x$18 = c.copy$default$18();
                return c.copy(x$2, x$3, x$4, (Seq<AbsoluteFile>)x$1, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18);
            }

            public static final /* synthetic */ CliOptions $anonfun$new$7(boolean opt, CliOptions c) {
                Some x$55 = new Some((Object)BoxesRunTime.boxToBoolean((boolean)opt));
                Option<Path> x$56 = c.copy$default$1();
                Option<String> x$57 = c.copy$default$2();
                Set<Range> x$58 = c.copy$default$3();
                Seq<AbsoluteFile> x$59 = c.copy$default$4();
                Seq<String> x$60 = c.copy$default$5();
                WriteMode x$61 = c.copy$default$6();
                boolean x$62 = c.copy$default$7();
                boolean x$63 = c.copy$default$8();
                boolean x$64 = c.copy$default$9();
                boolean x$65 = c.copy$default$10();
                boolean x$66 = c.copy$default$12();
                Option<String> x$67 = c.copy$default$13();
                String x$68 = c.copy$default$14();
                Option<AbsoluteFile> x$69 = c.copy$default$15();
                CommonOptions x$70 = c.copy$default$16();
                Function1<AbsoluteFile, GitOps> x$71 = c.copy$default$17();
                boolean x$72 = c.copy$default$18();
                return c.copy(x$56, x$57, x$58, x$59, x$60, x$61, x$62, x$63, x$64, x$65, (Option<Object>)x$55, x$66, x$67, x$68, x$69, x$70, x$71, x$72);
            }
            {
                this.head((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"scalafmt", Versions$.MODULE$.nightly()}));
                this.opt('h', "help", Read$.MODULE$.unitRead()).action((Function2 & Serializable & scala.Serializable)(ignore, c) -> this.printAndExit(true, (BoxedUnit)ignore, (CliOptions)c)).text("prints this usage text");
                this.opt('v', "version", Read$.MODULE$.unitRead()).action((Function2 & Serializable & scala.Serializable)(ignore, c) -> this.printAndExit(false, (BoxedUnit)ignore, (CliOptions)c)).text("print version ");
                this.arg("<file>...", Read$.MODULE$.fileRead()).optional().unbounded().action((Function2 & Serializable & scala.Serializable)(file, c) -> this.addFile((File)file, (CliOptions)c)).text("file or directory, in which case all *.scala files are formatted.");
                this.opt('f', "files", Read$.MODULE$.seqRead(Read$.MODULE$.fileRead())).action((Function2 & Serializable & scala.Serializable)(files, c) -> {
                    Seq x$1 = AbsoluteFile$.MODULE$.fromFiles(files, c.common().workingDirectory());
                    Option<Path> x$2 = c.copy$default$1();
                    Option<String> x$3 = c.copy$default$2();
                    Set<Range> x$4 = c.copy$default$3();
                    Seq<String> x$5 = c.copy$default$5();
                    WriteMode x$6 = c.copy$default$6();
                    boolean x$7 = c.copy$default$7();
                    boolean x$8 = c.copy$default$8();
                    boolean x$9 = c.copy$default$9();
                    boolean x$10 = c.copy$default$10();
                    Option<Object> x$11 = c.copy$default$11();
                    boolean x$12 = c.copy$default$12();
                    Option<String> x$13 = c.copy$default$13();
                    String x$14 = c.copy$default$14();
                    Option<AbsoluteFile> x$15 = c.copy$default$15();
                    CommonOptions x$16 = c.copy$default$16();
                    Function1<AbsoluteFile, GitOps> x$17 = c.copy$default$17();
                    boolean x$18 = c.copy$default$18();
                    return c.copy(x$2, x$3, x$4, (Seq<AbsoluteFile>)x$1, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18);
                }).hidden().text("file or directory, in which case all *.scala files are formatted. Deprecated: pass files as arguments");
                this.opt('i', "in-place", Read$.MODULE$.unitRead()).action((Function2 & Serializable & scala.Serializable)(opt, c) -> {
                    Override$ x$19 = Override$.MODULE$;
                    Option<Path> x$20 = c.copy$default$1();
                    Option<String> x$21 = c.copy$default$2();
                    Set<Range> x$22 = c.copy$default$3();
                    Seq<AbsoluteFile> x$23 = c.copy$default$4();
                    Seq<String> x$24 = c.copy$default$5();
                    boolean x$25 = c.copy$default$7();
                    boolean x$26 = c.copy$default$8();
                    boolean x$27 = c.copy$default$9();
                    boolean x$28 = c.copy$default$10();
                    Option<Object> x$29 = c.copy$default$11();
                    boolean x$30 = c.copy$default$12();
                    Option<String> x$31 = c.copy$default$13();
                    String x$32 = c.copy$default$14();
                    Option<AbsoluteFile> x$33 = c.copy$default$15();
                    CommonOptions x$34 = c.copy$default$16();
                    Function1<AbsoluteFile, GitOps> x$35 = c.copy$default$17();
                    boolean x$36 = c.copy$default$18();
                    return c.copy(x$20, x$21, x$22, x$23, x$24, x$19, x$25, x$26, x$27, x$28, x$29, x$30, x$31, x$32, x$33, x$34, x$35, x$36);
                }).hidden().text("format files in-place (default)");
                this.opt("stdout", Read$.MODULE$.unitRead()).action((Function2 & Serializable & scala.Serializable)(opt, c) -> {
                    Stdout$ x$37 = Stdout$.MODULE$;
                    Option<Path> x$38 = c.copy$default$1();
                    Option<String> x$39 = c.copy$default$2();
                    Set<Range> x$40 = c.copy$default$3();
                    Seq<AbsoluteFile> x$41 = c.copy$default$4();
                    Seq<String> x$42 = c.copy$default$5();
                    boolean x$43 = c.copy$default$7();
                    boolean x$44 = c.copy$default$8();
                    boolean x$45 = c.copy$default$9();
                    boolean x$46 = c.copy$default$10();
                    Option<Object> x$47 = c.copy$default$11();
                    boolean x$48 = c.copy$default$12();
                    Option<String> x$49 = c.copy$default$13();
                    String x$50 = c.copy$default$14();
                    Option<AbsoluteFile> x$51 = c.copy$default$15();
                    CommonOptions x$52 = c.copy$default$16();
                    Function1<AbsoluteFile, GitOps> x$53 = c.copy$default$17();
                    boolean x$54 = c.copy$default$18();
                    return c.copy(x$38, x$39, x$40, x$41, x$42, x$37, x$43, x$44, x$45, x$46, x$47, x$48, x$49, x$50, x$51, x$52, x$53, x$54);
                }).text("write formatted files to stdout");
                this.opt("git", Read$.MODULE$.booleanRead()).action((Function2 & Serializable & scala.Serializable)(opt, c) -> anon.1.$anonfun$new$7(BoxesRunTime.unboxToBoolean((Object)opt), c)).text("if true, ignore files in .gitignore (default false)");
                this.opt("exclude", Read$.MODULE$.seqRead(Read$.MODULE$.stringRead())).action((Function2 & Serializable & scala.Serializable)(excludes, c) -> {
                    Seq x$73 = excludes;
                    Option<Path> x$74 = c.copy$default$1();
                    Option<String> x$75 = c.copy$default$2();
                    Set<Range> x$76 = c.copy$default$3();
                    Seq<AbsoluteFile> x$77 = c.copy$default$4();
                    WriteMode x$78 = c.copy$default$6();
                    boolean x$79 = c.copy$default$7();
                    boolean x$80 = c.copy$default$8();
                    boolean x$81 = c.copy$default$9();
                    boolean x$82 = c.copy$default$10();
                    Option<Object> x$83 = c.copy$default$11();
                    boolean x$84 = c.copy$default$12();
                    Option<String> x$85 = c.copy$default$13();
                    String x$86 = c.copy$default$14();
                    Option<AbsoluteFile> x$87 = c.copy$default$15();
                    CommonOptions x$88 = c.copy$default$16();
                    Function1<AbsoluteFile, GitOps> x$89 = c.copy$default$17();
                    boolean x$90 = c.copy$default$18();
                    return c.copy(x$74, x$75, x$76, x$77, (Seq<String>)x$73, x$78, x$79, x$80, x$81, x$82, x$83, x$84, x$85, x$86, x$87, x$88, x$89, x$90);
                }).text("file or directory, in which case all *.scala files are formatted.");
                this.opt('c', "config", Read$.MODULE$.stringRead()).action((Function2 & Serializable & scala.Serializable)(file, c) -> this.readConfigFromFile((String)file, (CliOptions)c)).text("a file path to .scalafmt.conf.");
                this.opt("config-str", Read$.MODULE$.stringRead()).action((Function2 & Serializable & scala.Serializable)(contents, c) -> this.readConfig((String)contents, (CliOptions)c)).text("configuration defined as a string");
                this.opt("stdin", Read$.MODULE$.unitRead()).action((Function2 & Serializable & scala.Serializable)(x$1, c) -> {
                    boolean x$91 = true;
                    Option<Path> x$92 = c.copy$default$1();
                    Option<String> x$93 = c.copy$default$2();
                    Set<Range> x$94 = c.copy$default$3();
                    Seq<AbsoluteFile> x$95 = c.copy$default$4();
                    Seq<String> x$96 = c.copy$default$5();
                    WriteMode x$97 = c.copy$default$6();
                    boolean x$98 = c.copy$default$7();
                    boolean x$99 = c.copy$default$9();
                    boolean x$100 = c.copy$default$10();
                    Option<Object> x$101 = c.copy$default$11();
                    boolean x$102 = c.copy$default$12();
                    Option<String> x$103 = c.copy$default$13();
                    String x$104 = c.copy$default$14();
                    Option<AbsoluteFile> x$105 = c.copy$default$15();
                    CommonOptions x$106 = c.copy$default$16();
                    Function1<AbsoluteFile, GitOps> x$107 = c.copy$default$17();
                    boolean x$108 = c.copy$default$18();
                    return c.copy(x$92, x$93, x$94, x$95, x$96, x$97, x$98, x$91, x$99, x$100, x$101, x$102, x$103, x$104, x$105, x$106, x$107, x$108);
                }).text("read from stdin and print to stdout");
                this.opt("no-stderr", Read$.MODULE$.unitRead()).action((Function2 & Serializable & scala.Serializable)(x$2, c) -> {
                    boolean x$109 = true;
                    Option<Path> x$110 = c.copy$default$1();
                    Option<String> x$111 = c.copy$default$2();
                    Set<Range> x$112 = c.copy$default$3();
                    Seq<AbsoluteFile> x$113 = c.copy$default$4();
                    Seq<String> x$114 = c.copy$default$5();
                    WriteMode x$115 = c.copy$default$6();
                    boolean x$116 = c.copy$default$7();
                    boolean x$117 = c.copy$default$8();
                    boolean x$118 = c.copy$default$9();
                    boolean x$119 = c.copy$default$10();
                    Option<Object> x$120 = c.copy$default$11();
                    boolean x$121 = c.copy$default$12();
                    Option<String> x$122 = c.copy$default$13();
                    String x$123 = c.copy$default$14();
                    Option<AbsoluteFile> x$124 = c.copy$default$15();
                    CommonOptions x$125 = c.copy$default$16();
                    Function1<AbsoluteFile, GitOps> x$126 = c.copy$default$17();
                    return c.copy(x$110, x$111, x$112, x$113, x$114, x$115, x$116, x$117, x$118, x$119, x$120, x$121, x$122, x$123, x$124, x$125, x$126, x$109);
                }).text("don't use strerr for messages, output to stdout");
                this.opt("assume-filename", Read$.MODULE$.stringRead()).action((Function2 & Serializable & scala.Serializable)(filename, c) -> {
                    String x$127 = filename;
                    Option<Path> x$128 = c.copy$default$1();
                    Option<String> x$129 = c.copy$default$2();
                    Set<Range> x$130 = c.copy$default$3();
                    Seq<AbsoluteFile> x$131 = c.copy$default$4();
                    Seq<String> x$132 = c.copy$default$5();
                    WriteMode x$133 = c.copy$default$6();
                    boolean x$134 = c.copy$default$7();
                    boolean x$135 = c.copy$default$8();
                    boolean x$136 = c.copy$default$9();
                    boolean x$137 = c.copy$default$10();
                    Option<Object> x$138 = c.copy$default$11();
                    boolean x$139 = c.copy$default$12();
                    Option<String> x$140 = c.copy$default$13();
                    Option<AbsoluteFile> x$141 = c.copy$default$15();
                    CommonOptions x$142 = c.copy$default$16();
                    Function1<AbsoluteFile, GitOps> x$143 = c.copy$default$17();
                    boolean x$144 = c.copy$default$18();
                    return c.copy(x$128, x$129, x$130, x$131, x$132, x$133, x$134, x$135, x$136, x$137, x$138, x$139, x$140, x$127, x$141, x$142, x$143, x$144);
                }).text("when using --stdin, use --assume-filename to hint to scalafmt that the input is an .sbt file.");
                this.opt("test", Read$.MODULE$.unitRead()).action((Function2 & Serializable & scala.Serializable)(x$3, c) -> {
                    boolean x$145 = true;
                    Option<Path> x$146 = c.copy$default$1();
                    Option<String> x$147 = c.copy$default$2();
                    Set<Range> x$148 = c.copy$default$3();
                    Seq<AbsoluteFile> x$149 = c.copy$default$4();
                    Seq<String> x$150 = c.copy$default$5();
                    WriteMode x$151 = c.copy$default$6();
                    boolean x$152 = c.copy$default$8();
                    boolean x$153 = c.copy$default$9();
                    boolean x$154 = c.copy$default$10();
                    Option<Object> x$155 = c.copy$default$11();
                    boolean x$156 = c.copy$default$12();
                    Option<String> x$157 = c.copy$default$13();
                    String x$158 = c.copy$default$14();
                    Option<AbsoluteFile> x$159 = c.copy$default$15();
                    CommonOptions x$160 = c.copy$default$16();
                    Function1<AbsoluteFile, GitOps> x$161 = c.copy$default$17();
                    boolean x$162 = c.copy$default$18();
                    return c.copy(x$146, x$147, x$148, x$149, x$150, x$151, x$145, x$152, x$153, x$154, x$155, x$156, x$157, x$158, x$159, x$160, x$161, x$162);
                }).text("test for mis-formatted code, exits with status 1 on failure.");
                this.opt("migrate2hocon", Read$.MODULE$.fileRead()).action((Function2 & Serializable & scala.Serializable)(file, c) -> {
                    Some x$163 = new Some((Object)AbsoluteFile$.MODULE$.fromFile(file, c.common().workingDirectory()));
                    Option<Path> x$164 = c.copy$default$1();
                    Option<String> x$165 = c.copy$default$2();
                    Set<Range> x$166 = c.copy$default$3();
                    Seq<AbsoluteFile> x$167 = c.copy$default$4();
                    Seq<String> x$168 = c.copy$default$5();
                    WriteMode x$169 = c.copy$default$6();
                    boolean x$170 = c.copy$default$7();
                    boolean x$171 = c.copy$default$8();
                    boolean x$172 = c.copy$default$9();
                    boolean x$173 = c.copy$default$10();
                    Option<Object> x$174 = c.copy$default$11();
                    boolean x$175 = c.copy$default$12();
                    Option<String> x$176 = c.copy$default$13();
                    String x$177 = c.copy$default$14();
                    CommonOptions x$178 = c.copy$default$16();
                    Function1<AbsoluteFile, GitOps> x$179 = c.copy$default$17();
                    boolean x$180 = c.copy$default$18();
                    return c.copy(x$164, x$165, x$166, x$167, x$168, x$169, x$170, x$171, x$172, x$173, x$174, x$175, x$176, x$177, (Option<AbsoluteFile>)x$163, x$178, x$179, x$180);
                }).text("migrate .scalafmt CLI style configuration to hocon style configuration in .scalafmt.conf");
                this.opt("diff", Read$.MODULE$.unitRead()).action((Function2 & Serializable & scala.Serializable)(x$4, c) -> {
                    Some x$181 = new Some((Object)"master");
                    Option<Path> x$182 = c.copy$default$1();
                    Option<String> x$183 = c.copy$default$2();
                    Set<Range> x$184 = c.copy$default$3();
                    Seq<AbsoluteFile> x$185 = c.copy$default$4();
                    Seq<String> x$186 = c.copy$default$5();
                    WriteMode x$187 = c.copy$default$6();
                    boolean x$188 = c.copy$default$7();
                    boolean x$189 = c.copy$default$8();
                    boolean x$190 = c.copy$default$9();
                    boolean x$191 = c.copy$default$10();
                    Option<Object> x$192 = c.copy$default$11();
                    boolean x$193 = c.copy$default$12();
                    String x$194 = c.copy$default$14();
                    Option<AbsoluteFile> x$195 = c.copy$default$15();
                    CommonOptions x$196 = c.copy$default$16();
                    Function1<AbsoluteFile, GitOps> x$197 = c.copy$default$17();
                    boolean x$198 = c.copy$default$18();
                    return c.copy(x$182, x$183, x$184, x$185, x$186, x$187, x$188, x$189, x$190, x$191, x$192, x$193, (Option<String>)x$181, x$194, x$195, x$196, x$197, x$198);
                }).text("If set, only format edited files in git diff against master.");
                this.opt("diff-branch", Read$.MODULE$.stringRead()).action((Function2 & Serializable & scala.Serializable)(branch, c) -> {
                    Some x$199 = new Some(branch);
                    Option<Path> x$200 = c.copy$default$1();
                    Option<String> x$201 = c.copy$default$2();
                    Set<Range> x$202 = c.copy$default$3();
                    Seq<AbsoluteFile> x$203 = c.copy$default$4();
                    Seq<String> x$204 = c.copy$default$5();
                    WriteMode x$205 = c.copy$default$6();
                    boolean x$206 = c.copy$default$7();
                    boolean x$207 = c.copy$default$8();
                    boolean x$208 = c.copy$default$9();
                    boolean x$209 = c.copy$default$10();
                    Option<Object> x$210 = c.copy$default$11();
                    boolean x$211 = c.copy$default$12();
                    String x$212 = c.copy$default$14();
                    Option<AbsoluteFile> x$213 = c.copy$default$15();
                    CommonOptions x$214 = c.copy$default$16();
                    Function1<AbsoluteFile, GitOps> x$215 = c.copy$default$17();
                    boolean x$216 = c.copy$default$18();
                    return c.copy(x$200, x$201, x$202, x$203, x$204, x$205, x$206, x$207, x$208, x$209, x$210, x$211, (Option<String>)x$199, x$212, x$213, x$214, x$215, x$216);
                }).text("If set, only format edited files in git diff against provided branch.");
                this.opt("build-info", Read$.MODULE$.unitRead()).action((Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                    Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                    if (tuple2 != null) {
                        Predef$.MODULE$.println((Object)CliArgParser$.MODULE$.buildInfo());
                        throw scala.sys.package$.MODULE$.exit();
                    }
                    throw new MatchError((Object)tuple2);
                }).text("prints build information");
                this.opt("quiet", Read$.MODULE$.unitRead()).action((Function2 & Serializable & scala.Serializable)(x$5, c) -> {
                    boolean x$217 = true;
                    Option<Path> x$218 = c.copy$default$1();
                    Option<String> x$219 = c.copy$default$2();
                    Set<Range> x$220 = c.copy$default$3();
                    Seq<AbsoluteFile> x$221 = c.copy$default$4();
                    Seq<String> x$222 = c.copy$default$5();
                    WriteMode x$223 = c.copy$default$6();
                    boolean x$224 = c.copy$default$7();
                    boolean x$225 = c.copy$default$8();
                    boolean x$226 = c.copy$default$10();
                    Option<Object> x$227 = c.copy$default$11();
                    boolean x$228 = c.copy$default$12();
                    Option<String> x$229 = c.copy$default$13();
                    String x$230 = c.copy$default$14();
                    Option<AbsoluteFile> x$231 = c.copy$default$15();
                    CommonOptions x$232 = c.copy$default$16();
                    Function1<AbsoluteFile, GitOps> x$233 = c.copy$default$17();
                    boolean x$234 = c.copy$default$18();
                    return c.copy(x$218, x$219, x$220, x$221, x$222, x$223, x$224, x$225, x$217, x$226, x$227, x$228, x$229, x$230, x$231, x$232, x$233, x$234);
                }).text("don't print out stuff to console.");
                this.opt("debug", Read$.MODULE$.unitRead()).action((Function2 & Serializable & scala.Serializable)(x$6, c) -> {
                    boolean x$235 = true;
                    Option<Path> x$236 = c.copy$default$1();
                    Option<String> x$237 = c.copy$default$2();
                    Set<Range> x$238 = c.copy$default$3();
                    Seq<AbsoluteFile> x$239 = c.copy$default$4();
                    Seq<String> x$240 = c.copy$default$5();
                    WriteMode x$241 = c.copy$default$6();
                    boolean x$242 = c.copy$default$7();
                    boolean x$243 = c.copy$default$8();
                    boolean x$244 = c.copy$default$9();
                    Option<Object> x$245 = c.copy$default$11();
                    boolean x$246 = c.copy$default$12();
                    Option<String> x$247 = c.copy$default$13();
                    String x$248 = c.copy$default$14();
                    Option<AbsoluteFile> x$249 = c.copy$default$15();
                    CommonOptions x$250 = c.copy$default$16();
                    Function1<AbsoluteFile, GitOps> x$251 = c.copy$default$17();
                    boolean x$252 = c.copy$default$18();
                    return c.copy(x$236, x$237, x$238, x$239, x$240, x$241, x$242, x$243, x$244, x$235, x$245, x$246, x$247, x$248, x$249, x$250, x$251, x$252);
                }).text("print out diagnostics to console.");
                this.opt("non-interactive", Read$.MODULE$.unitRead()).action((Function2 & Serializable & scala.Serializable)(x$7, c) -> {
                    boolean x$253 = true;
                    Option<Path> x$254 = c.copy$default$1();
                    Option<String> x$255 = c.copy$default$2();
                    Set<Range> x$256 = c.copy$default$3();
                    Seq<AbsoluteFile> x$257 = c.copy$default$4();
                    Seq<String> x$258 = c.copy$default$5();
                    WriteMode x$259 = c.copy$default$6();
                    boolean x$260 = c.copy$default$7();
                    boolean x$261 = c.copy$default$8();
                    boolean x$262 = c.copy$default$9();
                    boolean x$263 = c.copy$default$10();
                    Option<Object> x$264 = c.copy$default$11();
                    Option<String> x$265 = c.copy$default$13();
                    String x$266 = c.copy$default$14();
                    Option<AbsoluteFile> x$267 = c.copy$default$15();
                    CommonOptions x$268 = c.copy$default$16();
                    Function1<AbsoluteFile, GitOps> x$269 = c.copy$default$17();
                    boolean x$270 = c.copy$default$18();
                    return c.copy(x$254, x$255, x$256, x$257, x$258, x$259, x$260, x$261, x$262, x$263, x$264, x$253, x$265, x$266, x$267, x$268, x$269, x$270);
                }).text("disable fancy progress bar, useful in ci or sbt plugin.");
                this.opt("range", Read$.MODULE$.tupleRead(Read$.MODULE$.intRead(), Read$.MODULE$.intRead())).hidden().action((Function2 & Serializable & scala.Serializable)(x0$2, x1$2) -> {
                    int to;
                    CliOptions c;
                    Tuple2 tuple2;
                    block3: {
                        Tuple2 tuple22;
                        block2: {
                            tuple22 = new Tuple2(x0$2, x1$2);
                            if (tuple22 == null) break block2;
                            tuple2 = (Tuple2)tuple22._1();
                            c = (CliOptions)tuple22._2();
                            if (tuple2 != null) break block3;
                        }
                        throw new MatchError((Object)tuple22);
                    }
                    int from = tuple2._1$mcI$sp();
                    int offset = from == (to = tuple2._2$mcI$sp()) ? 0 : -1;
                    Set x$271 = (Set)c.range().$plus((Object)package$.MODULE$.Range().apply(from - 1, to + offset));
                    Option<Path> x$272 = c.copy$default$1();
                    Option<String> x$273 = c.copy$default$2();
                    Seq<AbsoluteFile> x$274 = c.copy$default$4();
                    Seq<String> x$275 = c.copy$default$5();
                    WriteMode x$276 = c.copy$default$6();
                    boolean x$277 = c.copy$default$7();
                    boolean x$278 = c.copy$default$8();
                    boolean x$279 = c.copy$default$9();
                    boolean x$280 = c.copy$default$10();
                    Option<Object> x$281 = c.copy$default$11();
                    boolean x$282 = c.copy$default$12();
                    Option<String> x$283 = c.copy$default$13();
                    String x$284 = c.copy$default$14();
                    Option<AbsoluteFile> x$285 = c.copy$default$15();
                    CommonOptions x$286 = c.copy$default$16();
                    Function1<AbsoluteFile, GitOps> x$287 = c.copy$default$17();
                    boolean x$288 = c.copy$default$18();
                    CliOptions cliOptions = c.copy(x$272, x$273, (Set<Range>)x$271, x$274, x$275, x$276, x$277, x$278, x$279, x$280, x$281, x$282, x$283, x$284, x$285, x$286, x$287, x$288);
                    return cliOptions;
                }).text("(experimental) only format line range from=to");
                this.note(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(115).append("|Examples:\n               |").append(CliArgParser$.MODULE$.usageExamples()).append("\n               |Please file bugs to https://github.com/scalameta/scalafmt/issues\n      ").toString())).stripMargin());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$new$1(org.scalafmt.cli.CliArgParser$$anon$1 scala.runtime.BoxedUnit org.scalafmt.cli.CliOptions ), $anonfun$new$2(org.scalafmt.cli.CliArgParser$$anon$1 scala.runtime.BoxedUnit org.scalafmt.cli.CliOptions ), $anonfun$new$3(org.scalafmt.cli.CliArgParser$$anon$1 java.io.File org.scalafmt.cli.CliOptions ), $anonfun$new$4(scala.collection.Seq org.scalafmt.cli.CliOptions ), $anonfun$new$5(scala.runtime.BoxedUnit org.scalafmt.cli.CliOptions ), $anonfun$new$6(scala.runtime.BoxedUnit org.scalafmt.cli.CliOptions ), $anonfun$new$7$adapted(java.lang.Object org.scalafmt.cli.CliOptions ), $anonfun$new$8(scala.collection.Seq org.scalafmt.cli.CliOptions ), $anonfun$new$9(org.scalafmt.cli.CliArgParser$$anon$1 java.lang.String org.scalafmt.cli.CliOptions ), $anonfun$new$10(org.scalafmt.cli.CliArgParser$$anon$1 java.lang.String org.scalafmt.cli.CliOptions ), $anonfun$new$11(scala.runtime.BoxedUnit org.scalafmt.cli.CliOptions ), $anonfun$new$12(scala.runtime.BoxedUnit org.scalafmt.cli.CliOptions ), $anonfun$new$13(java.lang.String org.scalafmt.cli.CliOptions ), $anonfun$new$14(scala.runtime.BoxedUnit org.scalafmt.cli.CliOptions ), $anonfun$new$15(java.io.File org.scalafmt.cli.CliOptions ), $anonfun$new$16(scala.runtime.BoxedUnit org.scalafmt.cli.CliOptions ), $anonfun$new$17(java.lang.String org.scalafmt.cli.CliOptions ), $anonfun$new$18(scala.runtime.BoxedUnit org.scalafmt.cli.CliOptions ), $anonfun$new$19(scala.runtime.BoxedUnit org.scalafmt.cli.CliOptions ), $anonfun$new$20(scala.runtime.BoxedUnit org.scalafmt.cli.CliOptions ), $anonfun$new$21(scala.runtime.BoxedUnit org.scalafmt.cli.CliOptions ), $anonfun$new$22(scala.Tuple2 org.scalafmt.cli.CliOptions )}, serializedLambda);
            }
        };
    }
}

