/*
 * Decompiled with CFR 0.152.
 */
package org.scalafmt.cli;

import java.io.PrintWriter;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import org.scalafmt.Error;
import org.scalafmt.cli.CliOptions;
import org.scalafmt.cli.ExitCode;
import org.scalafmt.cli.ExitCode$;
import org.scalafmt.cli.FailedToFormat;
import org.scalafmt.dynamic.exceptions.ScalafmtException;
import org.scalafmt.interfaces.PositionException;
import org.scalafmt.interfaces.ScalafmtReporter;
import scala.MatchError;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001e4Aa\u0003\u0007\u0001'!A!\u0005\u0001B\u0001B\u0003%1\u0005C\u0003(\u0001\u0011\u0005\u0001\u0006C\u0004,\u0001\t\u0007I\u0011\u0002\u0017\t\ri\u0002\u0001\u0015!\u0003.\u0011\u0015Y\u0004\u0001\"\u0001=\u0011\u0015i\u0004\u0001\"\u0011?\u0011\u0015i\u0004\u0001\"\u0011\\\u0011\u0015A\u0007\u0001\"\u0011j\u0011\u0015Y\u0007\u0001\"\u0011m\u0011\u0015\t\b\u0001\"\u0011s\u0005M\u00196-\u00197bM6$8\t\\5SKB|'\u000f^3s\u0015\tia\"A\u0002dY&T!a\u0004\t\u0002\u0011M\u001c\u0017\r\\1g[RT\u0011!E\u0001\u0004_J<7\u0001A\n\u0004\u0001Qa\u0002CA\u000b\u001b\u001b\u00051\"BA\f\u0019\u0003\u0011a\u0017M\\4\u000b\u0003e\tAA[1wC&\u00111D\u0006\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005u\u0001S\"\u0001\u0010\u000b\u0005}q\u0011AC5oi\u0016\u0014h-Y2fg&\u0011\u0011E\b\u0002\u0011'\u000e\fG.\u00194niJ+\u0007o\u001c:uKJ\fqa\u001c9uS>t7\u000f\u0005\u0002%K5\tA\"\u0003\u0002'\u0019\tQ1\t\\5PaRLwN\\:\u0002\rqJg.\u001b;?)\tI#\u0006\u0005\u0002%\u0001!)!E\u0001a\u0001G\u0005AQ\r_5u\u0007>$W-F\u0001.!\rqSgN\u0007\u0002_)\u0011\u0001'M\u0001\u0007CR|W.[2\u000b\u0005I\u001a\u0014AC2p]\u000e,(O]3oi*\u0011A\u0007G\u0001\u0005kRLG.\u0003\u00027_\ty\u0011\t^8nS\u000e\u0014VMZ3sK:\u001cW\r\u0005\u0002%q%\u0011\u0011\b\u0004\u0002\t\u000bbLGoQ8eK\u0006IQ\r_5u\u0007>$W\rI\u0001\fO\u0016$X\t_5u\u0007>$W-F\u00018\u0003\u0015)'O]8s)\ryTI\u0014\t\u0003\u0001\u000ek\u0011!\u0011\u0006\u0002\u0005\u0006)1oY1mC&\u0011A)\u0011\u0002\u0005+:LG\u000fC\u0003G\r\u0001\u0007q)\u0001\u0003gS2,\u0007C\u0001%M\u001b\u0005I%B\u0001$K\u0015\tY\u0005$A\u0002oS>L!!T%\u0003\tA\u000bG\u000f\u001b\u0005\u0006\u001f\u001a\u0001\r\u0001U\u0001\b[\u0016\u001c8/Y4f!\t\t\u0006L\u0004\u0002S-B\u00111+Q\u0007\u0002)*\u0011QKE\u0001\u0007yI|w\u000e\u001e \n\u0005]\u000b\u0015A\u0002)sK\u0012,g-\u0003\u0002Z5\n11\u000b\u001e:j]\u001eT!aV!\u0015\u0007}bV\fC\u0003G\u000f\u0001\u0007q\tC\u0003_\u000f\u0001\u0007q,A\u0001f!\t\u0001WM\u0004\u0002bG:\u00111KY\u0005\u0002\u0005&\u0011A-Q\u0001\ba\u0006\u001c7.Y4f\u0013\t1wMA\u0005UQJ|w/\u00192mK*\u0011A-Q\u0001\tKb\u001cG.\u001e3fIR\u0011qH\u001b\u0005\u0006\r\"\u0001\raR\u0001\ra\u0006\u00148/\u001a3D_:4\u0017n\u001a\u000b\u0004\u007f5|\u0007\"\u00028\n\u0001\u00049\u0015AB2p]\u001aLw\rC\u0003q\u0013\u0001\u0007\u0001+A\btG\u0006d\u0017MZ7u-\u0016\u00148/[8o\u00039!wn\u001e8m_\u0006$wK]5uKJ$\u0012a\u001d\t\u0003i^l\u0011!\u001e\u0006\u0003mb\t!![8\n\u0005a,(a\u0003)sS:$xK]5uKJ\u0004")
public class ScalafmtCliReporter
implements ScalafmtReporter {
    private final CliOptions options;
    private final AtomicReference<ExitCode> exitCode;

    public void error(Path x$1, String x$2, Throwable x$3) {
        super.error(x$1, x$2, x$3);
    }

    public void missingVersion(Path x$1, String x$2) {
        super.missingVersion(x$1, x$2);
    }

    private AtomicReference<ExitCode> exitCode() {
        return this.exitCode;
    }

    public ExitCode getExitCode() {
        return this.exitCode().get();
    }

    public void error(Path file, String message) {
        block1: {
            if (this.options.ignoreWarnings()) break block1;
            if (!this.options.quiet()) {
                this.options.common().err().println(new StringBuilder(2).append(message).append(": ").append(file).toString());
            }
            this.exitCode().getAndUpdate(new UnaryOperator<ExitCode>(null){

                public ExitCode apply(ExitCode t) {
                    return ExitCode$.MODULE$.merge(ExitCode$.MODULE$.UnexpectedError(), t);
                }
            });
        }
    }

    public void error(Path file, Throwable e) {
        Throwable throwable = e;
        if (throwable instanceof PositionException && !this.options.ignoreWarnings()) {
            if (!this.options.quiet()) {
                this.options.common().err().println(new StringBuilder(2).append(e.toString()).append(": ").append(file).toString());
            }
            this.exitCode().getAndUpdate(new UnaryOperator<ExitCode>(null){

                public ExitCode apply(ExitCode t) {
                    return ExitCode$.MODULE$.merge(ExitCode$.MODULE$.ParseError(), t);
                }
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (throwable instanceof Error.MisformattedFile) {
            Error.MisformattedFile misformattedFile = (Error.MisformattedFile)throwable;
            String diff = misformattedFile.customMessage();
            this.options.common().err().println(diff);
            this.exitCode().getAndUpdate(new UnaryOperator<ExitCode>(null){

                public ExitCode apply(ExitCode t) {
                    return ExitCode$.MODULE$.merge(ExitCode$.MODULE$.TestError(), t);
                }
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (throwable instanceof ScalafmtException) {
            ScalafmtException scalafmtException = (ScalafmtException)throwable;
            Throwable cause = scalafmtException.cause();
            this.error(file, cause);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (!this.options.ignoreWarnings()) {
            if (!this.options.quiet()) {
                new FailedToFormat(((Object)file).toString(), e).printStackTrace(this.options.common().err());
            }
            this.exitCode().getAndUpdate(new UnaryOperator<ExitCode>(null){

                public ExitCode apply(ExitCode t) {
                    return ExitCode$.MODULE$.merge(ExitCode$.MODULE$.UnexpectedError(), t);
                }
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)throwable);
        }
    }

    public void excluded(Path file) {
        block0: {
            if (!this.options.debug()) break block0;
            this.options.common().out().println(new StringBuilder(15).append("file excluded: ").append(file).toString());
        }
    }

    public void parsedConfig(Path config, String scalafmtVersion) {
        block0: {
            if (!this.options.debug()) break block0;
            this.options.common().out().println(new StringBuilder(19).append("parsed config (v").append(scalafmtVersion).append("): ").append(config).toString());
        }
    }

    public PrintWriter downloadWriter() {
        return new PrintWriter(this.options.common().out());
    }

    public ScalafmtCliReporter(CliOptions options) {
        this.options = options;
        this.exitCode = new AtomicReference<ExitCode>(ExitCode$.MODULE$.Ok());
    }
}

