/*
 * Decompiled with CFR 0.152.
 */
package org.scalafmt.cli;

import java.io.Serializable;
import java.nio.file.Paths;
import java.util.concurrent.atomic.AtomicInteger;
import org.scalafmt.Error;
import org.scalafmt.cli.CliOptions;
import org.scalafmt.cli.ExitCode;
import org.scalafmt.cli.InputMethod;
import org.scalafmt.cli.ScalafmtCliReporter;
import org.scalafmt.cli.ScalafmtRunner;
import org.scalafmt.cli.TermDisplay;
import org.scalafmt.config.FilterMatcher;
import org.scalafmt.interfaces.Scalafmt;
import org.scalafmt.interfaces.ScalafmtReporter;
import org.scalafmt.util.AbsoluteFile;
import org.scalafmt.util.AbsoluteFile$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.collection.Seq;
import scala.meta.internal.tokenizers.PlatformTokenizerCache$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ScalafmtDynamicRunner$
implements ScalafmtRunner {
    public static ScalafmtDynamicRunner$ MODULE$;

    static {
        new ScalafmtDynamicRunner$();
    }

    @Override
    public TermDisplay newTermDisplay(CliOptions options, Seq<InputMethod> inputMethods, String msg) {
        return ScalafmtRunner.newTermDisplay$(this, options, inputMethods, msg);
    }

    @Override
    public Seq<InputMethod> getInputMethods(CliOptions options, Option<FilterMatcher> filter) {
        return ScalafmtRunner.getInputMethods$(this, options, filter);
    }

    @Override
    public ExitCode run(CliOptions options, String termDisplayMessage) {
        Seq<InputMethod> inputMethods = this.getInputMethods(options, (Option<FilterMatcher>)None$.MODULE$);
        if (inputMethods.isEmpty() && options.diff().isEmpty() && !options.stdIn()) {
            throw Error.NoMatchingFiles$.MODULE$;
        }
        AtomicInteger counter = new AtomicInteger();
        ScalafmtCliReporter reporter = new ScalafmtCliReporter(options);
        Scalafmt scalafmtInstance = Scalafmt.create((ClassLoader)this.getClass().getClassLoader()).withReporter((ScalafmtReporter)reporter);
        Seq fqpns = (Seq)inputMethods.filter((Function1 & Serializable & scala.Serializable)input -> BoxesRunTime.boxToBoolean((boolean)ScalafmtDynamicRunner$.$anonfun$run$1(options, input)));
        Scalafmt scalafmtInstanceIgnoreFilters = fqpns.isEmpty() ? scalafmtInstance : Scalafmt.create((ClassLoader)this.getClass().getClassLoader()).withReporter((ScalafmtReporter)reporter).withRespectProjectFilters(false);
        TermDisplay termDisplay = this.newTermDisplay(options, inputMethods, termDisplayMessage);
        inputMethods.foreach((Function1 & Serializable & scala.Serializable)inputMethod -> {
            ScalafmtDynamicRunner$.$anonfun$run$3(fqpns, scalafmtInstanceIgnoreFilters, scalafmtInstance, options, reporter, termDisplay, termDisplayMessage, counter, inputMethod);
            return BoxedUnit.UNIT;
        });
        ExitCode exit = reporter.getExitCode();
        termDisplay.completedTask(termDisplayMessage, exit.isOk());
        termDisplay.stop();
        return exit;
    }

    private void handleFile(InputMethod inputMethod, Scalafmt scalafmtInstance, CliOptions options) {
        String input = inputMethod.readInput(options);
        boolean shouldRespectFilters = AbsoluteFile$.MODULE$.fromPath(inputMethod.filename()).forall((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)ScalafmtDynamicRunner$.$anonfun$handleFile$1(options, file)));
        String formatResult = scalafmtInstance.withRespectProjectFilters(shouldRespectFilters).format(options.configPath(), Paths.get(inputMethod.filename(), new String[0]), input);
        inputMethod.write(formatResult, input, options);
    }

    public static final /* synthetic */ boolean $anonfun$run$2(CliOptions options$1, AbsoluteFile file) {
        return options$1.customFiles().contains((Object)file);
    }

    public static final /* synthetic */ boolean $anonfun$run$1(CliOptions options$1, InputMethod input) {
        return AbsoluteFile$.MODULE$.fromPath(input.filename()).forall((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)ScalafmtDynamicRunner$.$anonfun$run$2(options$1, file)));
    }

    public static final /* synthetic */ void $anonfun$run$3(Seq fqpns$1, Scalafmt scalafmtInstanceIgnoreFilters$1, Scalafmt scalafmtInstance$1, CliOptions options$1, ScalafmtCliReporter reporter$1, TermDisplay termDisplay$1, String termDisplayMessage$1, AtomicInteger counter$1, InputMethod inputMethod) {
        Scalafmt instance = fqpns$1.contains((Object)inputMethod) ? scalafmtInstanceIgnoreFilters$1 : scalafmtInstance$1;
        try {
            MODULE$.handleFile(inputMethod, instance, options$1);
        }
        catch (Error.MisformattedFile e) {
            reporter$1.error(e.file().toPath(), e);
        }
        PlatformTokenizerCache$.MODULE$.megaCache().clear();
        termDisplay$1.taskProgress(termDisplayMessage$1, counter$1.incrementAndGet());
    }

    public static final /* synthetic */ boolean $anonfun$handleFile$1(CliOptions options$2, AbsoluteFile file) {
        return !options$2.customFiles().contains((Object)file);
    }

    private ScalafmtDynamicRunner$() {
        MODULE$ = this;
        ScalafmtRunner.$init$(this);
    }
}

