/*
 * Decompiled with CFR 0.152.
 */
package org.seedstack.seed.undertow.internal;

import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.InstanceFactory;
import io.undertow.servlet.api.InstanceHandle;
import io.undertow.servlet.api.ServletContainerInitializerInfo;
import io.undertow.servlet.util.ImmediateInstanceHandle;
import java.util.HashSet;
import java.util.ServiceLoader;
import java.util.Set;
import javax.servlet.ServletContainerInitializer;
import org.seedstack.coffig.Coffig;
import org.seedstack.seed.undertow.internal.UndertowLauncher;
import org.seedstack.seed.web.WebConfig;

class DeploymentManagerFactory {
    DeploymentManagerFactory() {
    }

    DeploymentManager createDeploymentManager(Coffig baseConfiguration) {
        WebConfig.ServerConfig serverConfig = (WebConfig.ServerConfig)baseConfiguration.get(WebConfig.ServerConfig.class, new String[0]);
        DeploymentInfo servletBuilder = this.configureDeploymentInfo(serverConfig.getContextPath());
        return Servlets.defaultContainer().addDeployment(servletBuilder);
    }

    private DeploymentInfo configureDeploymentInfo(String contextPath) {
        DeploymentInfo deploymentInfo = Servlets.deployment().setClassLoader(UndertowLauncher.class.getClassLoader()).setDeploymentName("app.war").setContextPath(contextPath);
        for (ServletContainerInitializer servletContainerInitializer : this.loadServletContainerInitializers()) {
            deploymentInfo.addServletContainerInitalizer(this.createServletContainerInitializerInfo(servletContainerInitializer));
        }
        return deploymentInfo;
    }

    private <T extends ServletContainerInitializer> ServletContainerInitializerInfo createServletContainerInitializerInfo(final T servletContainerInitializer) {
        return new ServletContainerInitializerInfo(servletContainerInitializer.getClass(), new InstanceFactory<T>(){

            public InstanceHandle<T> createInstance() throws InstantiationException {
                return new ImmediateInstanceHandle((Object)servletContainerInitializer);
            }
        }, null);
    }

    private Set<ServletContainerInitializer> loadServletContainerInitializers() {
        HashSet<ServletContainerInitializer> servletContainerInitializers = new HashSet<ServletContainerInitializer>();
        for (ServletContainerInitializer servletContainerInitializer : ServiceLoader.load(ServletContainerInitializer.class)) {
            servletContainerInitializers.add(servletContainerInitializer);
        }
        return servletContainerInitializers;
    }
}

