/*
 * Decompiled with CFR 0.152.
 */
package org.seedstack.seed.undertow.internal;

import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.UndertowOptions;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.servlet.api.DeploymentManager;
import java.util.Optional;
import javax.net.ssl.SSLContext;
import javax.servlet.ServletException;
import org.seedstack.seed.SeedException;
import org.seedstack.seed.crypto.CryptoConfig;
import org.seedstack.seed.crypto.spi.SSLProvider;
import org.seedstack.seed.undertow.UndertowConfig;
import org.seedstack.seed.undertow.internal.UndertowErrorCode;
import org.seedstack.seed.web.WebConfig;
import org.seedstack.shed.exception.ErrorCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.Options;
import org.xnio.SslClientAuthMode;

class ServerFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerFactory.class);

    ServerFactory() {
    }

    Undertow createServer(DeploymentManager manager, WebConfig.ServerConfig serverConfig, UndertowConfig undertowConfig, SSLProvider sslProvider) {
        Undertow.Builder builder;
        PathHandler path = null;
        try {
            path = Handlers.path((HttpHandler)Handlers.redirect((String)serverConfig.getContextPath())).addPrefixPath(serverConfig.getContextPath(), manager.start());
        }
        catch (ServletException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        if (serverConfig.isHttps()) {
            builder = this.createHttpsBuilder(serverConfig, sslProvider);
        } else {
            builder = this.createHttpBuilder(serverConfig);
            builder.setServerOption(UndertowOptions.ENABLE_HTTP2, (Object)serverConfig.isHttp2());
        }
        return this.configureUndertow(builder, undertowConfig).setHandler((HttpHandler)path).build();
    }

    private Undertow.Builder configureUndertow(Undertow.Builder builder, UndertowConfig undertowConfig) {
        undertowConfig.getBufferSize().ifPresent(arg_0 -> ((Undertow.Builder)builder).setBufferSize(arg_0));
        undertowConfig.getBuffersPerRegion().ifPresent(arg_0 -> ((Undertow.Builder)builder).setBuffersPerRegion(arg_0));
        undertowConfig.getIoThreads().ifPresent(arg_0 -> ((Undertow.Builder)builder).setIoThreads(arg_0));
        undertowConfig.getWorkerThreads().ifPresent(arg_0 -> ((Undertow.Builder)builder).setWorkerThreads(arg_0));
        undertowConfig.getDirectBuffers().ifPresent(arg_0 -> ((Undertow.Builder)builder).setDirectBuffers(arg_0));
        return builder;
    }

    private Undertow.Builder createHttpBuilder(WebConfig.ServerConfig serverConfig) {
        return Undertow.builder().addHttpListener(serverConfig.getPort(), serverConfig.getHost());
    }

    private Undertow.Builder createHttpsBuilder(WebConfig.ServerConfig serverConfig, SSLProvider sslProvider) {
        Optional sslContext = sslProvider.sslContext();
        CryptoConfig.SSLConfig sslConfig = sslProvider.sslConfig();
        if (sslContext.isPresent()) {
            return Undertow.builder().addHttpsListener(serverConfig.getPort(), serverConfig.getHost(), (SSLContext)sslContext.get()).setSocketOption(Options.SSL_CLIENT_AUTH_MODE, (Object)SslClientAuthMode.valueOf((String)sslConfig.getClientAuthMode().toString()));
        }
        throw SeedException.createNew((ErrorCode)UndertowErrorCode.MISSING_SSL_CONTEXT).put("ksName", (Object)sslConfig.getKeyStore()).put("tsName", (Object)sslConfig.getTrustStore()).put("alias", (Object)sslConfig.getAlias());
    }
}

