/*
 * Decompiled with CFR 0.152.
 */
package org.seedstack.seed.undertow.internal;

import io.nuun.kernel.api.Kernel;
import io.nuun.kernel.api.Plugin;
import io.undertow.Undertow;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.spec.ServletContextImpl;
import javax.servlet.ServletContext;
import org.seedstack.coffig.Coffig;
import org.seedstack.seed.SeedException;
import org.seedstack.seed.core.Seed;
import org.seedstack.seed.spi.SeedLauncher;
import org.seedstack.seed.undertow.internal.DeploymentManagerFactory;
import org.seedstack.seed.undertow.internal.ServerFactory;
import org.seedstack.seed.undertow.internal.UndertowErrorCode;
import org.seedstack.seed.undertow.internal.UndertowPlugin;
import org.seedstack.seed.web.WebConfig;
import org.seedstack.seed.web.internal.ServletContextUtils;
import org.seedstack.shed.exception.ErrorCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UndertowLauncher
implements SeedLauncher {
    private static final Logger LOGGER = LoggerFactory.getLogger(UndertowLauncher.class);
    private DeploymentManager deploymentManager;
    private Undertow undertow;

    public void launch(String[] args) throws Exception {
        Coffig baseConfiguration = Seed.baseConfiguration();
        DeploymentManagerFactory factory = new DeploymentManagerFactory();
        this.deploymentManager = factory.createDeploymentManager(baseConfiguration);
        this.deploymentManager.deploy();
        ServletContextImpl servletContext = this.deploymentManager.getDeployment().getServletContext();
        Kernel kernel = ServletContextUtils.getKernel((ServletContext)servletContext);
        UndertowPlugin undertowPlugin = this.getUndertowPlugin(kernel);
        WebConfig.ServerConfig serverConfig = undertowPlugin.getServerConfig();
        try {
            this.undertow = new ServerFactory().createServer(this.deploymentManager, serverConfig, undertowPlugin.getUndertowConfig(), undertowPlugin.getSslProvider());
            this.undertow.start();
            LOGGER.info("Undertow Web server listening on {}:{}", (Object)serverConfig.getHost(), (Object)serverConfig.getPort());
        }
        catch (SeedException e) {
            throw e;
        }
        catch (Exception e) {
            throw SeedException.wrap((Throwable)e, (ErrorCode)UndertowErrorCode.UNEXPECTED_EXCEPTION);
        }
    }

    private UndertowPlugin getUndertowPlugin(Kernel kernel) {
        UndertowPlugin undertowPlugin = null;
        Plugin plugin = (Plugin)kernel.plugins().get("undertow");
        if (plugin instanceof UndertowPlugin) {
            undertowPlugin = (UndertowPlugin)plugin;
        }
        if (undertowPlugin == null) {
            throw SeedException.createNew((ErrorCode)UndertowErrorCode.MISSING_UNDERTOW_PLUGIN);
        }
        return undertowPlugin;
    }

    public void shutdown() throws Exception {
        try {
            if (this.undertow != null) {
                this.undertow.stop();
                LOGGER.info("Undertow Web server stopped");
            }
            if (this.deploymentManager != null) {
                this.deploymentManager.undeploy();
            }
        }
        catch (Exception e) {
            throw SeedException.wrap((Throwable)e, (ErrorCode)UndertowErrorCode.UNEXPECTED_EXCEPTION);
        }
    }
}

