/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.sessionmap.local;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.openqa.selenium.NoSuchSessionException;
import org.openqa.selenium.events.EventBus;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.data.NodeRemovedEvent;
import org.openqa.selenium.grid.data.NodeRestartedEvent;
import org.openqa.selenium.grid.data.Session;
import org.openqa.selenium.grid.data.SessionClosedEvent;
import org.openqa.selenium.grid.log.LoggingOptions;
import org.openqa.selenium.grid.server.EventBusOptions;
import org.openqa.selenium.grid.sessionmap.SessionMap;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.RemoteTags;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.tracing.AttributeKey;
import org.openqa.selenium.remote.tracing.AttributeMap;
import org.openqa.selenium.remote.tracing.Span;
import org.openqa.selenium.remote.tracing.Tracer;

public class LocalSessionMap
extends SessionMap {
    private static final Logger LOG = Logger.getLogger(LocalSessionMap.class.getName());
    private final EventBus bus;
    private final ConcurrentMap<SessionId, Session> knownSessions = new ConcurrentHashMap<SessionId, Session>();

    public LocalSessionMap(Tracer tracer, EventBus bus) {
        super(tracer);
        this.bus = (EventBus)Require.nonNull((String)"Event bus", (Object)bus);
        bus.addListener(SessionClosedEvent.listener(this::remove));
        bus.addListener(NodeRemovedEvent.listener(nodeStatus -> nodeStatus.getSlots().stream().filter(slot -> slot.getSession() != null).map(slot -> slot.getSession().getId()).forEach(this::remove)));
        bus.addListener(NodeRestartedEvent.listener(nodeStatus -> {
            List<SessionId> toRemove = this.knownSessions.entrySet().stream().filter(e -> ((Session)e.getValue()).getUri().equals(nodeStatus.getExternalUri())).map(Map.Entry::getKey).collect(Collectors.toList());
            toRemove.forEach(this::remove);
        }));
    }

    public static SessionMap create(Config config) {
        Tracer tracer = new LoggingOptions(config).getTracer();
        EventBus bus = new EventBusOptions(config).getEventBus();
        return new LocalSessionMap(tracer, bus);
    }

    @Override
    public boolean isReady() {
        return this.bus.isReady();
    }

    @Override
    public boolean add(Session session) {
        Require.nonNull((String)"Session", (Object)session);
        try (Span span = this.tracer.getCurrentContext().createSpan("local_sessionmap.add");){
            AttributeMap attributeMap = this.tracer.createAttributeMap();
            attributeMap.put(AttributeKey.LOGGER_CLASS.getKey(), this.getClass().getName());
            SessionId id = session.getId();
            RemoteTags.SESSION_ID.accept(span, id);
            RemoteTags.SESSION_ID_EVENT.accept(attributeMap, id);
            this.knownSessions.put(session.getId(), session);
            span.addEvent("Added session into local session map", attributeMap);
            boolean bl = true;
            return bl;
        }
    }

    @Override
    public Session get(SessionId id) {
        Require.nonNull((String)"Session ID", (Object)id);
        Session session = (Session)this.knownSessions.get(id);
        if (session == null) {
            throw new NoSuchSessionException("Unable to find session with ID: " + String.valueOf(id));
        }
        return session;
    }

    @Override
    public void remove(SessionId id) {
        Require.nonNull((String)"Session ID", (Object)id);
        try (Span span = this.tracer.getCurrentContext().createSpan("local_sessionmap.remove");){
            AttributeMap attributeMap = this.tracer.createAttributeMap();
            attributeMap.put(AttributeKey.LOGGER_CLASS.getKey(), this.getClass().getName());
            RemoteTags.SESSION_ID.accept(span, id);
            RemoteTags.SESSION_ID_EVENT.accept(attributeMap, id);
            this.knownSessions.remove(id);
            String sessionDeletedMessage = "Deleted session from local Session Map";
            span.addEvent(sessionDeletedMessage, attributeMap);
            LOG.info(String.format("%s, Id: %s", sessionDeletedMessage, id));
        }
    }
}

