/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.handler.interactions.touch;

import java.util.Map;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.HasTouchScreen;
import org.openqa.selenium.interactions.TouchScreen;
import org.openqa.selenium.interactions.internal.Coordinates;
import org.openqa.selenium.interactions.internal.Locatable;
import org.openqa.selenium.remote.server.JsonParametersAware;
import org.openqa.selenium.remote.server.Session;
import org.openqa.selenium.remote.server.handler.WebElementHandler;

public class Flick
extends WebElementHandler<Void>
implements JsonParametersAware {
    private static final String ELEMENT = "element";
    private static final String XOFFSET = "xoffset";
    private static final String YOFFSET = "yoffset";
    private static final String SPEED = "speed";
    private static final String XSPEED = "xspeed";
    private static final String YSPEED = "yspeed";
    private String elementId;
    private int xOffset;
    private int yOffset;
    private int speed;
    private int xSpeed;
    private int ySpeed;

    public Flick(Session session) {
        super(session);
    }

    @Override
    public Void call() throws Exception {
        TouchScreen touchScreen = ((HasTouchScreen)this.getDriver()).getTouch();
        if (this.elementId != null) {
            WebElement element = this.getKnownElements().get(this.elementId);
            Coordinates elementLocation = ((Locatable)element).getCoordinates();
            touchScreen.flick(elementLocation, this.xOffset, this.yOffset, this.speed);
        } else {
            touchScreen.flick(this.xSpeed, this.ySpeed);
        }
        return null;
    }

    public String toString() {
        return String.format("[Flick]", new Object[0]);
    }

    @Override
    public void setJsonParameters(Map<String, Object> allParameters) throws Exception {
        if (allParameters.containsKey(ELEMENT) && allParameters.get(ELEMENT) != null) {
            this.elementId = (String)allParameters.get(ELEMENT);
            try {
                this.xOffset = ((Number)allParameters.get(XOFFSET)).intValue();
            }
            catch (ClassCastException ex) {
                throw new WebDriverException("Illegal (non-numeric) x offset value for flick passed: " + allParameters.get(XOFFSET), (Throwable)ex);
            }
            try {
                this.yOffset = ((Number)allParameters.get(YOFFSET)).intValue();
            }
            catch (ClassCastException ex) {
                throw new WebDriverException("Illegal (non-numeric) y offset value for flick passed: " + allParameters.get(YOFFSET), (Throwable)ex);
            }
            try {
                this.speed = ((Number)allParameters.get(SPEED)).intValue();
            }
            catch (ClassCastException ex) {
                throw new WebDriverException("Illegal (non-numeric) speed value for flick passed: " + allParameters.get(SPEED), (Throwable)ex);
            }
        }
        if (allParameters.containsKey(XSPEED) && allParameters.containsKey(YSPEED)) {
            try {
                this.xSpeed = ((Number)allParameters.get(XSPEED)).intValue();
            }
            catch (ClassCastException ex) {
                throw new WebDriverException("Illegal (non-numeric) x speed value for flick passed: " + allParameters.get(XSPEED), (Throwable)ex);
            }
            try {
                this.ySpeed = ((Number)allParameters.get(YSPEED)).intValue();
            }
            catch (ClassCastException ex) {
                throw new WebDriverException("Illegal (non-numeric) y speed value for flick passed: " + allParameters.get(YSPEED), (Throwable)ex);
            }
        }
    }
}

