/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.session.remote;

import com.google.common.base.Preconditions;
import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.grid.session.ActiveSession;
import org.openqa.selenium.grid.session.SessionFactory;
import org.openqa.selenium.grid.session.remote.ActiveSessionCommandExecutor;
import org.openqa.selenium.grid.session.remote.Passthrough;
import org.openqa.selenium.grid.session.remote.ProtocolConverter;
import org.openqa.selenium.grid.session.remote.SessionCodec;
import org.openqa.selenium.io.TemporaryFilesystem;
import org.openqa.selenium.remote.Augmenter;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.CommandCodec;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.Dialect;
import org.openqa.selenium.remote.ProtocolHandshake;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.ResponseCodec;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.http.JsonHttpCommandCodec;
import org.openqa.selenium.remote.http.JsonHttpResponseCodec;
import org.openqa.selenium.remote.http.W3CHttpCommandCodec;
import org.openqa.selenium.remote.http.W3CHttpResponseCodec;

public abstract class RemoteSession
implements ActiveSession {
    protected static Logger log = Logger.getLogger(ActiveSession.class.getName());
    private final SessionId id;
    private final Dialect downstream;
    private final Dialect upstream;
    private final SessionCodec codec;
    private final Map<String, Object> capabilities;
    private final TemporaryFilesystem filesystem;
    private final WebDriver driver;

    protected RemoteSession(Dialect downstream, Dialect upstream, SessionCodec codec, SessionId id, Map<String, Object> capabilities) {
        this.downstream = downstream;
        this.upstream = upstream;
        this.codec = codec;
        this.id = id;
        this.capabilities = capabilities;
        File tempRoot = new File(StandardSystemProperty.JAVA_IO_TMPDIR.value(), id.toString());
        Preconditions.checkState((boolean)tempRoot.mkdirs());
        this.filesystem = TemporaryFilesystem.getTmpFsBasedOn((File)tempRoot);
        ActiveSessionCommandExecutor executor = new ActiveSessionCommandExecutor(this);
        this.driver = new Augmenter().augment((WebDriver)new RemoteWebDriver((CommandExecutor)executor, (Capabilities)new ImmutableCapabilities(this.getCapabilities())));
    }

    @Override
    public SessionId getId() {
        return this.id;
    }

    @Override
    public Dialect getUpstreamDialect() {
        return this.upstream;
    }

    @Override
    public Dialect getDownstreamDialect() {
        return this.downstream;
    }

    @Override
    public Map<String, Object> getCapabilities() {
        return this.capabilities;
    }

    @Override
    public TemporaryFilesystem getFileSystem() {
        return this.filesystem;
    }

    public WebDriver getWrappedDriver() {
        return this.driver;
    }

    @Override
    public void execute(HttpRequest req, HttpResponse resp) throws IOException {
        this.codec.handle(req, resp);
    }

    public static abstract class Factory<X>
    implements SessionFactory {
        protected Optional<ActiveSession> performHandshake(X additionalData, URL url, Set<Dialect> downstreamDialects, Capabilities capabilities) {
            try {
                Dialect downstream;
                SessionCodec codec;
                HttpClient client = HttpClient.Factory.createDefault().createClient(url);
                Command command = new Command(null, "newSession", (Map)ImmutableMap.of((Object)"desiredCapabilities", (Object)capabilities));
                ProtocolHandshake.Result result = new ProtocolHandshake().createSession(client, command);
                Dialect upstream = result.getDialect();
                if (downstreamDialects.contains(result.getDialect())) {
                    codec = new Passthrough(url);
                    downstream = upstream;
                } else {
                    downstream = downstreamDialects.isEmpty() ? Dialect.OSS : downstreamDialects.iterator().next();
                    codec = new ProtocolConverter(url, this.getCommandCodec(downstream), this.getResponseCodec(downstream), this.getCommandCodec(upstream), this.getResponseCodec(upstream));
                }
                Response response = result.createResponse();
                Optional<ActiveSession> activeSession = Optional.of(this.newActiveSession(additionalData, downstream, upstream, codec, new SessionId(response.getSessionId()), (Map)response.getValue()));
                activeSession.ifPresent(session -> log.info("Started new session " + session));
                return activeSession;
            }
            catch (IOException | IllegalStateException | NullPointerException e) {
                log.log(Level.WARNING, e.getMessage(), e);
                return Optional.empty();
            }
        }

        protected abstract ActiveSession newActiveSession(X var1, Dialect var2, Dialect var3, SessionCodec var4, SessionId var5, Map<String, Object> var6);

        private CommandCodec<HttpRequest> getCommandCodec(Dialect dialect) {
            switch (dialect) {
                case OSS: {
                    return new JsonHttpCommandCodec();
                }
                case W3C: {
                    return new W3CHttpCommandCodec();
                }
            }
            throw new IllegalStateException("Unknown dialect: " + dialect);
        }

        private ResponseCodec<HttpResponse> getResponseCodec(Dialect dialect) {
            switch (dialect) {
                case OSS: {
                    return new JsonHttpResponseCodec();
                }
                case W3C: {
                    return new W3CHttpResponseCodec();
                }
            }
            throw new IllegalStateException("Unknown dialect: " + dialect);
        }
    }
}

