/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.manager;

import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.JsonInput;

public class SeleniumManagerOutput {
    private List<Log> logs;
    private Result result;

    public List<Log> getLogs() {
        return this.logs;
    }

    public void setLogs(List<Log> logs) {
        this.logs = logs;
    }

    public Result getResult() {
        return this.result;
    }

    public void setResult(Result result) {
        this.result = result;
    }

    public static class Result {
        private final int code;
        private final String message;
        private final String driverPath;
        private final String browserPath;

        public Result(String driverPath) {
            this(0, null, driverPath, null);
        }

        public Result(int code, String message, String driverPath, String browserPath) {
            this.code = code;
            this.message = message;
            this.driverPath = driverPath;
            this.browserPath = browserPath;
        }

        public int getCode() {
            return this.code;
        }

        public String getMessage() {
            return this.message;
        }

        public String getDriverPath() {
            return this.driverPath;
        }

        public String getBrowserPath() {
            return this.browserPath;
        }

        public String toString() {
            return "Result{code=" + this.code + ", message='" + this.message + "', driverPath='" + this.driverPath + "', browserPath='" + this.browserPath + "'}";
        }

        public boolean equals(Object o) {
            if (!(o instanceof Result)) {
                return false;
            }
            Result that = (Result)o;
            return this.code == that.code && Objects.equals(this.message, that.message) && Objects.equals(this.driverPath, that.driverPath) && Objects.equals(this.browserPath, that.browserPath);
        }

        public int hashCode() {
            return Objects.hash(this.code, this.message, this.driverPath, this.browserPath);
        }

        private static Result fromJson(JsonInput input) {
            int code = 0;
            String message = null;
            String driverPath = null;
            String browserPath = null;
            input.beginObject();
            block12: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "code": {
                        code = (Integer)input.read(Integer.class);
                        continue block12;
                    }
                    case "message": {
                        message = (String)input.read(String.class);
                        continue block12;
                    }
                    case "driver_path": {
                        driverPath = (String)input.read(String.class);
                        continue block12;
                    }
                    case "browser_path": {
                        browserPath = (String)input.read(String.class);
                        continue block12;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new Result(code, message, driverPath, browserPath);
        }
    }

    public static class Log {
        private final Level level;
        private final long timestamp;
        private final String message;

        public Log(Level level, long timestamp, String message) {
            this.level = (Level)Require.nonNull((String)"level", (Object)level);
            this.timestamp = timestamp;
            this.message = (String)Require.nonNull((String)"message", (Object)message);
        }

        public Level getLevel() {
            return this.level;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public String getMessage() {
            return this.message;
        }

        private static Log fromJson(JsonInput input) {
            Level level = Level.FINE;
            long timestamp = System.currentTimeMillis();
            String message = "";
            input.beginObject();
            while (input.hasNext()) {
                block5 : switch (input.nextName()) {
                    case "level": {
                        switch (input.nextString().toLowerCase()) {
                            case "error": 
                            case "warn": {
                                level = Level.WARNING;
                                break block5;
                            }
                            case "info": {
                                level = Level.INFO;
                                break block5;
                            }
                        }
                        level = Level.FINE;
                        break;
                    }
                    case "timestamp": {
                        timestamp = input.nextNumber().longValue();
                        break;
                    }
                    case "message": {
                        message = input.nextString();
                        break;
                    }
                    default: {
                        input.skipValue();
                    }
                }
            }
            input.endObject();
            return new Log(level, timestamp, message);
        }
    }
}

