/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.net;

import java.io.IOException;
import java.net.ConnectException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortProber {
    private static final Random random = new Random();

    private PortProber() {
    }

    public static int findFreePort() {
        for (int i = 0; i < 5; ++i) {
            int seedPort = PortProber.createAcceptablePort();
            int suggestedPort = PortProber.checkPortIsFree(seedPort);
            if (suggestedPort == -1) continue;
            return suggestedPort;
        }
        throw new RuntimeException("Unable to find a free port");
    }

    public static Callable<Integer> freeLocalPort(final int port) {
        return new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                if (PortProber.checkPortIsFree(port) != -1) {
                    return port;
                }
                return null;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int createAcceptablePort() {
        Random random = PortProber.random;
        synchronized (random) {
            int seed = PortProber.random.nextInt();
            int FIRST_PORT = 5001;
            int LAST_PORT = Short.MAX_VALUE;
            int randomInt = Math.abs(PortProber.random.nextInt());
            seed = randomInt % 27767 + 5001;
            return seed;
        }
    }

    private static int checkPortIsFree(int port) {
        ServerSocket socket = null;
        try {
            socket = new ServerSocket(port);
            int localPort = socket.getLocalPort();
            socket.close();
            return localPort;
        }
        catch (IOException e) {
            return -1;
        }
    }

    public static boolean pollPort(int port) {
        return PortProber.pollPort(port, 15, TimeUnit.SECONDS);
    }

    public static boolean pollPort(int port, int timeout, TimeUnit unit) {
        long end = System.currentTimeMillis() + unit.toMillis(timeout);
        while (System.currentTimeMillis() < end) {
            try {
                Socket socket = new Socket("localhost", port);
                socket.close();
                return true;
            }
            catch (ConnectException e) {
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return false;
    }
}

