/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.net;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import org.openqa.selenium.net.INetAddress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkInterface {
    private final String name;
    private final Iterable<INetAddress> inetAddresses;

    public NetworkInterface(java.net.NetworkInterface networkInterface) {
        this(networkInterface.getName(), NetworkInterface.asIterableAddr(networkInterface.getInetAddresses()));
    }

    NetworkInterface(String name, Iterable<INetAddress> inetAddresses) {
        this.name = name;
        this.inetAddresses = inetAddresses;
    }

    public boolean isIp4AddressBindingOnly() {
        return this.getIp6Address() == null;
    }

    public boolean isLoopBack() {
        Iterator<INetAddress> iterator = this.inetAddresses.iterator();
        return iterator.hasNext() && iterator.next().isLoopbackAddress();
    }

    public INetAddress getIp4LoopbackOnly() {
        for (INetAddress inetAddress : this.inetAddresses) {
            if (!inetAddress.isLoopbackAddress() || !inetAddress.isIPv4Address()) continue;
            return inetAddress;
        }
        return null;
    }

    public INetAddress getIp4NonLoopBackOnly() {
        for (INetAddress inetAddress : this.inetAddresses) {
            if (inetAddress.isLoopbackAddress() || !inetAddress.isIPv4Address()) continue;
            return inetAddress;
        }
        return null;
    }

    public INetAddress getIp6Address() {
        for (INetAddress inetAddress : this.inetAddresses) {
            if (!inetAddress.isIPv6Address()) continue;
            return inetAddress;
        }
        return null;
    }

    NetworkInterface(String name, INetAddress ... inetAddresses) {
        this(name, Arrays.asList(inetAddresses));
    }

    public Iterable<INetAddress> getInetAddresses() {
        return this.inetAddresses;
    }

    public String getName() {
        return this.name;
    }

    static Iterable<INetAddress> asIterableAddr(Enumeration<InetAddress> tEnumeration) {
        ArrayList<INetAddress> result = new ArrayList<INetAddress>();
        while (tEnumeration.hasMoreElements()) {
            result.add(new INetAddress(tEnumeration.nextElement()));
        }
        return Collections.unmodifiableList(result);
    }
}

