/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.browserlaunchers.locators;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.FilenameFilter;
import org.openqa.selenium.Platform;
import org.openqa.selenium.browserlaunchers.locators.FirefoxLocator;
import org.openqa.selenium.os.CommandLine;
import org.openqa.selenium.os.WindowsUtils;

public class Firefox3Locator
extends FirefoxLocator {
    private static final String UBUNTU_BASE_DIR = "/usr/lib";
    private static final String[] USUAL_OS_X_LAUNCHER_LOCATIONS = new String[]{"/Applications/Firefox-3.app/Contents/MacOS", "/Applications/Firefox.app/Contents/MacOS"};
    private String[] usualLauncherLocations;

    protected String browserName() {
        return "Firefox 3";
    }

    protected String seleniumBrowserName() {
        return "firefox3";
    }

    protected String[] standardlauncherFilenames() {
        if (this.runningOnWindows()) {
            return new String[]{"firefox.exe"};
        }
        return new String[]{"firefox-bin", "firefox"};
    }

    protected synchronized String[] usualLauncherLocations() {
        if (null == this.usualLauncherLocations) {
            this.usualLauncherLocations = this.runningOnWindows() ? this.firefoxDefaultLocationsOnWindows() : this.usualUnixLauncherLocations();
        }
        return this.usualLauncherLocations;
    }

    protected String[] usualUnixLauncherLocations() {
        String[] ubuntuLocations = this.firefoxDefaultLocationsOnUbuntu();
        if (ubuntuLocations.length == 0) {
            return USUAL_OS_X_LAUNCHER_LOCATIONS;
        }
        String[] ubuntoLocationPaths = new String[ubuntuLocations.length];
        for (int i = 0; i < ubuntuLocations.length; ++i) {
            ubuntoLocationPaths[i] = "/usr/lib/" + ubuntuLocations[i];
        }
        return ubuntoLocationPaths;
    }

    protected String[] firefoxDefaultLocationsOnUbuntu() {
        File dir = new File(UBUNTU_BASE_DIR);
        if (!dir.exists() && dir.isDirectory()) {
            return new String[0];
        }
        return dir.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.startsWith("firefox-");
            }
        });
    }

    protected String[] firefoxDefaultLocationsOnWindows() {
        return (String[])new ImmutableList.Builder().addAll(WindowsUtils.getPathsInProgramFiles("\\Firefox-3")).addAll(WindowsUtils.getPathsInProgramFiles("\\Mozilla Firefox")).addAll(WindowsUtils.getPathsInProgramFiles("\\Firefox")).build().toArray((Object[])new String[0]);
    }

    protected boolean runningOnWindows() {
        return Platform.getCurrent().is(Platform.WINDOWS);
    }

    public String computeLibraryPath(File launcherPath) {
        if (this.runningOnWindows()) {
            return "";
        }
        StringBuilder libraryPath = new StringBuilder();
        String libraryPropertyName = CommandLine.getLibraryPathPropertyName();
        String existingLibraryPath = System.getenv(libraryPropertyName);
        if (Platform.getCurrent().is(Platform.MAC) && Platform.getCurrent().getMinorVersion() > 5) {
            libraryPath.append(existingLibraryPath);
        } else {
            libraryPath.append(launcherPath.getParent()).append(File.pathSeparator).append((CharSequence)libraryPath);
        }
        return libraryPath.toString();
    }
}

