/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.browserlaunchers;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.os.ProcessUtils;
import org.openqa.selenium.os.UnixUtils;
import org.openqa.selenium.os.WindowsUtils;

public class AsyncExecute {
    static Logger log = Logger.getLogger(AsyncExecute.class.getName());

    public static void sleepTightInSeconds(long timeoutInSeconds) {
        AsyncExecute.sleepTight(timeoutInSeconds * 1000L);
    }

    public static void sleepTight(long timeout) {
        try {
            Thread.sleep(timeout);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static int killProcess(Process process) {
        int exitValue;
        process.destroy();
        try {
            exitValue = ProcessUtils.waitForProcessDeath(process, 10000L);
        }
        catch (ProcessUtils.ProcessStillAliveException ex) {
            if (WindowsUtils.thisIsWindows()) {
                throw ex;
            }
            try {
                log.info("Process didn't die after 10 seconds");
                UnixUtils.kill9(process);
                exitValue = ProcessUtils.waitForProcessDeath(process, 10000L);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Process refused to die after 10 seconds, and couldn't kill9 it", e);
                throw new RuntimeException("Process refused to die after 10 seconds, and couldn't kill9 it: " + e.getMessage(), ex);
            }
        }
        return exitValue;
    }
}

