/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.browserlaunchers.locators;

import java.io.File;
import org.openqa.selenium.Platform;
import org.openqa.selenium.browserlaunchers.locators.FirefoxLocator;
import org.openqa.selenium.os.CommandLine;
import org.openqa.selenium.os.WindowsUtils;

public class Firefox2Locator
extends FirefoxLocator {
    private static final String[] USUAL_UNIX_LAUNCHER_LOCATIONS = new String[]{"/Applications/Minefield.app/Contents/MacOS", "/Applications/Firefox-2.app/Contents/MacOS", "/Applications/Firefox.app/Contents/MacOS", "/usr/lib/firefox"};
    private static final String[] USUAL_WINDOWS_LAUNCHER_LOCATIONS = new String[]{WindowsUtils.getProgramFilesPath() + "\\Mozilla Firefox", WindowsUtils.getProgramFilesPath() + "\\Firefox", WindowsUtils.getProgramFilesPath() + "\\Firefox-2"};

    protected String browserName() {
        return "Firefox 2";
    }

    protected String seleniumBrowserName() {
        return "*firefox2";
    }

    protected String[] standardlauncherFilenames() {
        if (WindowsUtils.thisIsWindows()) {
            return new String[]{"firefox.exe"};
        }
        return new String[]{"firefox-bin"};
    }

    protected String[] usualLauncherLocations() {
        return WindowsUtils.thisIsWindows() ? USUAL_WINDOWS_LAUNCHER_LOCATIONS : USUAL_UNIX_LAUNCHER_LOCATIONS;
    }

    protected boolean runningOnWindows() {
        return Platform.getCurrent().is(Platform.WINDOWS);
    }

    public String computeLibraryPath(File launcherPath) {
        if (this.runningOnWindows()) {
            return "";
        }
        StringBuilder libraryPath = new StringBuilder();
        String libraryPropertyName = CommandLine.getLibraryPathPropertyName();
        String existingLibraryPath = System.getenv(libraryPropertyName);
        if (Platform.getCurrent().is(Platform.MAC) && Platform.getCurrent().getMinorVersion() > 5) {
            libraryPath.append(existingLibraryPath);
        } else {
            libraryPath.append(launcherPath.getParent()).append(File.pathSeparator).append((CharSequence)libraryPath);
        }
        return libraryPath.toString();
    }
}

