/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import java.util.Map;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.remote.Browser;

public class DesiredCapabilities
extends MutableCapabilities {
    public DesiredCapabilities(String browser, String version, Platform platform) {
        this.setCapability("browserName", browser);
        this.setCapability("version", version);
        this.setCapability("platform", platform);
    }

    public DesiredCapabilities() {
    }

    public DesiredCapabilities(Map<String, ?> rawMap) {
        if (rawMap == null) {
            return;
        }
        rawMap.forEach((arg_0, arg_1) -> ((DesiredCapabilities)this).setCapability(arg_0, arg_1));
    }

    public DesiredCapabilities(Capabilities other) {
        this.merge(other);
    }

    public DesiredCapabilities(Capabilities ... others) {
        for (Capabilities caps : others) {
            this.merge(caps);
        }
    }

    @Deprecated
    public static DesiredCapabilities htmlUnit() {
        return new DesiredCapabilities(Browser.HTMLUNIT.browserName(), "", Platform.ANY);
    }

    public void setBrowserName(String browserName) {
        this.setCapability("browserName", browserName);
    }

    public void setVersion(String version) {
        this.setCapability("version", version);
    }

    public void setPlatform(Platform platform) {
        this.setCapability("platform", platform);
    }

    public void setJavascriptEnabled(boolean javascriptEnabled) {
        this.setCapability("javascriptEnabled", javascriptEnabled);
    }

    public boolean acceptInsecureCerts() {
        if (this.getCapability("acceptInsecureCerts") != null) {
            Object raw = this.getCapability("acceptInsecureCerts");
            if (raw instanceof String) {
                return Boolean.parseBoolean((String)raw);
            }
            if (raw instanceof Boolean) {
                return (Boolean)raw;
            }
        }
        return true;
    }

    public void setAcceptInsecureCerts(boolean acceptInsecureCerts) {
        this.setCapability("acceptInsecureCerts", acceptInsecureCerts);
    }

    public DesiredCapabilities merge(Capabilities extraCapabilities) {
        if (extraCapabilities != null) {
            extraCapabilities.asMap().forEach((arg_0, arg_1) -> ((DesiredCapabilities)this).setCapability(arg_0, arg_1));
        }
        return this;
    }
}

