/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools;

import java.util.Map;
import java.util.Optional;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.devtools.DevTools;
import org.openqa.selenium.devtools.HasDevTools;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.Filter;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.http.Routable;

public class NetworkInterceptor
implements AutoCloseable {
    public static final HttpResponse PROCEED_WITH_REQUEST = (HttpResponse)((HttpResponse)new HttpResponse().addHeader("Selenium-Interceptor", "Continue")).setContent(Contents.utf8String((CharSequence)"Original request should proceed"));
    private final DevTools tools;

    public NetworkInterceptor(WebDriver driver, HttpHandler handler) {
        this(driver, next -> handler);
    }

    public NetworkInterceptor(WebDriver driver, Routable routable) {
        this(driver, next -> req -> {
            if (routable.matches(req)) {
                return routable.execute(req);
            }
            return next.execute(req);
        });
    }

    public NetworkInterceptor(WebDriver driver, Filter filter) {
        Require.nonNull((String)"WebDriver", (Object)driver);
        Require.nonNull((String)"HTTP filter", (Object)filter);
        if (!(driver instanceof HasDevTools)) {
            throw new IllegalArgumentException("WebDriver instance must implement HasDevTools");
        }
        this.tools = ((HasDevTools)driver).getDevTools();
        this.tools.createSessionIfThereIsNotOne();
        this.tools.getDomains().network().interceptTrafficWith(filter);
    }

    @Override
    public void close() {
        this.tools.getDomains().network().resetNetworkFilter();
    }

    protected HttpMethod convertFromCdpHttpMethod(String method) {
        Require.nonNull((String)"HTTP Method", (Object)method);
        try {
            return HttpMethod.valueOf((String)method.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return HttpMethod.GET;
        }
    }

    protected HttpRequest createHttpRequest(String cdpMethod, String url, Map<String, Object> headers, Optional<String> postData) {
        HttpRequest req = new HttpRequest(this.convertFromCdpHttpMethod(cdpMethod), url);
        headers.forEach((key, value) -> req.addHeader(key, String.valueOf(value)));
        postData.ifPresent(data -> req.setContent(Contents.utf8String((CharSequence)data)));
        return req;
    }
}

