/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.openqa.selenium.DeviceRotation;
import org.openqa.selenium.Rotatable;
import org.openqa.selenium.ScreenOrientation;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.ExecuteMethod;

class RemoteRotatable
implements Rotatable {
    private final ExecuteMethod executeMethod;

    public RemoteRotatable(ExecuteMethod executeMethod) {
        this.executeMethod = (ExecuteMethod)Require.nonNull((String)"Execute method", (Object)executeMethod);
    }

    public void rotate(ScreenOrientation orientation) {
        this.executeMethod.execute("setScreenOrientation", (Map<String, ?>)ImmutableMap.of((Object)"orientation", (Object)orientation));
    }

    public ScreenOrientation getOrientation() {
        return ScreenOrientation.valueOf((String)((String)this.executeMethod.execute("getScreenOrientation", null)));
    }

    public void rotate(DeviceRotation rotation) {
        this.executeMethod.execute("setScreenOrientation", rotation.parameters());
    }

    public DeviceRotation rotation() {
        Object result = this.executeMethod.execute("getScreenRotation", null);
        if (!(result instanceof Map)) {
            throw new IllegalStateException("Unexpected return value: " + result);
        }
        Map raw = (Map)result;
        return new DeviceRotation(raw);
    }
}

