/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.support.ui;

import com.google.common.base.Function;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.NotFoundException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.support.ui.Clock;
import org.openqa.selenium.support.ui.SystemClock;
import org.openqa.selenium.support.ui.TimeoutException;
import org.openqa.selenium.support.ui.Wait;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebDriverWait
implements Wait<WebDriver> {
    private final Clock clock;
    private final WebDriver driver;
    private final long timeOutInMillis;
    private final long sleepTimeOut;
    public static final long DEFAULT_SLEEP_TIMEOUT = 500L;

    public WebDriverWait(WebDriver driver, long timeOutInSeconds) {
        this(new SystemClock(), driver, timeOutInSeconds, 500L);
    }

    public WebDriverWait(WebDriver driver, long timeOutInSeconds, long sleepInMillis) {
        this(new SystemClock(), driver, timeOutInSeconds, sleepInMillis);
    }

    protected WebDriverWait(Clock clock, WebDriver driver, long timeOutInSeconds, long sleepTimeOut) {
        this.clock = clock;
        this.driver = driver;
        this.timeOutInMillis = TimeUnit.SECONDS.toMillis(timeOutInSeconds);
        this.sleepTimeOut = sleepTimeOut;
    }

    @Override
    public <T> T until(Function<WebDriver, T> isTrue) {
        long end = this.clock.laterBy(this.timeOutInMillis);
        NotFoundException lastException = null;
        while (this.clock.isNowBefore(end)) {
            try {
                Object value = isTrue.apply((Object)this.driver);
                if (value != null && Boolean.class.equals(value.getClass()) ? Boolean.TRUE.equals(value) : value != null) {
                    return (T)value;
                }
            }
            catch (NotFoundException e) {
                lastException = e;
            }
            this.sleep();
        }
        this.throwTimeoutException(String.format("Timed out after %d seconds", TimeUnit.SECONDS.convert(this.timeOutInMillis, TimeUnit.MILLISECONDS)), (Exception)((Object)lastException));
        throw new IllegalStateException("'throwTimeoutException' should have thrown an exception!");
    }

    protected void throwTimeoutException(String message, Exception lastException) {
        throw new TimeoutException(message, lastException);
    }

    private void sleep() {
        try {
            Thread.sleep(this.sleepTimeOut);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new WebDriverException((Throwable)e);
        }
    }
}

