/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.support.pagefactory;

import java.lang.reflect.Field;
import java.time.Clock;
import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.pagefactory.AbstractAnnotations;
import org.openqa.selenium.support.pagefactory.Annotations;
import org.openqa.selenium.support.pagefactory.DefaultElementLocator;
import org.openqa.selenium.support.ui.SlowLoadableComponent;

public class AjaxElementLocator
extends DefaultElementLocator {
    protected final int timeOutInSeconds;
    private final Clock clock;

    public AjaxElementLocator(SearchContext context, int timeOutInSeconds, AbstractAnnotations annotations) {
        this(Clock.systemDefaultZone(), context, timeOutInSeconds, annotations);
    }

    public AjaxElementLocator(Clock clock, SearchContext context, int timeOutInSeconds, AbstractAnnotations annotations) {
        super(context, annotations);
        this.timeOutInSeconds = timeOutInSeconds;
        this.clock = clock;
    }

    public AjaxElementLocator(SearchContext searchContext, Field field, int timeOutInSeconds) {
        this(Clock.systemDefaultZone(), searchContext, field, timeOutInSeconds);
    }

    public AjaxElementLocator(Clock clock, SearchContext searchContext, Field field, int timeOutInSeconds) {
        this(clock, searchContext, timeOutInSeconds, new Annotations(field));
    }

    @Override
    public WebElement findElement() {
        SlowLoadingElement loadingElement = new SlowLoadingElement(this.clock, this.timeOutInSeconds);
        try {
            return ((SlowLoadingElement)loadingElement.get()).getElement();
        }
        catch (NoSuchElementError e) {
            throw new NoSuchElementException(String.format("Timed out after %d seconds. %s", this.timeOutInSeconds, e.getMessage()), e.getCause());
        }
    }

    @Override
    public List<WebElement> findElements() {
        SlowLoadingElementList list = new SlowLoadingElementList(this.clock, this.timeOutInSeconds);
        try {
            return ((SlowLoadingElementList)list.get()).getElements();
        }
        catch (NoSuchElementError e) {
            return new ArrayList<WebElement>();
        }
    }

    protected long sleepFor() {
        return 250L;
    }

    protected boolean isElementUsable(WebElement element) {
        return true;
    }

    private class SlowLoadingElement
    extends SlowLoadableComponent<SlowLoadingElement> {
        private NoSuchElementException lastException;
        private WebElement element;

        public SlowLoadingElement(Clock clock, int timeOutInSeconds) {
            super(clock, timeOutInSeconds);
        }

        @Override
        protected void load() {
        }

        @Override
        protected long sleepFor() {
            return AjaxElementLocator.this.sleepFor();
        }

        @Override
        protected void isLoaded() throws Error {
            try {
                this.element = AjaxElementLocator.super.findElement();
                if (!AjaxElementLocator.this.isElementUsable(this.element)) {
                    throw new NoSuchElementException("Element is not usable");
                }
            }
            catch (NoSuchElementException e) {
                this.lastException = e;
                throw new NoSuchElementError("Unable to locate the element", e);
            }
        }

        public NoSuchElementException getLastException() {
            return this.lastException;
        }

        public WebElement getElement() {
            return this.element;
        }
    }

    private static class NoSuchElementError
    extends Error {
        private NoSuchElementError(String message, Throwable throwable) {
            super(message, throwable);
        }
    }

    private class SlowLoadingElementList
    extends SlowLoadableComponent<SlowLoadingElementList> {
        private NoSuchElementException lastException;
        private List<WebElement> elements;

        public SlowLoadingElementList(Clock clock, int timeOutInSeconds) {
            super(clock, timeOutInSeconds);
        }

        @Override
        protected void load() {
        }

        @Override
        protected long sleepFor() {
            return AjaxElementLocator.this.sleepFor();
        }

        @Override
        protected void isLoaded() throws Error {
            try {
                this.elements = AjaxElementLocator.super.findElements();
                if (this.elements.size() == 0) {
                    throw new NoSuchElementException("Unable to locate the element");
                }
                for (WebElement element : this.elements) {
                    if (AjaxElementLocator.this.isElementUsable(element)) continue;
                    throw new NoSuchElementException("Element is not usable");
                }
            }
            catch (NoSuchElementException e) {
                this.lastException = e;
                throw new NoSuchElementError("Unable to locate the element", e);
            }
        }

        public NoSuchElementException getLastException() {
            return this.lastException;
        }

        public List<WebElement> getElements() {
            return this.elements;
        }
    }
}

