/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import java.lang.reflect.Constructor;
import java.util.List;
import org.simpleframework.xml.core.Criteria;
import org.simpleframework.xml.core.Index;
import org.simpleframework.xml.core.Parameter;
import org.simpleframework.xml.core.Variable;

class Builder {
    private final List<Parameter> list;
    private final Constructor factory;
    private final Index index;

    public Builder(Constructor factory, Index index) {
        this.list = index.getParameters();
        this.factory = factory;
        this.index = index;
    }

    public boolean isDefault() {
        return this.index.size() == 0;
    }

    public Parameter getParameter(String name) {
        return (Parameter)this.index.get(name);
    }

    public Object getInstance() throws Exception {
        if (!this.factory.isAccessible()) {
            this.factory.setAccessible(true);
        }
        return this.factory.newInstance(new Object[0]);
    }

    public Object getInstance(Criteria criteria) throws Exception {
        Object[] values = this.list.toArray();
        for (int i = 0; i < this.list.size(); ++i) {
            Object value;
            String name = this.list.get(i).getName();
            Variable variable = criteria.remove(name);
            values[i] = value = variable.getValue();
        }
        return this.getInstance(values);
    }

    private Object getInstance(Object[] list) throws Exception {
        if (!this.factory.isAccessible()) {
            this.factory.setAccessible(true);
        }
        return this.factory.newInstance(list);
    }

    public int score(Criteria criteria) throws Exception {
        int score = 0;
        for (int i = 0; i < this.list.size(); ++i) {
            String name = this.list.get(i).getName();
            Variable label = criteria.get(name);
            if (label == null) {
                return -1;
            }
            ++score;
        }
        return score;
    }

    public String toString() {
        return this.factory.toString();
    }
}

