/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.jsonassert;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONString;

public class JSONParser {
    private static final String NUMBER_REGEX = "-?(?:0|[1-9]\\d*)(?:\\.\\d+)?(?:[eE][+-]?\\d+)?";

    private JSONParser() {
    }

    public static Object parseJSON(final String s) throws JSONException {
        if (s.trim().startsWith("{")) {
            return new JSONObject(s);
        }
        if (s.trim().startsWith("[")) {
            return new JSONArray(s);
        }
        if (s.trim().startsWith("\"") || s.trim().matches(NUMBER_REGEX)) {
            return new JSONString(){

                @Override
                public String toJSONString() {
                    return s;
                }
            };
        }
        throw new JSONException("Unparsable JSON string: " + s);
    }
}

