/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.nevado.jms;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.skyscreamer.nevado.jms.NevadoSession;
import org.skyscreamer.nevado.jms.message.NevadoMessage;

public class MessageHolder {
    private final Log _log = LogFactory.getLog(this.getClass());
    private final NevadoSession _session;
    private final Map<Destination, List<NevadoMessage>> _messageHolder = new HashMap<Destination, List<NevadoMessage>>();
    private final Map<Destination, Integer> _messageIndex = new HashMap<Destination, Integer>();

    public MessageHolder(NevadoSession session) {
        this._session = session;
    }

    public void add(Destination destination, NevadoMessage msg) {
        int index;
        if (!this._messageHolder.containsKey(destination)) {
            this._messageHolder.put(destination, new ArrayList());
        }
        List<NevadoMessage> messageList = this._messageHolder.get(destination);
        int n = index = this._messageIndex.containsKey(destination) ? this._messageIndex.get(destination) : 0;
        if (index < messageList.size()) {
            throw new IllegalStateException("Cannot add message while in replay mode");
        }
        messageList.add(msg);
        this._messageIndex.put(destination, index + 1);
    }

    public NevadoMessage getNextMessage(Destination destination) {
        NevadoMessage message = null;
        if (this._messageHolder.containsKey(destination)) {
            List<NevadoMessage> messageList = this._messageHolder.get(destination);
            int index = this._messageIndex.get(destination);
            if (index < messageList.size()) {
                message = messageList.get(index);
                this._messageIndex.put(destination, index + 1);
            }
        }
        return message;
    }

    public void acknowledgeConsumedMessages() throws JMSException {
        ArrayList<NevadoMessage> consumedMessages = new ArrayList<NevadoMessage>();
        ArrayList<NevadoMessage> unconsumedMessages = new ArrayList<NevadoMessage>();
        for (Destination destination : this._messageHolder.keySet()) {
            for (NevadoMessage msg : this.getConsumedMessages(destination)) {
                consumedMessages.add(msg);
            }
            for (NevadoMessage msg : this.getUnconsumedMessages(destination)) {
                unconsumedMessages.add(msg);
            }
        }
        this._session.deleteMessage(consumedMessages.toArray(new NevadoMessage[0]));
        for (NevadoMessage msg : consumedMessages) {
            msg.setAcknowledged(true);
        }
        this._session.resetMessage(unconsumedMessages.toArray(new NevadoMessage[0]));
        this._messageHolder.clear();
        this._messageIndex.clear();
    }

    public void close() throws JMSException {
        this.reset();
        for (Destination destination : this._messageHolder.keySet()) {
            this._session.resetMessage(this.getUnconsumedMessages(destination).toArray(new NevadoMessage[0]));
        }
    }

    public List<NevadoMessage> getConsumedMessages() {
        ArrayList<NevadoMessage> consumedMessages = new ArrayList<NevadoMessage>();
        for (Destination destination : this._messageHolder.keySet()) {
            for (NevadoMessage msg : this.getConsumedMessages(destination)) {
                consumedMessages.add(msg);
            }
        }
        return consumedMessages;
    }

    private List<NevadoMessage> getConsumedMessages(Destination destination) {
        if (this._messageHolder.containsKey(destination)) {
            List<NevadoMessage> messageList = this._messageHolder.get(destination);
            int index = this._messageIndex.get(destination);
            return messageList.subList(0, index);
        }
        return Collections.emptyList();
    }

    private List<NevadoMessage> getUnconsumedMessages(Destination destination) {
        if (this._messageHolder.containsKey(destination)) {
            List<NevadoMessage> messageList = this._messageHolder.get(destination);
            int index = this._messageIndex.get(destination);
            return messageList.subList(index, messageList.size());
        }
        return Collections.emptyList();
    }

    public void reset() {
        for (Destination destination : this._messageIndex.keySet()) {
            this._messageIndex.put(destination, 0);
        }
    }
}

