/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.nevado.jms;

import java.util.concurrent.atomic.AtomicReference;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueReceiver;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.skyscreamer.nevado.jms.NevadoSession;
import org.skyscreamer.nevado.jms.destination.NevadoDestination;
import org.skyscreamer.nevado.jms.destination.NevadoQueue;
import org.skyscreamer.nevado.jms.destination.NevadoTemporaryQueue;
import org.skyscreamer.nevado.jms.destination.NevadoTopic;
import org.skyscreamer.nevado.jms.message.NevadoMessage;

public class NevadoMessageConsumer
implements MessageConsumer,
QueueReceiver,
TopicSubscriber {
    private final Log _log = LogFactory.getLog(this.getClass());
    private boolean _closed = false;
    private final NevadoSession _session;
    private final NevadoDestination _destination;
    private final String _selector;
    private final boolean _noLocal;
    private volatile MessageListener _messageListener;
    private final AtomicReference<NevadoMessage> _messageParking = new AtomicReference();

    public NevadoMessageConsumer(NevadoSession session, NevadoDestination destination, String selector, boolean noLocal) throws JMSException {
        this._session = session;
        if (destination instanceof NevadoTopic) {
            NevadoTemporaryQueue topicEndpoint = this._session.getConnection().createTemporaryQueue();
            String subscriptionArn = this._session.getConnection().subscribe((NevadoTopic)destination, topicEndpoint);
            this._destination = new NevadoTopic((NevadoTopic)destination, topicEndpoint, subscriptionArn, false);
        } else {
            this._destination = destination;
        }
        this._selector = selector;
        this._noLocal = noLocal;
    }

    public NevadoMessageConsumer(NevadoSession session, NevadoTopic topic, String durableSubscriptionName, String selector, boolean noLocal) throws JMSException {
        this._session = session;
        NevadoQueue topicEndpoint = this._session.createInternalQueue(this._session.getDurableEndpointQueueName(durableSubscriptionName));
        String subscriptionArn = this._session.getConnection().subscribe(topic, topicEndpoint);
        this._destination = new NevadoTopic(topic, topicEndpoint, subscriptionArn, true);
        this._selector = selector;
        this._noLocal = noLocal;
    }

    public String getMessageSelector() throws JMSException {
        return null;
    }

    public MessageListener getMessageListener() {
        return this._messageListener;
    }

    public void setMessageListener(MessageListener messageListener) throws JMSException {
        this.checkClosed();
        this._messageListener = messageListener;
    }

    public NevadoMessage receive() throws JMSException {
        return this.receive(-1L);
    }

    public NevadoMessage receive(long timeoutMs) throws JMSException {
        NevadoMessage message;
        this.checkClosed();
        this.checkAsync();
        try {
            message = this._session.receiveMessage(this._destination, timeoutMs, this._noLocal);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
        this.tryAutoAck(message);
        return message;
    }

    public NevadoMessage receiveNoWait() throws JMSException {
        return this.receive(0L);
    }

    public synchronized void close() throws JMSException {
        if (!this._closed) {
            NevadoMessage parkedMessage;
            if (this._destination instanceof NevadoTopic && !((NevadoTopic)this._destination).isDurable()) {
                this._session.getConnection().unsubscribe((NevadoTopic)this._destination);
            }
            if ((parkedMessage = (NevadoMessage)this._messageParking.getAndSet(null)) != null) {
                this._session.resetMessage(parkedMessage);
            }
            this._messageListener = null;
            this._closed = true;
        }
    }

    protected boolean processAsyncMessage() throws JMSException, InterruptedException {
        boolean messageProcessed;
        block4: {
            this.checkClosed();
            messageProcessed = false;
            NevadoMessage message = this._messageParking.getAndSet(null);
            if (message == null) {
                message = this._session.receiveMessage(this._destination, 0L, this._noLocal);
            }
            if (message != null) {
                try {
                    this.getMessageListener().onMessage((Message)message);
                    this.tryAutoAck(message);
                    messageProcessed = true;
                }
                catch (Throwable t) {
                    NevadoMessage parkedMessage;
                    if (this._session.getAcknowledgeMode() != 1 && this._session.getAcknowledgeMode() != 3 || (parkedMessage = this._messageParking.getAndSet(message)) == null) break block4;
                    this._log.error((Object)("Stepped on an unexpected parked message.  Resetting it: " + parkedMessage));
                    this._session.resetMessage(parkedMessage);
                }
            }
        }
        return messageProcessed;
    }

    private void tryAutoAck(NevadoMessage message) throws JMSException {
        if (message != null && this._session.getAcknowledgeMode() == 1) {
            message.acknowledge();
        }
    }

    private void checkAsync() throws IllegalStateException {
        if (this._messageListener != null) {
            throw new IllegalStateException("Synchronous message delivery cannot be requested from a consumer after a message listener has been registered");
        }
    }

    public Queue getQueue() throws JMSException {
        if (this._destination instanceof Queue) {
            return (Queue)this._destination;
        }
        throw new IllegalStateException("getQueue() can only be called for a QueueSender");
    }

    protected Destination getDestination() {
        return this._destination;
    }

    public boolean isClosed() {
        return this._closed;
    }

    private void checkClosed() throws IllegalStateException {
        if (this._closed) {
            throw new IllegalStateException("This consumer has been closed");
        }
    }

    public Topic getTopic() throws JMSException {
        if (this._destination instanceof Topic) {
            return (Topic)this._destination;
        }
        throw new IllegalStateException("getTopic() can only be called for a TopicSubscriber");
    }

    public boolean getNoLocal() throws JMSException {
        return this._noLocal;
    }
}

