/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.nevado.jms;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.skyscreamer.nevado.jms.AsyncConsumerRunner;
import org.skyscreamer.nevado.jms.MessageHolder;
import org.skyscreamer.nevado.jms.NevadoConnection;
import org.skyscreamer.nevado.jms.NevadoMessageConsumer;
import org.skyscreamer.nevado.jms.NevadoMessageProducer;
import org.skyscreamer.nevado.jms.destination.NevadoDestination;
import org.skyscreamer.nevado.jms.destination.NevadoProviderQueuePrefix;
import org.skyscreamer.nevado.jms.destination.NevadoQueue;
import org.skyscreamer.nevado.jms.destination.NevadoTemporaryQueue;
import org.skyscreamer.nevado.jms.destination.NevadoTemporaryTopic;
import org.skyscreamer.nevado.jms.destination.NevadoTopic;
import org.skyscreamer.nevado.jms.message.JMSXProperty;
import org.skyscreamer.nevado.jms.message.NevadoBlankMessage;
import org.skyscreamer.nevado.jms.message.NevadoBytesMessage;
import org.skyscreamer.nevado.jms.message.NevadoMapMessage;
import org.skyscreamer.nevado.jms.message.NevadoMessage;
import org.skyscreamer.nevado.jms.message.NevadoObjectMessage;
import org.skyscreamer.nevado.jms.message.NevadoProperty;
import org.skyscreamer.nevado.jms.message.NevadoStreamMessage;
import org.skyscreamer.nevado.jms.message.NevadoTextMessage;
import org.skyscreamer.nevado.jms.util.MessageIdUtil;

public class NevadoSession
implements Session {
    private final Log _log = LogFactory.getLog(this.getClass());
    protected boolean _closed = false;
    private final NevadoConnection _connection;
    private boolean _transacted;
    private int _acknowledgeMode;
    private Integer _overrideJMSDeliveryMode;
    private Long _overrideJMSTTL;
    private Integer _overrideJMSPriority;
    private MessageListener _messageListener;
    private final AsyncConsumerRunner _asyncConsumerRunner;
    private final MessageHolder _incomingStagedMessages = new MessageHolder(this);
    private final Map<NevadoDestination, List<NevadoMessage>> _outgoingTxMessages = new HashMap<NevadoDestination, List<NevadoMessage>>();
    private final Set<NevadoMessageConsumer> _consumers = new HashSet<NevadoMessageConsumer>();
    private final Set<NevadoMessageProducer> _producers = new HashSet<NevadoMessageProducer>();
    private boolean _TESTING_ONLY_break = false;

    protected NevadoSession(NevadoConnection connection, boolean transacted, int acknowledgeMode) {
        this._connection = connection;
        this._transacted = transacted;
        this._acknowledgeMode = acknowledgeMode;
        this._asyncConsumerRunner = new AsyncConsumerRunner(this._connection);
    }

    public NevadoBytesMessage createBytesMessage() throws JMSException {
        this.checkClosed();
        NevadoBytesMessage message = new NevadoBytesMessage();
        message.setNevadoSession(this);
        return message;
    }

    public NevadoMapMessage createMapMessage() throws JMSException {
        this.checkClosed();
        NevadoMapMessage message = new NevadoMapMessage();
        message.setNevadoSession(this);
        return message;
    }

    public NevadoMessage createMessage() throws JMSException {
        this.checkClosed();
        NevadoBlankMessage message = new NevadoBlankMessage();
        message.setNevadoSession(this);
        return message;
    }

    public NevadoObjectMessage createObjectMessage() throws JMSException {
        this.checkClosed();
        NevadoObjectMessage message = new NevadoObjectMessage();
        message.setNevadoSession(this);
        return message;
    }

    public NevadoObjectMessage createObjectMessage(Serializable serializable) throws JMSException {
        this.checkClosed();
        NevadoObjectMessage message = this.createObjectMessage();
        message.setObject(serializable);
        return message;
    }

    public NevadoStreamMessage createStreamMessage() throws JMSException {
        this.checkClosed();
        NevadoStreamMessage message = new NevadoStreamMessage();
        message.setNevadoSession(this);
        return message;
    }

    public NevadoTextMessage createTextMessage() throws JMSException {
        this.checkClosed();
        NevadoTextMessage message = new NevadoTextMessage();
        message.setNevadoSession(this);
        return message;
    }

    public NevadoTextMessage createTextMessage(String text) throws JMSException {
        this.checkClosed();
        NevadoTextMessage message = this.createTextMessage();
        message.setText(text);
        return message;
    }

    public boolean getTransacted() throws JMSException {
        return this._transacted;
    }

    public int getAcknowledgeMode() throws JMSException {
        return this._acknowledgeMode;
    }

    public void commit() throws JMSException {
        this.checkClosed();
        if (!this._transacted) {
            throw new IllegalStateException("Cannot commit an untransacted session");
        }
        for (NevadoDestination destination : this._outgoingTxMessages.keySet()) {
            List<NevadoMessage> outgoingMessages = this._outgoingTxMessages.get(destination);
            this._connection.getSQSConnector().sendMessages(destination, outgoingMessages);
        }
        this._outgoingTxMessages.clear();
        this._incomingStagedMessages.acknowledgeConsumedMessages();
    }

    public void rollback() throws JMSException {
        this.checkClosed();
        if (!this._transacted) {
            throw new IllegalStateException("Cannot rollback an untransacted session");
        }
        this._outgoingTxMessages.clear();
        this._incomingStagedMessages.reset();
    }

    public synchronized void close() throws JMSException {
        if (!this._closed) {
            this.stop();
            this._incomingStagedMessages.close();
            for (NevadoMessageProducer producer : this._producers) {
                producer.close();
            }
            for (NevadoMessageConsumer consumer : this._consumers) {
                consumer.close();
            }
            this._closed = true;
        }
    }

    public void recover() throws JMSException {
        this.checkClosed();
        if (this._acknowledgeMode == 2) {
            this._incomingStagedMessages.reset();
        }
    }

    public MessageListener getMessageListener() throws JMSException {
        this.checkClosed();
        return null;
    }

    public void setMessageListener(MessageListener messageListener) throws JMSException {
        this.checkClosed();
    }

    public void run() {
    }

    public NevadoMessageProducer createProducer(Destination destination) throws JMSException {
        this.checkClosed();
        NevadoMessageProducer producer = new NevadoMessageProducer(this, NevadoDestination.getInstance(destination));
        this._producers.add(producer);
        return producer;
    }

    public NevadoMessageConsumer createConsumer(Destination destination) throws JMSException {
        return this.createConsumer(destination, null);
    }

    public NevadoMessageConsumer createConsumer(Destination destination, String selector) throws JMSException {
        return this.createConsumer(destination, selector, false);
    }

    public NevadoMessageConsumer createConsumer(Destination destination, String selector, boolean noLocal) throws JMSException {
        this.checkClosed();
        this.checkValidDestination(destination);
        NevadoMessageConsumer consumer = new NevadoMessageConsumer(this, NevadoDestination.getInstance(destination), selector, noLocal);
        this._asyncConsumerRunner.addAsyncConsumer(consumer);
        this._consumers.add(consumer);
        return consumer;
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        throw new UnsupportedOperationException("QueueBrowsers are currently not supported");
    }

    public QueueBrowser createBrowser(Queue queue, String s) throws JMSException {
        throw new UnsupportedOperationException("QueueBrowsers are currently not supported");
    }

    public NevadoTemporaryQueue createTemporaryQueue() throws JMSException {
        this.checkClosed();
        return this._connection.createTemporaryQueue();
    }

    public NevadoQueue createQueue(String name) throws JMSException {
        if (!NevadoProviderQueuePrefix.isValidQueueName(name)) {
            throw new InvalidDestinationException("Queue name is not valid: " + name);
        }
        return this.createInternalQueue(name);
    }

    protected NevadoQueue createInternalQueue(String name) throws JMSException {
        this.checkClosed();
        return new NevadoQueue(name);
    }

    public NevadoTopic createTopic(String name) throws JMSException {
        this.checkClosed();
        return new NevadoTopic(name);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        this.checkClosed();
        return this.createDurableSubscriber(topic, name, null, false);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String selector, boolean noLocal) throws JMSException {
        this.checkClosed();
        this.checkValidDestination((Destination)topic);
        String queueName = this.getDurableEndpointQueueName(name);
        if (this.hasActiveDurableSubscriber(queueName)) {
            throw new JMSException("There is already a durable subscriber with name " + name);
        }
        NevadoMessageConsumer consumer = new NevadoMessageConsumer(this, NevadoTopic.getInstance(topic), name, selector, noLocal);
        this._asyncConsumerRunner.addAsyncConsumer(consumer);
        this._consumers.add(consumer);
        return consumer;
    }

    public NevadoTemporaryTopic createTemporaryTopic() throws JMSException {
        this.checkClosed();
        return this._connection.createTemporaryTopic();
    }

    public void unsubscribe(String name) throws JMSException {
        this.checkClosed();
        String queueName = this.getDurableEndpointQueueName(name);
        if (this.hasActiveDurableSubscriber(queueName)) {
            throw new JMSException("Cannot unsubscribe durable topic-subscription '" + name + "': There is an active TopicSubscriber");
        }
        for (NevadoMessage message : this._incomingStagedMessages.getConsumedMessages()) {
            NevadoTopic topic;
            if (!(message.getJMSDestination() instanceof NevadoTopic) || !(topic = (NevadoTopic)message.getJMSDestination()).isDurable() || !queueName.equals(topic.getTopicEndpoint().getQueueName())) continue;
            throw new JMSException("Cannot unsubscribe durable topic-subscription '" + name + "': There is an unacknowledged or uncommitted message from the topic");
        }
        NevadoQueue durableQueue = new NevadoQueue(queueName);
        this._connection.deleteQueue(durableQueue);
    }

    protected String getDurableEndpointQueueName(String durableSubscriptionName) {
        String queueName = (Object)((Object)NevadoProviderQueuePrefix.DURABLE_SUBSCRIPTION_PREFIX) + durableSubscriptionName;
        if (this._connection.getClientID() != null) {
            queueName = queueName + "_client-" + this._connection.getClientID() + "";
        }
        return queueName;
    }

    private boolean hasActiveDurableSubscriber(String queueName) throws JMSException {
        for (NevadoMessageConsumer consumer : this._consumers) {
            NevadoTopic topic;
            if (consumer.isClosed() || consumer.getDestination() == null || !(consumer.getDestination() instanceof NevadoTopic) || !(topic = (NevadoTopic)consumer.getDestination()).isDurable() || !queueName.equals(topic.getTopicEndpoint().getQueueName())) continue;
            return true;
        }
        return false;
    }

    protected void sendMessage(NevadoDestination destination, NevadoMessage message) throws JMSException {
        if (destination == null) {
            throw new NullPointerException("Destination is null");
        }
        if (destination instanceof NevadoTopic) {
            message.setNevadoProperty(NevadoProperty.ConnectionID, this._connection.getConnectionID());
        }
        if (this._overrideJMSDeliveryMode != null) {
            message.setJMSDeliveryMode(this._overrideJMSDeliveryMode);
        }
        if (this._overrideJMSPriority != null) {
            message.setJMSPriority(this._overrideJMSPriority);
        }
        if (this._overrideJMSTTL != null) {
            message.setJMSExpiration(this._overrideJMSTTL > 0L ? System.currentTimeMillis() + this._overrideJMSTTL : 0L);
        }
        message.onSend();
        if (this._transacted) {
            if (!this._outgoingTxMessages.containsKey(destination)) {
                this._outgoingTxMessages.put(destination, new ArrayList());
            }
            if (!message.isDisableMessageID()) {
                message.setJMSMessageID(MessageIdUtil.createMessageId());
            }
            this._outgoingTxMessages.get(destination).add((NevadoMessage)message.copyOf());
        } else {
            this._connection.getSQSConnector().sendMessage(destination, message);
        }
    }

    protected NevadoMessage receiveMessage(NevadoDestination destination, long timeoutMs, boolean noLocal) throws JMSException, InterruptedException {
        this.testBreak();
        long startTime = System.currentTimeMillis();
        NevadoMessage message = null;
        boolean firstPass = true;
        long elapsed = 0L;
        while (firstPass || message == null && (timeoutMs < 0L || (elapsed = System.currentTimeMillis() - startTime) < timeoutMs)) {
            firstPass = false;
            long adjustedTimeout = timeoutMs < 0L ? timeoutMs : timeoutMs - elapsed;
            message = this.getUnfilteredMessage(destination, adjustedTimeout);
            if (message != null && message.getJMSExpiration() > 0L && System.currentTimeMillis() > message.getJMSExpiration()) {
                message.expire();
                this._log.info((Object)("Skipped expired message (" + message.getJMSMessageID() + ")"));
                message = null;
            }
            if (message == null || !(destination instanceof NevadoTopic) || !noLocal || !this._connection.getConnectionID().equals(message.getNevadoProperty(NevadoProperty.ConnectionID))) continue;
            this.deleteMessage(message);
            message = null;
        }
        return message;
    }

    private NevadoMessage getUnfilteredMessage(NevadoDestination destination, long timeoutMs) throws JMSException, InterruptedException {
        NevadoMessage message = null;
        if (this._acknowledgeMode == 2 || this._transacted) {
            message = this._incomingStagedMessages.getNextMessage(destination);
        }
        if (message == null && (message = this._connection.getSQSConnector().receiveMessage(this._connection, destination, timeoutMs)) != null && (this._acknowledgeMode == 2 || this._transacted)) {
            this._incomingStagedMessages.add(destination, message);
        }
        if (message != null) {
            message.setNevadoSession(this);
            message.setNevadoDestination(destination);
            if (message.propertyExists((Object)((Object)JMSXProperty.JMSXDeliveryCount) + "")) {
                int redeliveryCount = (Integer)message.getJMSXProperty(JMSXProperty.JMSXDeliveryCount);
                message.setJMSXProperty(JMSXProperty.JMSXDeliveryCount, ++redeliveryCount);
                message.setJMSRedelivered(true);
            } else {
                message.setJMSXProperty(JMSXProperty.JMSXDeliveryCount, 1);
            }
        }
        return message;
    }

    public void acknowledgeMessage(NevadoMessage message) throws JMSException {
        this.checkClosed();
        if (this != message.getNevadoSession()) {
            throw new IllegalStateException("Session should only acknowledge its own messages");
        }
        if (!this._transacted) {
            if (this._acknowledgeMode == 2) {
                this._incomingStagedMessages.acknowledgeConsumedMessages();
            } else {
                this.deleteMessage(message);
            }
        }
    }

    public void expireMessage(NevadoMessage message) throws JMSException {
        this.checkClosed();
        if (this != message.getNevadoSession()) {
            throw new IllegalStateException("Session should only expire its own messages");
        }
        this.deleteMessage(message);
    }

    protected void deleteMessage(NevadoMessage ... messages) throws JMSException {
        for (NevadoMessage message : messages) {
            this._connection.getSQSConnector().deleteMessage(message);
        }
    }

    protected void resetMessage(NevadoMessage ... messages) {
        for (NevadoMessage message : messages) {
            try {
                this._connection.getSQSConnector().resetMessage(message);
            }
            catch (Throwable t) {
                this._log.warn((Object)("Unable to reset message: " + message), t);
            }
        }
    }

    public void setOverrideJMSDeliveryMode(Integer jmsDeliveryMode) {
        this._overrideJMSDeliveryMode = jmsDeliveryMode;
    }

    public void setOverrideJMSTTL(Long jmsTTL) {
        this._overrideJMSTTL = jmsTTL;
    }

    public void setOverrideJMSPriority(Integer jmsPriority) {
        this._overrideJMSPriority = jmsPriority;
    }

    public boolean isClosed() {
        return this._closed;
    }

    protected NevadoConnection getConnection() {
        return this._connection;
    }

    protected synchronized void start() {
        this._asyncConsumerRunner.start();
    }

    protected synchronized void stop() throws JMSException {
        try {
            this._asyncConsumerRunner.stop();
        }
        catch (InterruptedException e) {
            String exMessage = "Session threads may not have closed yet: " + e.getMessage();
            this._log.warn((Object)exMessage, (Throwable)e);
            throw new JMSException(exMessage);
        }
    }

    protected void checkClosed() throws IllegalStateException {
        if (this._closed) {
            throw new IllegalStateException("This session has been closed");
        }
    }

    private void checkValidDestination(Destination destination) throws JMSException {
        if ((destination instanceof TemporaryQueue || destination instanceof TemporaryTopic) && !this._connection.ownsTemporaryDestination(destination)) {
            throw new InvalidDestinationException("Consumers for temporary destinations cannot be created outside of the connection where the destination was created.");
        }
    }

    protected void setBreakSessionForTesting(boolean value) {
        this._TESTING_ONLY_break = value;
    }

    private void testBreak() throws JMSException {
        if (this._TESTING_ONLY_break) {
            throw new JMSException("SESSION DELIBERATELY THROWING EXCEPTION - EXPECTED BEHAVIOR - FOR TESTING MODE ONLY");
        }
    }
}

