/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.nevado.jms.connector.amazonaws;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.sqs.model.ChangeMessageVisibilityRequest;
import com.amazonaws.services.sqs.model.DeleteMessageRequest;
import com.amazonaws.services.sqs.model.DeleteQueueRequest;
import com.amazonaws.services.sqs.model.GetQueueAttributesRequest;
import com.amazonaws.services.sqs.model.Message;
import com.amazonaws.services.sqs.model.ReceiveMessageRequest;
import com.amazonaws.services.sqs.model.ReceiveMessageResult;
import com.amazonaws.services.sqs.model.SendMessageRequest;
import com.amazonaws.services.sqs.model.SendMessageResult;
import com.amazonaws.services.sqs.model.SetQueueAttributesRequest;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.jms.JMSException;
import org.skyscreamer.nevado.jms.connector.SQSQueue;
import org.skyscreamer.nevado.jms.connector.amazonaws.AmazonAwsSQSConnector;
import org.skyscreamer.nevado.jms.connector.amazonaws.AmazonAwsSQSMessage;

public class AmazonAwsSQSQueue
implements SQSQueue {
    public static final String ATTRIBUTE_QUEUE_ARN = "QueueArn";
    public static final String ATTRIBUTE_POLICY = "Policy";
    private final String _queueUrl;
    private final AmazonAwsSQSConnector _amazonAwsSQSConnector;

    public AmazonAwsSQSQueue(AmazonAwsSQSConnector amazonAwsSQSConnector, String queueUrl) {
        this._amazonAwsSQSConnector = amazonAwsSQSConnector;
        this._queueUrl = queueUrl;
    }

    @Override
    public String sendMessage(String serializedMessage) throws JMSException {
        SendMessageResult result;
        try {
            result = this._amazonAwsSQSConnector._amazonSQS.sendMessage(new SendMessageRequest(this._queueUrl, serializedMessage));
        }
        catch (AmazonServiceException e) {
            throw this._amazonAwsSQSConnector.handleAWSException("Unable to send message to queue " + this._queueUrl, (AmazonClientException)((Object)e));
        }
        return result.getMessageId();
    }

    @Override
    public void setMessageVisibilityTimeout(String sqsReceiptHandle, int timeout) throws JMSException {
        try {
            this._amazonAwsSQSConnector._amazonSQS.changeMessageVisibility(new ChangeMessageVisibilityRequest(this._queueUrl, sqsReceiptHandle, Integer.valueOf(timeout)));
        }
        catch (AmazonServiceException e) {
            throw this._amazonAwsSQSConnector.handleAWSException("Unable to reset message visibility for message with receipt handle " + sqsReceiptHandle, (AmazonClientException)((Object)e));
        }
    }

    @Override
    public String getQueueARN() throws JMSException {
        Map queueAttributes;
        GetQueueAttributesRequest request = new GetQueueAttributesRequest(this._queueUrl).withAttributeNames(new String[]{ATTRIBUTE_QUEUE_ARN});
        try {
            queueAttributes = this._amazonAwsSQSConnector._amazonSQS.getQueueAttributes(request).getAttributes();
        }
        catch (AmazonServiceException e) {
            throw this._amazonAwsSQSConnector.handleAWSException("Unable to get queue ARN for queue " + this._queueUrl, (AmazonClientException)((Object)e));
        }
        return (String)queueAttributes.get(ATTRIBUTE_QUEUE_ARN);
    }

    @Override
    public void setPolicy(String policy) throws JMSException {
        try {
            this._amazonAwsSQSConnector._amazonSQS.setQueueAttributes(new SetQueueAttributesRequest(this._queueUrl, Collections.singletonMap(ATTRIBUTE_POLICY, policy)));
        }
        catch (AmazonServiceException e) {
            throw this._amazonAwsSQSConnector.handleAWSException("Unable to set policy", (AmazonClientException)((Object)e));
        }
    }

    @Override
    public void deleteMessage(String sqsReceiptHandle) throws JMSException {
        try {
            this._amazonAwsSQSConnector._amazonSQS.deleteMessage(new DeleteMessageRequest(this._queueUrl, sqsReceiptHandle));
        }
        catch (AmazonServiceException e) {
            throw this._amazonAwsSQSConnector.handleAWSException("Unable to delete message with receipt handle " + sqsReceiptHandle, (AmazonClientException)((Object)e));
        }
    }

    @Override
    public AmazonAwsSQSMessage receiveMessage() throws JMSException {
        AmazonAwsSQSMessage sqsMessage;
        try {
            ReceiveMessageResult result = this._amazonAwsSQSConnector._amazonSQS.receiveMessage(new ReceiveMessageRequest(this._queueUrl));
            List messages = result.getMessages();
            sqsMessage = messages != null && messages.size() > 0 ? new AmazonAwsSQSMessage((Message)messages.get(0)) : null;
        }
        catch (AmazonServiceException e) {
            throw this._amazonAwsSQSConnector.handleAWSException("Unable to retrieve message from queue " + this._queueUrl, (AmazonClientException)((Object)e));
        }
        return sqsMessage;
    }

    @Override
    public void deleteQueue() throws JMSException {
        try {
            this._amazonAwsSQSConnector._amazonSQS.deleteQueue(new DeleteQueueRequest(this._queueUrl));
        }
        catch (AmazonServiceException e) {
            throw this._amazonAwsSQSConnector.handleAWSException("Unable to delete message queue '" + this._queueUrl, (AmazonClientException)((Object)e));
        }
    }
}

