/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.nevado.jms.destination;

import java.io.Serializable;
import java.net.URL;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import org.skyscreamer.nevado.jms.destination.NevadoQueue;
import org.skyscreamer.nevado.jms.destination.NevadoTopic;
import org.skyscreamer.nevado.jms.resource.NevadoReferencableFactory;

public abstract class NevadoDestination
implements Destination,
Serializable,
Referenceable {
    public static final String JNDI_DESTINATION_NAME = "name";
    private final String _name;
    private transient boolean _deleted;

    protected NevadoDestination(String name) {
        this._name = name;
    }

    protected NevadoDestination(NevadoDestination destination) {
        this._name = destination._name;
    }

    protected NevadoDestination(URL sqsURL) {
        if (sqsURL == null) {
            throw new NullPointerException("Null URL");
        }
        this._name = this.parseQueueName(sqsURL.getPath());
    }

    private String parseQueueName(String path) {
        int lastSlashIndex = path.lastIndexOf(47);
        if (lastSlashIndex <= 0 || lastSlashIndex + 1 >= path.length()) {
            throw new IllegalArgumentException("Can't parse queue name from invalid path: " + path);
        }
        return path.substring(lastSlashIndex + 1);
    }

    public String getName() {
        return this._name;
    }

    public boolean isDeleted() {
        return this._deleted;
    }

    public void setDeleted(boolean deleted) {
        this._deleted = deleted;
    }

    public static NevadoDestination getInstance(Destination destination) throws JMSException {
        NevadoDestination nevadoDestination = null;
        if (destination != null) {
            if (destination instanceof NevadoDestination) {
                nevadoDestination = (NevadoDestination)destination;
            } else {
                if (destination instanceof TemporaryQueue) {
                    throw new IllegalStateException("TemporaryQueues cannot be copied");
                }
                if (destination instanceof TemporaryTopic) {
                    throw new IllegalStateException("TemporaryDestinations cannot be copied");
                }
                if (destination instanceof Queue) {
                    nevadoDestination = new NevadoQueue((Queue)destination);
                } else if (destination instanceof Topic) {
                    nevadoDestination = new NevadoTopic((Topic)destination);
                }
            }
        }
        return nevadoDestination;
    }

    @Override
    public Reference getReference() throws NamingException {
        Reference reference = new Reference(this.getClass().getName(), new StringRefAddr(JNDI_DESTINATION_NAME, this._name), NevadoReferencableFactory.class.getName(), null);
        return reference;
    }

    public String toString() {
        return this._name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o != null && (this instanceof NevadoTopic && o instanceof NevadoTopic || this instanceof NevadoDestination && o instanceof NevadoDestination))) {
            return false;
        }
        NevadoDestination that = (NevadoDestination)o;
        return !(this._name != null ? !this._name.equals(that._name) : that._name != null);
    }

    public int hashCode() {
        return this._name != null ? this._name.hashCode() : 0;
    }
}

