/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.nevado.jms.message;

import java.io.IOException;
import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.skyscreamer.nevado.jms.message.NevadoMessage;
import org.skyscreamer.nevado.jms.util.SerializeUtil;

public class NevadoObjectMessage
extends NevadoMessage
implements ObjectMessage {
    private byte[] _bodyBytes;

    public NevadoObjectMessage() {
    }

    protected NevadoObjectMessage(ObjectMessage message) throws JMSException {
        super((Message)message);
        Serializable serializable = message.getObject();
        this.setBodyObject(serializable);
    }

    public void setObject(Serializable serializable) throws JMSException {
        this.checkReadOnlyBody();
        this.setBodyObject(serializable);
    }

    public Serializable getObject() throws JMSException {
        return this.getBodyObject();
    }

    @Override
    public void internalClearBody() throws JMSException {
        this._bodyBytes = null;
    }

    private void setBodyObject(Serializable serializable) throws JMSException {
        if (serializable == null) {
            this._bodyBytes = null;
        } else {
            try {
                this._bodyBytes = SerializeUtil.serialize(serializable);
            }
            catch (IOException e) {
                throw new JMSException("Unable to serialize body object");
            }
        }
    }

    private Serializable getBodyObject() throws JMSException {
        if (this._bodyBytes == null) {
            return null;
        }
        try {
            return SerializeUtil.deserialize(this._bodyBytes);
        }
        catch (IOException e) {
            throw new JMSException("Unable to deserialize body object");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NevadoObjectMessage that = (NevadoObjectMessage)o;
        if (this._messageID != null ? !this._messageID.equals(that._messageID) : that._messageID != null) {
            return false;
        }
        return !(this._bodyBytes != null ? !this._bodyBytes.equals(that._bodyBytes) : that._bodyBytes != null);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this._messageID).append(this._bodyBytes).toHashCode();
    }
}

