/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.nevado.jms.resource;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.skyscreamer.nevado.jms.NevadoConnectionFactory;
import org.skyscreamer.nevado.jms.destination.NevadoQueue;
import org.skyscreamer.nevado.jms.destination.NevadoTopic;

public class NevadoReferencableFactory
implements ObjectFactory {
    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getObjectInstance(Object obj, Name name, Context ctx, Hashtable env) throws Exception {
        void var5_14;
        if (!(obj instanceof Reference)) throw new IllegalArgumentException("Expected object of type Reference");
        Reference ref = (Reference)obj;
        if (ref.getClassName().equals(NevadoConnectionFactory.class.getName())) {
            String jmsTtl;
            String jmsPriority;
            String jmsDeliveryMode;
            NevadoConnectionFactory connectionFactory = new NevadoConnectionFactory();
            connectionFactory.setAwsAccessKey(this.getRefContent(ref, "awsAccessKey"));
            connectionFactory.setAwsSecretKey(this.getRefContent(ref, "awsSecretKey"));
            String clientId = this.getRefContent(ref, "clientID");
            if (clientId != null) {
                connectionFactory.setClientID(clientId);
            }
            if ((jmsDeliveryMode = this.getRefContent(ref, "jmsDeliveryMode")) != null) {
                connectionFactory.setOverrideJMSDeliveryMode(Integer.parseInt(jmsDeliveryMode));
            }
            if ((jmsPriority = this.getRefContent(ref, "jmsPriority")) != null) {
                connectionFactory.setOverrideJMSPriority(Integer.parseInt(jmsPriority));
            }
            if ((jmsTtl = this.getRefContent(ref, "jmsTTL")) != null) {
                connectionFactory.setOverrideJMSTTL(Long.parseLong(jmsTtl));
            }
            NevadoConnectionFactory nevadoConnectionFactory = connectionFactory;
            return var5_14;
        } else if (ref.getClassName().equals(NevadoQueue.class.getName())) {
            NevadoQueue nevadoQueue = new NevadoQueue(this.getRefContent(ref, "name"));
            return var5_14;
        } else {
            if (!ref.getClassName().equals(NevadoTopic.class.getName())) throw new IllegalArgumentException("This factory does not support objects of type " + ref.getClassName());
            NevadoTopic nevadoTopic = new NevadoTopic(this.getRefContent(ref, "name"));
        }
        return var5_14;
    }

    private String getRefContent(Reference ref, String type) {
        RefAddr addr = ref.get(type);
        String content = addr != null ? (String)addr.getContent() : null;
        return content;
    }
}

