/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.nevado.jms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.InvalidClientIDException;
import javax.jms.JMSException;
import javax.jms.ServerSessionPool;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.skyscreamer.nevado.jms.NevadoConnectionMetaData;
import org.skyscreamer.nevado.jms.NevadoSession;
import org.skyscreamer.nevado.jms.connector.SQSConnector;
import org.skyscreamer.nevado.jms.destination.NevadoDestination;
import org.skyscreamer.nevado.jms.destination.NevadoProviderQueuePrefix;
import org.skyscreamer.nevado.jms.destination.NevadoQueue;
import org.skyscreamer.nevado.jms.destination.NevadoTemporaryQueue;
import org.skyscreamer.nevado.jms.destination.NevadoTemporaryTopic;
import org.skyscreamer.nevado.jms.destination.NevadoTopic;

public class NevadoConnection
implements Connection {
    private final Log _log = LogFactory.getLog(this.getClass());
    private final AtomicBoolean _closed = new AtomicBoolean(false);
    private final AtomicBoolean _running = new AtomicBoolean(false);
    protected volatile boolean _inUse = false;
    private final SQSConnector _sqsConnector;
    private volatile String _clientID;
    private volatile String _connectionID = UUID.randomUUID().toString();
    private volatile Integer _jmsDeliveryMode;
    private volatile Long _jmsTTL;
    private volatile Integer _jmsPriority;
    private volatile ExceptionListener _exceptionListener;
    private final List<NevadoSession> _sessions = new CopyOnWriteArrayList<NevadoSession>();
    private final Set<NevadoDestination> _temporaryDestinations = new CopyOnWriteArraySet<NevadoDestination>();

    public NevadoConnection(SQSConnector sqsConnector) throws JMSException {
        this._sqsConnector = sqsConnector;
        this._sqsConnector.test();
    }

    public NevadoSession createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        this.checkClosed();
        this._inUse = true;
        NevadoSession nevadoSession = new NevadoSession(this, transacted, acknowledgeMode);
        this.initializeSession(nevadoSession);
        return nevadoSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeSession(NevadoSession nevadoSession) {
        nevadoSession.setOverrideJMSDeliveryMode(this._jmsDeliveryMode);
        nevadoSession.setOverrideJMSTTL(this._jmsTTL);
        nevadoSession.setOverrideJMSPriority(this._jmsPriority);
        AtomicBoolean atomicBoolean = this._running;
        synchronized (atomicBoolean) {
            this._sessions.add(nevadoSession);
            if (this._running.get()) {
                nevadoSession.start();
            }
        }
    }

    public NevadoConnectionMetaData getMetaData() throws JMSException {
        return NevadoConnectionMetaData.getInstance();
    }

    public ExceptionListener getExceptionListener() {
        return this._exceptionListener;
    }

    public void setExceptionListener(ExceptionListener exceptionListener) throws IllegalStateException {
        this.checkClosed();
        this._exceptionListener = exceptionListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws JMSException {
        this.checkClosed();
        this._inUse = true;
        AtomicBoolean atomicBoolean = this._running;
        synchronized (atomicBoolean) {
            this._running.set(true);
            for (NevadoSession session : this._sessions) {
                session.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws JMSException {
        this.checkClosed();
        AtomicBoolean atomicBoolean = this._running;
        synchronized (atomicBoolean) {
            this._running.set(false);
            for (NevadoSession session : this._sessions) {
                session.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        AtomicBoolean atomicBoolean = this._closed;
        synchronized (atomicBoolean) {
            if (!this._closed.get()) {
                this.stop();
                ArrayList<JMSException> sessionExceptions = new ArrayList<JMSException>();
                for (NevadoSession session : this._sessions) {
                    try {
                        session.close();
                    }
                    catch (JMSException e) {
                        sessionExceptions.add(e);
                        this._log.warn((Object)"Caught exception closing a session.  Will continue trying to clean up, then will throw it up the stack.  (First one if multiple.)", (Throwable)e);
                    }
                }
                for (NevadoDestination temporaryDestination : new ArrayList<NevadoDestination>(this._temporaryDestinations)) {
                    try {
                        if (temporaryDestination instanceof NevadoTemporaryQueue) {
                            this.deleteTemporaryQueue((NevadoTemporaryQueue)temporaryDestination);
                            continue;
                        }
                        if (temporaryDestination instanceof NevadoTemporaryTopic) {
                            this.deleteTemporaryTopic((NevadoTemporaryTopic)temporaryDestination);
                            continue;
                        }
                        throw new IllegalStateException("Unexpected temporary destination of type: " + temporaryDestination.getClass().getName());
                    }
                    catch (JMSException e) {
                        this._log.error((Object)("Unable to delete temporary destination " + temporaryDestination), (Throwable)e);
                    }
                }
                this._temporaryDestinations.clear();
                this._closed.set(true);
                if (sessionExceptions.size() > 0) {
                    throw (JMSException)((Object)sessionExceptions.get(0));
                }
            }
        }
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String s, ServerSessionPool serverSessionPool, int i) throws JMSException {
        this.checkClosed();
        this._inUse = true;
        return null;
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String s, String s1, ServerSessionPool serverSessionPool, int i) throws JMSException {
        this.checkClosed();
        this._inUse = true;
        return null;
    }

    protected NevadoTemporaryTopic createTemporaryTopic() throws JMSException {
        this.checkClosed();
        String tempTopicName = "" + (Object)((Object)NevadoProviderQueuePrefix.TEMPORARY_DESTINATION_PREFIX) + UUID.randomUUID();
        NevadoTopic topic = this.getSQSConnector().createTopic(tempTopicName);
        NevadoTemporaryTopic temporaryTopic = new NevadoTemporaryTopic(this, topic);
        this._temporaryDestinations.add(temporaryTopic);
        return temporaryTopic;
    }

    public void deleteTemporaryTopic(NevadoTemporaryTopic temporaryTopic) throws JMSException {
        this.checkClosed();
        this.deleteTopic(temporaryTopic);
        this._temporaryDestinations.remove(temporaryTopic);
    }

    public void deleteTopic(NevadoTopic topic) throws JMSException {
        this.getSQSConnector().deleteTopic(topic);
        topic.setDeleted(true);
    }

    protected NevadoTemporaryQueue createTemporaryQueue() throws JMSException {
        this.checkClosed();
        String tempQueueName = "" + (Object)((Object)NevadoProviderQueuePrefix.TEMPORARY_DESTINATION_PREFIX) + UUID.randomUUID();
        NevadoQueue queue = this.getSQSConnector().createQueue(tempQueueName);
        NevadoTemporaryQueue temporaryQueue = new NevadoTemporaryQueue(this, queue);
        this._temporaryDestinations.add(temporaryQueue);
        return temporaryQueue;
    }

    public void deleteTemporaryQueue(NevadoTemporaryQueue temporaryQueue) throws JMSException {
        this.checkClosed();
        this.deleteQueue(temporaryQueue);
        this._temporaryDestinations.remove(temporaryQueue);
    }

    protected void deleteQueue(NevadoQueue queue) throws JMSException {
        this._sqsConnector.deleteQueue(queue);
        queue.setDeleted(true);
    }

    protected boolean ownsTemporaryDestination(Destination temporaryDestination) {
        return this._temporaryDestinations.contains(temporaryDestination);
    }

    public Collection<TemporaryQueue> listAllTemporaryQueues() throws JMSException {
        Collection<NevadoQueue> queues = this.getSQSConnector().listQueues((Object)((Object)NevadoProviderQueuePrefix.TEMPORARY_DESTINATION_PREFIX) + "");
        HashSet<TemporaryQueue> temporaryQueues = new HashSet<TemporaryQueue>(queues.size());
        for (NevadoQueue queue : queues) {
            temporaryQueues.add(new NevadoTemporaryQueue(this, queue));
        }
        return temporaryQueues;
    }

    public Collection<TemporaryTopic> listAllTemporaryTopics() throws JMSException {
        Collection<NevadoTopic> topics = this.getSQSConnector().listTopics();
        HashSet<TemporaryTopic> temporaryTopics = new HashSet<TemporaryTopic>(topics.size());
        for (NevadoTopic topic : topics) {
            if (!topic.getTopicName().startsWith((Object)((Object)NevadoProviderQueuePrefix.TEMPORARY_DESTINATION_PREFIX) + "")) continue;
            temporaryTopics.add(new NevadoTemporaryTopic(this, topic));
        }
        return temporaryTopics;
    }

    public String subscribe(NevadoTopic topic, NevadoQueue topicEndpoint) throws JMSException {
        return this.getSQSConnector().subscribe(topic, topicEndpoint);
    }

    public void unsubscribe(NevadoTopic topic) throws JMSException {
        this.getSQSConnector().unsubscribe(topic);
    }

    public SQSConnector getSQSConnector() {
        return this._sqsConnector;
    }

    public String getClientID() {
        return this._clientID;
    }

    public void setClientID(String clientID) throws JMSException {
        this.checkClosed();
        if (clientID == null || clientID.trim().length() == 0) {
            throw new InvalidClientIDException("Client ID is empty");
        }
        if (this._clientID != null) {
            throw new IllegalStateException("Client ID has already been set");
        }
        if (this._inUse) {
            throw new IllegalStateException("Client ID cannot be set after the connection is in use");
        }
        if (clientID != null && !clientID.matches("^[\\w\\-_]+$")) {
            throw new InvalidClientIDException("Client ID can only include alphanumeric characters, hyphens, or underscores");
        }
        this._clientID = clientID;
        this._connectionID = clientID;
    }

    public void setOverrideJMSDeliveryMode(Integer jmsDeliveryMode) throws IllegalStateException {
        this.checkClosed();
        this._jmsDeliveryMode = jmsDeliveryMode;
    }

    public void setOverrideJMSPriority(Integer jmsPriority) throws IllegalStateException {
        this.checkClosed();
        this._jmsPriority = jmsPriority;
    }

    public void setOverrideJMSTTL(Long jmsTTL) throws IllegalStateException {
        this.checkClosed();
        this._jmsTTL = jmsTTL;
    }

    public boolean isRunning() {
        return this._running.get();
    }

    public boolean isClosed() {
        return this._closed.get();
    }

    protected void checkClosed() throws IllegalStateException {
        if (this._closed.get()) {
            throw new IllegalStateException("Connection is closed");
        }
    }

    public String getConnectionID() {
        return this._connectionID;
    }
}

