/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.nevado.jms.connector.mock;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.jms.JMSException;
import org.skyscreamer.nevado.jms.connector.AbstractSQSConnector;
import org.skyscreamer.nevado.jms.connector.mock.MockSQSMessage;
import org.skyscreamer.nevado.jms.connector.mock.MockSQSQueue;
import org.skyscreamer.nevado.jms.destination.NevadoQueue;
import org.skyscreamer.nevado.jms.destination.NevadoTopic;

public class MockSQSConnector
extends AbstractSQSConnector {
    private final Map<NevadoQueue, MockSQSQueue> _mockQueueMap = new HashMap<NevadoQueue, MockSQSQueue>();
    private final Map<NevadoTopic, Collection<MockSQSQueue>> _mockTopicMap = new HashMap<NevadoTopic, Collection<MockSQSQueue>>();

    public MockSQSConnector() {
        this(200L);
    }

    public MockSQSConnector(long receiveCheckIntervalMs) {
        super(receiveCheckIntervalMs);
    }

    @Override
    protected void sendSNSMessage(NevadoTopic topic, String body) throws JMSException {
        this.checkTopicExists(topic);
        body = "{Message:\"" + body + "\"}";
        MockSQSMessage message = new MockSQSMessage(body);
        for (MockSQSQueue queue : this._mockTopicMap.get(topic)) {
            queue.sendMessage(body);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected MockSQSQueue getSQSQueueImpl(NevadoQueue queue) throws JMSException {
        MockSQSQueue mockQueue;
        Map<NevadoQueue, MockSQSQueue> map = this._mockQueueMap;
        synchronized (map) {
            mockQueue = this._mockQueueMap.get(queue);
            if (mockQueue == null) {
                mockQueue = new MockSQSQueue(this, queue);
                this._mockQueueMap.put(queue, mockQueue);
            }
        }
        return mockQueue;
    }

    @Override
    public void test() throws JMSException {
    }

    @Override
    public Collection<NevadoQueue> listQueues(String temporaryQueuePrefix) throws JMSException {
        ArrayList<NevadoQueue> queues = new ArrayList<NevadoQueue>();
        for (NevadoQueue queue : this._mockQueueMap.keySet()) {
            if (!queue.getName().startsWith(temporaryQueuePrefix)) continue;
            queues.add(queue);
        }
        return queues;
    }

    @Override
    public NevadoTopic createTopic(String topicName) throws JMSException {
        NevadoTopic nevadoTopic = new NevadoTopic(topicName);
        this._mockTopicMap.put(nevadoTopic, new HashSet());
        return nevadoTopic;
    }

    @Override
    public void deleteTopic(NevadoTopic topic) throws JMSException {
        this.checkTopicExists(topic);
        this._mockTopicMap.remove(topic);
    }

    @Override
    public Collection<NevadoTopic> listTopics() throws JMSException {
        return this._mockTopicMap.keySet();
    }

    @Override
    public String subscribe(NevadoTopic topic, NevadoQueue topicEndpoint) throws JMSException {
        if (!this._mockTopicMap.containsKey(topic)) {
            this.createTopic(topic.getTopicName());
        }
        MockSQSQueue endpointQueue = this.getSQSQueueImpl(topicEndpoint);
        this._mockTopicMap.get(topic).add(endpointQueue);
        return endpointQueue.getQueueARN();
    }

    @Override
    public void unsubscribe(NevadoTopic topic) throws JMSException {
        Collection<MockSQSQueue> topicEndpoints = this._mockTopicMap.get(topic);
        if (topicEndpoints != null) {
            for (MockSQSQueue endpointQueue : topicEndpoints) {
                if (!endpointQueue.getQueue().equals(topic.getTopicEndpoint())) continue;
                topicEndpoints.remove(endpointQueue);
                break;
            }
        }
    }

    protected void removeQueue(NevadoQueue queue) {
        this._mockQueueMap.remove(queue);
        block0: for (NevadoTopic topic : this._mockTopicMap.keySet()) {
            Collection<MockSQSQueue> topicEndpoints = this._mockTopicMap.get(topic);
            for (MockSQSQueue endpointQueue : topicEndpoints) {
                if (!endpointQueue.getQueue().equals(topic.getTopicEndpoint())) continue;
                topicEndpoints.remove(endpointQueue);
                continue block0;
            }
        }
    }

    private void checkTopicExists(NevadoTopic topic) throws JMSException {
        if (!this._mockTopicMap.containsKey(topic)) {
            throw new JMSException("No such topic: " + topic);
        }
    }
}

