/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.nevado.jms.util;

import com.caucho.hessian.io.Hessian2Input;
import com.caucho.hessian.io.Hessian2Output;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.commons.codec.binary.Base64;
import org.skyscreamer.nevado.jms.util.CharWrapper;

public class SerializeUtil {
    public static Serializable copy(Serializable serializable) throws IOException {
        return SerializeUtil.deserialize(SerializeUtil.serialize(serializable));
    }

    public static String serializeToString(Serializable serializable) throws IOException {
        byte[] data = SerializeUtil.serialize(serializable);
        return new String(Base64.encodeBase64((byte[])data));
    }

    public static byte[] serialize(Serializable serializable) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Hessian2Output hessian2Output = new Hessian2Output((OutputStream)byteArrayOutputStream);
        hessian2Output.startMessage();
        if (serializable instanceof Character) {
            serializable = new CharWrapper((Character)serializable);
        }
        hessian2Output.writeObject((Object)serializable);
        hessian2Output.completeMessage();
        hessian2Output.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static Serializable deserializeFromString(String s) throws IOException {
        byte[] dataBytes = Base64.decodeBase64((byte[])s.getBytes("UTF-8"));
        return SerializeUtil.deserialize(dataBytes);
    }

    public static Serializable deserialize(byte[] dataBytes) throws IOException {
        Hessian2Input hessian2Input = new Hessian2Input((InputStream)new ByteArrayInputStream(dataBytes));
        hessian2Input.startMessage();
        Serializable serializable = (Serializable)hessian2Input.readObject();
        if (serializable instanceof CharWrapper) {
            serializable = Character.valueOf(((CharWrapper)serializable).charValue());
        }
        hessian2Input.completeMessage();
        hessian2Input.close();
        return serializable;
    }
}

