/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.assertion;

import java.util.Collection;
import java.util.Map;

public abstract class AssertArgument {
    public static void isNotNull(Object arg, String argName) throws IllegalArgumentException {
        if (arg == null) {
            throw new IllegalArgumentException("Undefined '" + argName + "' argument in method call.");
        }
    }

    public static void isNotEmpty(String arg, String argName) throws IllegalArgumentException {
        if (arg != null && arg.trim().length() == 0) {
            throw new IllegalArgumentException("Not undefined, but empty '" + argName + "' argument in method call.");
        }
    }

    public static void isNotNullAndNotEmpty(String arg, String argName) throws IllegalArgumentException {
        if (arg == null || arg.trim().length() == 0) {
            throw new IllegalArgumentException("Undefined or empty '" + argName + "' argument in method call.");
        }
    }

    public static void isNotNullAndNotEmpty(Object[] arg, String argName) throws IllegalArgumentException {
        if (arg == null || arg.length == 0) {
            throw new IllegalArgumentException("Undefined or empty '" + argName + "' argument in method call.");
        }
    }

    public static void isNotNullAndNotEmpty(Collection<?> arg, String argName) throws IllegalArgumentException {
        if (arg == null || arg.isEmpty()) {
            throw new IllegalArgumentException("Undefined or empty '" + argName + "' argument in method call.");
        }
    }

    public static void isNotNullAndNotEmpty(Map<?, ?> arg, String argName) throws IllegalArgumentException {
        if (arg == null || arg.isEmpty()) {
            throw new IllegalArgumentException("Undefined or empty '" + argName + "' argument in method call.");
        }
    }

    public static void isInstanceOf(Object arg, Class<?> clazz, String argName) throws IllegalArgumentException {
        if (clazz.isAssignableFrom(arg.getClass())) {
            throw new IllegalArgumentException("Argument '" + argName + "' is not an instance of '" + clazz.getName() + "'.");
        }
    }
}

