/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.thread;

import java.util.EmptyStackException;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StackedThreadLocal<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(StackedThreadLocal.class);
    private final String resourceName;
    private final ThreadLocal<Stack<T>> stackTL = new ThreadLocal();

    public StackedThreadLocal(String resourceName) {
        this.resourceName = resourceName;
    }

    public T get() {
        Stack<T> execContextStack = this.getExecutionContextStack();
        try {
            return execContextStack.peek();
        }
        catch (EmptyStackException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("No currently stacked '" + this.resourceName + "' instance on active Thread.", (Throwable)e);
            }
            return null;
        }
    }

    public void set(T value) {
        Stack<T> execContextStack = this.getExecutionContextStack();
        execContextStack.push(value);
    }

    public void remove() {
        block2: {
            Stack<T> execContextStack = this.getExecutionContextStack();
            try {
                execContextStack.pop();
            }
            catch (EmptyStackException e) {
                if (!LOGGER.isDebugEnabled()) break block2;
                LOGGER.debug("No currently stacked '" + this.resourceName + "' instance on active Thread.", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Stack<T> getExecutionContextStack() {
        Stack<Object> stack = this.stackTL.get();
        if (stack == null) {
            StackedThreadLocal stackedThreadLocal = this;
            synchronized (stackedThreadLocal) {
                stack = this.stackTL.get();
                if (stack == null) {
                    stack = new Stack();
                    this.stackTL.set(stack);
                }
            }
        }
        return stack;
    }
}

