/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.sensor.highlighting.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.api.batch.sensor.highlighting.NewHighlighting;
import org.sonar.api.batch.sensor.highlighting.TypeOfText;
import org.sonar.api.batch.sensor.highlighting.internal.SyntaxHighlightingRule;
import org.sonar.api.batch.sensor.internal.DefaultStorable;
import org.sonar.api.batch.sensor.internal.SensorStorage;
import org.sonar.api.internal.google.common.base.Preconditions;

public class DefaultHighlighting
extends DefaultStorable
implements NewHighlighting {
    private final List<SyntaxHighlightingRule> syntaxHighlightingRules = new ArrayList<SyntaxHighlightingRule>();
    private DefaultInputFile inputFile;

    public DefaultHighlighting(SensorStorage storage) {
        super(storage);
    }

    public List<SyntaxHighlightingRule> getSyntaxHighlightingRuleSet() {
        return this.syntaxHighlightingRules;
    }

    private void checkOverlappingBoudaries() {
        if (this.syntaxHighlightingRules.size() > 1) {
            Iterator<SyntaxHighlightingRule> it = this.syntaxHighlightingRules.iterator();
            SyntaxHighlightingRule previous = it.next();
            while (it.hasNext()) {
                SyntaxHighlightingRule current = it.next();
                if (previous.range().end().compareTo(current.range().start()) > 0 && previous.range().end().compareTo(current.range().end()) < 0) {
                    String errorMsg = String.format("Cannot register highlighting rule for characters at %s as it overlaps at least one existing rule", current.range());
                    throw new IllegalStateException(errorMsg);
                }
                previous = current;
            }
        }
    }

    @Override
    public DefaultHighlighting onFile(InputFile inputFile) {
        Preconditions.checkNotNull(inputFile, "file can't be null");
        this.inputFile = (DefaultInputFile)inputFile;
        return this;
    }

    public InputFile inputFile() {
        return this.inputFile;
    }

    @Override
    public DefaultHighlighting highlight(int startOffset, int endOffset, TypeOfText typeOfText) {
        TextRange newRange;
        Preconditions.checkState(this.inputFile != null, "Call onFile() first");
        try {
            newRange = this.inputFile.newRange(startOffset, endOffset);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to highlight file " + this.inputFile + " from offset " + startOffset + " to offset " + endOffset, e);
        }
        SyntaxHighlightingRule syntaxHighlightingRule = SyntaxHighlightingRule.create(newRange, typeOfText);
        this.syntaxHighlightingRules.add(syntaxHighlightingRule);
        return this;
    }

    @Override
    protected void doSave() {
        Preconditions.checkState(this.inputFile != null, "Call onFile() first");
        Collections.sort(this.syntaxHighlightingRules, new Comparator<SyntaxHighlightingRule>(){

            @Override
            public int compare(SyntaxHighlightingRule left, SyntaxHighlightingRule right) {
                int result = left.range().start().compareTo(right.range().start());
                if (result == 0) {
                    result = right.range().end().compareTo(left.range().end());
                }
                return result;
            }
        });
        this.checkOverlappingBoudaries();
        this.storage.store(this);
    }
}

