/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.sensor.issue.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.api.batch.rule.Severity;
import org.sonar.api.batch.sensor.internal.DefaultStorable;
import org.sonar.api.batch.sensor.internal.SensorStorage;
import org.sonar.api.batch.sensor.issue.Issue;
import org.sonar.api.batch.sensor.issue.IssueLocation;
import org.sonar.api.batch.sensor.issue.NewIssue;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.api.batch.sensor.issue.internal.DefaultIssueLocation;
import org.sonar.api.internal.google.common.base.Function;
import org.sonar.api.internal.google.common.base.Preconditions;
import org.sonar.api.internal.google.common.collect.ImmutableList;
import org.sonar.api.internal.google.common.collect.Lists;
import org.sonar.api.rule.RuleKey;

public class DefaultIssue
extends DefaultStorable
implements Issue,
NewIssue {
    private RuleKey ruleKey;
    private Double effortToFix;
    private Severity overriddenSeverity;
    private IssueLocation primaryLocation;
    private List<List<IssueLocation>> flows = new ArrayList<List<IssueLocation>>();

    public DefaultIssue() {
        super(null);
    }

    public DefaultIssue(SensorStorage storage) {
        super(storage);
    }

    @Override
    public DefaultIssue forRule(RuleKey ruleKey) {
        this.ruleKey = ruleKey;
        return this;
    }

    @Override
    public DefaultIssue effortToFix(@Nullable Double effortToFix) {
        Preconditions.checkArgument(effortToFix == null || effortToFix >= 0.0, String.format("Effort to fix must be greater than or equal 0 (got %s)", effortToFix));
        this.effortToFix = effortToFix;
        return this;
    }

    @Override
    public DefaultIssue overrideSeverity(@Nullable Severity severity) {
        this.overriddenSeverity = severity;
        return this;
    }

    @Override
    public NewIssueLocation newLocation() {
        return new DefaultIssueLocation();
    }

    @Override
    public DefaultIssue at(NewIssueLocation primaryLocation) {
        Preconditions.checkArgument(primaryLocation != null, "Cannot use a location that is null");
        Preconditions.checkState(this.primaryLocation == null, "at() already called");
        this.primaryLocation = (DefaultIssueLocation)primaryLocation;
        return this;
    }

    @Override
    public NewIssue addLocation(NewIssueLocation secondaryLocation) {
        this.flows.add(Arrays.asList((IssueLocation)((Object)secondaryLocation)));
        return this;
    }

    @Override
    public DefaultIssue addFlow(Iterable<NewIssueLocation> locations) {
        ArrayList<DefaultIssueLocation> flowAsList = new ArrayList<DefaultIssueLocation>();
        for (NewIssueLocation issueLocation : locations) {
            flowAsList.add((DefaultIssueLocation)issueLocation);
        }
        this.flows.add(flowAsList);
        return this;
    }

    @Override
    public RuleKey ruleKey() {
        return this.ruleKey;
    }

    @Override
    public Severity overriddenSeverity() {
        return this.overriddenSeverity;
    }

    @Override
    public Double effortToFix() {
        return this.effortToFix;
    }

    @Override
    public IssueLocation primaryLocation() {
        return this.primaryLocation;
    }

    @Override
    public List<Issue.Flow> flows() {
        return Lists.transform(this.flows, new ToFlow());
    }

    @Override
    public void doSave() {
        Preconditions.checkNotNull(this.ruleKey, "ruleKey is mandatory on issue");
        Preconditions.checkState(this.primaryLocation != null, "Primary location is mandatory on every issue");
        this.storage.store(this);
    }

    private static final class ToFlow
    implements Function<List<IssueLocation>, Issue.Flow> {
        private ToFlow() {
        }

        @Override
        public Issue.Flow apply(final List<IssueLocation> input) {
            return new Issue.Flow(){

                @Override
                public List<IssueLocation> locations() {
                    return ImmutableList.copyOf(input);
                }
            };
        }
    }
}

