/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.measures;

import java.util.Collections;
import java.util.List;
import org.sonar.api.measures.Formula;
import org.sonar.api.measures.FormulaContext;
import org.sonar.api.measures.FormulaData;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.MeasureUtils;
import org.sonar.api.measures.Metric;

@Deprecated
public class WeightedMeanAggregationFormula
implements Formula {
    private Metric weightingMetric;
    private boolean zeroIfNoValues = false;

    public WeightedMeanAggregationFormula(Metric weightingMetric, boolean zeroIfNoValues) {
        this.weightingMetric = weightingMetric;
        if (weightingMetric == null) {
            throw new IllegalArgumentException("Metric can not be null");
        }
        this.zeroIfNoValues = zeroIfNoValues;
    }

    @Override
    public List<Metric> dependsUponMetrics() {
        return Collections.emptyList();
    }

    @Override
    public Measure calculate(FormulaData data, FormulaContext context) {
        double sum = 0.0;
        double count = 0.0;
        boolean hasValue = false;
        for (FormulaData child : data.getChildren()) {
            Measure weightingMeasure;
            Measure measure = child.getMeasure(context.getTargetMetric());
            if (!MeasureUtils.haveValues(measure, weightingMeasure = child.getMeasure(this.weightingMetric))) continue;
            sum += measure.getValue() * weightingMeasure.getValue();
            count += weightingMeasure.getValue().doubleValue();
            hasValue = true;
        }
        if (!hasValue && !this.zeroIfNoValues) {
            return null;
        }
        double result = Double.doubleToRawLongBits(count) == 0L ? 0.0 : sum / count;
        return new Measure(context.getTargetMetric(), result);
    }
}

