/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.ce.posttask;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.ce.posttask.CeTask;
import org.sonar.api.ce.posttask.PostProjectAnalysisTask;
import org.sonar.api.ce.posttask.Project;
import org.sonar.api.ce.posttask.QualityGate;
import org.sonar.api.internal.google.common.annotations.Beta;
import org.sonar.api.internal.google.common.base.Preconditions;

@Beta
public class PostProjectAnalysisTaskTester {
    private static final String DATE_CAN_NOT_BE_NULL = "date cannot be null";
    private static final String PROJECT_CAN_NOT_BE_NULL = "project cannot be null";
    private static final String CE_TASK_CAN_NOT_BE_NULL = "ceTask cannot be null";
    private static final String STATUS_CAN_NOT_BE_NULL = "status cannot be null";
    private final PostProjectAnalysisTask underTest;
    @CheckForNull
    private CeTask ceTask;
    @CheckForNull
    private Project project;
    @CheckForNull
    private Date date;
    @CheckForNull
    private QualityGate qualityGate;

    private PostProjectAnalysisTaskTester(PostProjectAnalysisTask underTest) {
        this.underTest = Objects.requireNonNull(underTest, "PostProjectAnalysisTask instance cannot be null");
    }

    public static PostProjectAnalysisTaskTester of(PostProjectAnalysisTask underTest) {
        return new PostProjectAnalysisTaskTester(underTest);
    }

    public static CeTaskBuilder newCeTaskBuilder() {
        return new CeTaskBuilder();
    }

    public static ProjectBuilder newProjectBuilder() {
        return new ProjectBuilder();
    }

    public static QualityGateBuilder newQualityGateBuilder() {
        return new QualityGateBuilder();
    }

    public static ConditionBuilder newConditionBuilder() {
        return new ConditionBuilder();
    }

    public PostProjectAnalysisTaskTester withCeTask(CeTask ceTask) {
        this.ceTask = Objects.requireNonNull(ceTask, CE_TASK_CAN_NOT_BE_NULL);
        return this;
    }

    public PostProjectAnalysisTaskTester withProject(Project project) {
        this.project = Objects.requireNonNull(project, PROJECT_CAN_NOT_BE_NULL);
        return this;
    }

    public PostProjectAnalysisTaskTester at(Date date) {
        this.date = Objects.requireNonNull(date, DATE_CAN_NOT_BE_NULL);
        return this;
    }

    public PostProjectAnalysisTaskTester withQualityGate(@Nullable QualityGate qualityGate) {
        this.qualityGate = qualityGate;
        return this;
    }

    public void execute() {
        this.ceTask = Objects.requireNonNull(this.ceTask, CE_TASK_CAN_NOT_BE_NULL);
        this.project = Objects.requireNonNull(this.project, PROJECT_CAN_NOT_BE_NULL);
        this.date = Objects.requireNonNull(this.date, DATE_CAN_NOT_BE_NULL);
        this.underTest.finished(new PostProjectAnalysisTask.ProjectAnalysis(){

            @Override
            public CeTask getCeTask() {
                return PostProjectAnalysisTaskTester.this.ceTask;
            }

            @Override
            public Project getProject() {
                return PostProjectAnalysisTaskTester.this.project;
            }

            @Override
            public QualityGate getQualityGate() {
                return PostProjectAnalysisTaskTester.this.qualityGate;
            }

            @Override
            public Date getDate() {
                return PostProjectAnalysisTaskTester.this.date;
            }

            public String toString() {
                return "ProjectAnalysis{ceTask=" + PostProjectAnalysisTaskTester.this.ceTask + ", project=" + PostProjectAnalysisTaskTester.this.project + ", date=" + PostProjectAnalysisTaskTester.this.date.getTime() + ", qualityGate=" + PostProjectAnalysisTaskTester.this.qualityGate + '}';
            }
        });
    }

    @Beta
    public static final class ConditionBuilder {
        private static final String METRIC_KEY_CAN_NOT_BE_NULL = "metricKey cannot be null";
        private static final String OPERATOR_CAN_NOT_BE_NULL = "operator cannot be null";
        private String metricKey;
        private QualityGate.Operator operator;
        private String errorThreshold;
        private String warningThreshold;
        private boolean onLeakPeriod;

        private ConditionBuilder() {
        }

        public ConditionBuilder setMetricKey(String metricKey) {
            this.metricKey = Objects.requireNonNull(metricKey, METRIC_KEY_CAN_NOT_BE_NULL);
            return this;
        }

        public ConditionBuilder setOperator(QualityGate.Operator operator) {
            this.operator = Objects.requireNonNull(operator, OPERATOR_CAN_NOT_BE_NULL);
            return this;
        }

        public ConditionBuilder setErrorThreshold(@Nullable String errorThreshold) {
            this.errorThreshold = errorThreshold;
            return this;
        }

        public ConditionBuilder setWarningThreshold(@Nullable String warningThreshold) {
            this.warningThreshold = warningThreshold;
            return this;
        }

        public ConditionBuilder setOnLeakPeriod(boolean onLeakPeriod) {
            this.onLeakPeriod = onLeakPeriod;
            return this;
        }

        public QualityGate.Condition buildNoValue() {
            this.checkCommonProperties();
            return new QualityGate.Condition(){

                @Override
                public QualityGate.EvaluationStatus getStatus() {
                    return QualityGate.EvaluationStatus.NO_VALUE;
                }

                @Override
                public String getMetricKey() {
                    return ConditionBuilder.this.metricKey;
                }

                @Override
                public QualityGate.Operator getOperator() {
                    return ConditionBuilder.this.operator;
                }

                @Override
                public String getErrorThreshold() {
                    return ConditionBuilder.this.errorThreshold;
                }

                @Override
                public String getWarningThreshold() {
                    return ConditionBuilder.this.warningThreshold;
                }

                @Override
                public boolean isOnLeakPeriod() {
                    return ConditionBuilder.this.onLeakPeriod;
                }

                @Override
                public String getValue() {
                    throw new IllegalStateException("There is no value when status is NO_VALUE");
                }

                public String toString() {
                    return "Condition{status=" + (Object)((Object)QualityGate.EvaluationStatus.NO_VALUE) + ", metricKey='" + ConditionBuilder.this.metricKey + '\'' + ", operator=" + (Object)((Object)ConditionBuilder.this.operator) + ", errorThreshold='" + ConditionBuilder.this.errorThreshold + '\'' + ", warningThreshold='" + ConditionBuilder.this.warningThreshold + '\'' + ", onLeakPeriod=" + ConditionBuilder.this.onLeakPeriod + '}';
                }
            };
        }

        public QualityGate.Condition build(final QualityGate.EvaluationStatus status, final String value) {
            this.checkCommonProperties();
            Objects.requireNonNull(status, PostProjectAnalysisTaskTester.STATUS_CAN_NOT_BE_NULL);
            Preconditions.checkArgument(status != QualityGate.EvaluationStatus.NO_VALUE, "status cannot be NO_VALUE, use method buildNoValue() instead");
            Objects.requireNonNull(value, "value cannot be null, use method buildNoValue() instead");
            return new QualityGate.Condition(){

                @Override
                public QualityGate.EvaluationStatus getStatus() {
                    return status;
                }

                @Override
                public String getMetricKey() {
                    return ConditionBuilder.this.metricKey;
                }

                @Override
                public QualityGate.Operator getOperator() {
                    return ConditionBuilder.this.operator;
                }

                @Override
                public String getErrorThreshold() {
                    return ConditionBuilder.this.errorThreshold;
                }

                @Override
                public String getWarningThreshold() {
                    return ConditionBuilder.this.warningThreshold;
                }

                @Override
                public boolean isOnLeakPeriod() {
                    return ConditionBuilder.this.onLeakPeriod;
                }

                @Override
                public String getValue() {
                    return value;
                }

                public String toString() {
                    return "Condition{status=" + (Object)((Object)status) + ", metricKey='" + ConditionBuilder.this.metricKey + '\'' + ", operator=" + (Object)((Object)ConditionBuilder.this.operator) + ", errorThreshold='" + ConditionBuilder.this.errorThreshold + '\'' + ", warningThreshold='" + ConditionBuilder.this.warningThreshold + '\'' + ", onLeakPeriod=" + ConditionBuilder.this.onLeakPeriod + ", value='" + value + '\'' + '}';
                }
            };
        }

        private void checkCommonProperties() {
            Objects.requireNonNull(this.metricKey, METRIC_KEY_CAN_NOT_BE_NULL);
            Objects.requireNonNull(this.operator, OPERATOR_CAN_NOT_BE_NULL);
            Preconditions.checkState(this.errorThreshold != null || this.warningThreshold != null, "At least one of errorThreshold and warningThreshold must be non null");
        }
    }

    @Beta
    public static final class QualityGateBuilder {
        private static final String ID_CAN_NOT_BE_NULL = "id cannot be null";
        private static final String NAME_CAN_NOT_BE_NULL = "name cannot be null";
        private String id;
        private String name;
        private QualityGate.Status status;
        private final List<QualityGate.Condition> conditions = new ArrayList<QualityGate.Condition>();

        private QualityGateBuilder() {
        }

        public QualityGateBuilder setId(String id) {
            this.id = Objects.requireNonNull(id, ID_CAN_NOT_BE_NULL);
            return this;
        }

        public QualityGateBuilder setName(String name) {
            this.name = Objects.requireNonNull(name, NAME_CAN_NOT_BE_NULL);
            return this;
        }

        public QualityGateBuilder setStatus(QualityGate.Status status) {
            this.status = Objects.requireNonNull(status, PostProjectAnalysisTaskTester.STATUS_CAN_NOT_BE_NULL);
            return this;
        }

        public QualityGateBuilder add(QualityGate.Condition condition) {
            this.conditions.add(Objects.requireNonNull(condition, "condition cannot be null"));
            return this;
        }

        public QualityGateBuilder clearConditions() {
            this.conditions.clear();
            return this;
        }

        public QualityGate build() {
            Objects.requireNonNull(this.id, ID_CAN_NOT_BE_NULL);
            Objects.requireNonNull(this.name, NAME_CAN_NOT_BE_NULL);
            Objects.requireNonNull(this.status, PostProjectAnalysisTaskTester.STATUS_CAN_NOT_BE_NULL);
            return new QualityGate(){

                @Override
                public String getId() {
                    return QualityGateBuilder.this.id;
                }

                @Override
                public String getName() {
                    return QualityGateBuilder.this.name;
                }

                @Override
                public QualityGate.Status getStatus() {
                    return QualityGateBuilder.this.status;
                }

                @Override
                public Collection<QualityGate.Condition> getConditions() {
                    return QualityGateBuilder.this.conditions;
                }

                public String toString() {
                    return "QualityGate{id='" + QualityGateBuilder.this.id + '\'' + ", name='" + QualityGateBuilder.this.name + '\'' + ", status=" + (Object)((Object)QualityGateBuilder.this.status) + ", conditions=" + QualityGateBuilder.this.conditions + '}';
                }
            };
        }
    }

    @Beta
    public static final class ProjectBuilder {
        private static final String UUID_CAN_NOT_BE_NULL = "uuid cannot be null";
        private static final String KEY_CAN_NOT_BE_NULL = "key cannot be null";
        private static final String NAME_CAN_NOT_BE_NULL = "name cannot be null";
        private String uuid;
        private String key;
        private String name;

        private ProjectBuilder() {
        }

        public ProjectBuilder setUuid(String uuid) {
            this.uuid = Objects.requireNonNull(uuid, UUID_CAN_NOT_BE_NULL);
            return this;
        }

        public ProjectBuilder setKey(String key) {
            this.key = Objects.requireNonNull(key, KEY_CAN_NOT_BE_NULL);
            return this;
        }

        public ProjectBuilder setName(String name) {
            this.name = Objects.requireNonNull(name, NAME_CAN_NOT_BE_NULL);
            return this;
        }

        public Project build() {
            Objects.requireNonNull(this.uuid, UUID_CAN_NOT_BE_NULL);
            Objects.requireNonNull(this.key, KEY_CAN_NOT_BE_NULL);
            Objects.requireNonNull(this.name, NAME_CAN_NOT_BE_NULL);
            return new Project(){

                @Override
                public String getUuid() {
                    return ProjectBuilder.this.uuid;
                }

                @Override
                public String getKey() {
                    return ProjectBuilder.this.key;
                }

                @Override
                public String getName() {
                    return ProjectBuilder.this.name;
                }

                public String toString() {
                    return "Project{uuid='" + ProjectBuilder.this.uuid + '\'' + ", key='" + ProjectBuilder.this.key + '\'' + ", name='" + ProjectBuilder.this.name + '\'' + '}';
                }
            };
        }
    }

    @Beta
    public static final class CeTaskBuilder {
        private static final String ID_CAN_NOT_BE_NULL = "id cannot be null";
        @CheckForNull
        private String id;
        @CheckForNull
        private CeTask.Status status;

        private CeTaskBuilder() {
        }

        public CeTaskBuilder setId(String id) {
            this.id = Objects.requireNonNull(id, ID_CAN_NOT_BE_NULL);
            return this;
        }

        public CeTaskBuilder setStatus(CeTask.Status status) {
            this.status = Objects.requireNonNull(status, PostProjectAnalysisTaskTester.STATUS_CAN_NOT_BE_NULL);
            return this;
        }

        public CeTask build() {
            Objects.requireNonNull(this.id, ID_CAN_NOT_BE_NULL);
            Objects.requireNonNull(this.status, PostProjectAnalysisTaskTester.STATUS_CAN_NOT_BE_NULL);
            return new CeTask(){

                @Override
                public String getId() {
                    return CeTaskBuilder.this.id;
                }

                @Override
                public CeTask.Status getStatus() {
                    return CeTaskBuilder.this.status;
                }

                public String toString() {
                    return "CeTask{id='" + CeTaskBuilder.this.id + '\'' + ", status=" + (Object)((Object)CeTaskBuilder.this.status) + '}';
                }
            };
        }
    }
}

