/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.measures;

import java.util.Map;
import org.sonar.api.internal.apachecommons.lang.StringUtils;
import org.sonar.api.internal.apachecommons.lang.math.NumberUtils;
import org.sonar.api.internal.google.common.collect.Multiset;
import org.sonar.api.internal.google.common.collect.TreeMultiset;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.MeasureBuilder;
import org.sonar.api.measures.Metric;
import org.sonar.api.measures.MultisetDistributionFormat;
import org.sonar.api.utils.KeyValueFormat;
import org.sonar.api.utils.SonarException;

public class CountDistributionBuilder
implements MeasureBuilder {
    private final Metric metric;
    private final Multiset countBag = TreeMultiset.create();

    public CountDistributionBuilder(Metric metric) {
        if (metric == null || !metric.isDataType()) {
            throw new SonarException("Metric is null or has invalid type");
        }
        this.metric = metric;
    }

    public CountDistributionBuilder add(Object value, int count) {
        if (count == 0) {
            this.addZero(value);
        } else if (this.countBag.add(value, count) == 0) {
            this.countBag.add(value, 1);
        }
        return this;
    }

    public CountDistributionBuilder add(Object value) {
        return this.add(value, 1);
    }

    public CountDistributionBuilder addZero(Object value) {
        if (!this.countBag.contains(value)) {
            this.countBag.add(value, 1);
        }
        return this;
    }

    public CountDistributionBuilder add(Measure measure) {
        if (measure != null && measure.getData() != null) {
            Map<String, String> map = KeyValueFormat.parse(measure.getData());
            for (Map.Entry<String, String> entry : map.entrySet()) {
                int value;
                String key = entry.getKey();
                int n = value = StringUtils.isBlank(entry.getValue()) ? 0 : Integer.parseInt(entry.getValue());
                if (NumberUtils.isNumber(key)) {
                    this.add(NumberUtils.toInt(key), value);
                    continue;
                }
                this.add(key, value);
            }
        }
        return this;
    }

    public boolean isEmpty() {
        return this.countBag.isEmpty();
    }

    public CountDistributionBuilder clear() {
        this.countBag.clear();
        return this;
    }

    @Override
    public Measure build() {
        return this.build(true);
    }

    public Measure build(boolean allowEmptyData) {
        if (!this.isEmpty() || allowEmptyData) {
            return new Measure(this.metric, MultisetDistributionFormat.format(this.countBag));
        }
        return null;
    }
}

