/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.sensor.cpd.internal;

import java.util.List;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.api.batch.fs.internal.PathPattern;
import org.sonar.api.batch.sensor.cpd.NewCpdTokens;
import org.sonar.api.batch.sensor.internal.DefaultStorable;
import org.sonar.api.batch.sensor.internal.SensorStorage;
import org.sonar.api.config.Settings;
import org.sonar.api.internal.google.common.base.Preconditions;
import org.sonar.api.internal.google.common.collect.ImmutableList;
import org.sonar.duplications.internal.pmd.TokensLine;

public class DefaultCpdTokens
extends DefaultStorable
implements NewCpdTokens {
    private final Settings settings;
    private final ImmutableList.Builder<TokensLine> result = ImmutableList.builder();
    private DefaultInputFile inputFile;
    private int startLine = Integer.MIN_VALUE;
    private int startIndex = 0;
    private int currentIndex = 0;
    private StringBuilder sb = new StringBuilder();
    private TextRange lastRange;
    private boolean excluded;

    public DefaultCpdTokens(Settings settings, SensorStorage storage) {
        super(storage);
        this.settings = settings;
    }

    @Override
    public DefaultCpdTokens onFile(InputFile inputFile) {
        Preconditions.checkNotNull(inputFile, "file can't be null");
        this.inputFile = (DefaultInputFile)inputFile;
        String language = inputFile.language();
        if (language != null && this.isSkipped(language)) {
            this.excluded = true;
        } else {
            String[] cpdExclusions = this.settings.getStringArray("sonar.cpd.exclusions");
            for (PathPattern cpdExclusion : PathPattern.create(cpdExclusions)) {
                if (!cpdExclusion.match(inputFile)) continue;
                this.excluded = true;
            }
        }
        return this;
    }

    boolean isSkipped(String language) {
        String key = "sonar.cpd." + language + ".skip";
        if (this.settings.hasKey(key)) {
            return this.settings.getBoolean(key);
        }
        return this.settings.getBoolean("sonar.cpd.skip");
    }

    public InputFile inputFile() {
        return this.inputFile;
    }

    @Override
    public NewCpdTokens addToken(int startLine, int startLineOffset, int endLine, int endLineOffset, String image) {
        TextRange newRange;
        this.checkInputFileNotNull();
        try {
            newRange = this.inputFile.newRange(startLine, startLineOffset, endLine, endLineOffset);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to register token in file " + this.inputFile, e);
        }
        return this.addToken(newRange, image);
    }

    @Override
    public DefaultCpdTokens addToken(TextRange range, String image) {
        Preconditions.checkNotNull(range, "Range should not be null");
        Preconditions.checkNotNull(image, "Image should not be null");
        this.checkInputFileNotNull();
        if (this.excluded) {
            return this;
        }
        Preconditions.checkState(this.lastRange == null || this.lastRange.end().compareTo(range.start()) <= 0, "Tokens of file %s should be provided in order.\nPrevious token: %s\nLast token: %s", this.inputFile, this.lastRange, range);
        String value = image;
        int line = range.start().line();
        if (line != this.startLine) {
            DefaultCpdTokens.addNewTokensLine(this.result, this.startIndex, this.currentIndex, this.startLine, this.sb);
            this.startIndex = this.currentIndex + 1;
            this.startLine = line;
        }
        ++this.currentIndex;
        this.sb.append(value);
        this.lastRange = range;
        return this;
    }

    public List<TokensLine> getTokenLines() {
        return this.result.build();
    }

    private static void addNewTokensLine(ImmutableList.Builder<TokensLine> result, int startUnit, int endUnit, int startLine, StringBuilder sb) {
        if (sb.length() != 0) {
            result.add((Object)new TokensLine(startUnit, endUnit, startLine, sb.toString()));
            sb.setLength(0);
        }
    }

    @Override
    protected void doSave() {
        Preconditions.checkState(this.inputFile != null, "Call onFile() first");
        if (this.excluded) {
            return;
        }
        DefaultCpdTokens.addNewTokensLine(this.result, this.startIndex, this.currentIndex, this.startLine, this.sb);
        this.storage.store(this);
    }

    private void checkInputFileNotNull() {
        Preconditions.checkState(this.inputFile != null, "Call onFile() first");
    }
}

