/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.sensor.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import org.sonar.api.batch.sensor.coverage.CoverageType;
import org.sonar.api.batch.sensor.coverage.internal.DefaultCoverage;
import org.sonar.api.batch.sensor.cpd.internal.DefaultCpdTokens;
import org.sonar.api.batch.sensor.highlighting.internal.DefaultHighlighting;
import org.sonar.api.batch.sensor.internal.SensorStorage;
import org.sonar.api.batch.sensor.issue.Issue;
import org.sonar.api.batch.sensor.measure.Measure;
import org.sonar.api.batch.sensor.symbol.internal.DefaultSymbolTable;
import org.sonar.api.internal.google.common.collect.HashBasedTable;
import org.sonar.api.internal.google.common.collect.Table;

class InMemorySensorStorage
implements SensorStorage {
    Table<String, String, Measure> measuresByComponentAndMetric = HashBasedTable.create();
    Collection<Issue> allIssues = new ArrayList<Issue>();
    Map<String, DefaultHighlighting> highlightingByComponent = new HashMap<String, DefaultHighlighting>();
    Map<String, DefaultCpdTokens> cpdTokensByComponent = new HashMap<String, DefaultCpdTokens>();
    Map<String, Map<CoverageType, DefaultCoverage>> coverageByComponent = new HashMap<String, Map<CoverageType, DefaultCoverage>>();
    Map<String, DefaultSymbolTable> symbolsPerComponent = new HashMap<String, DefaultSymbolTable>();

    InMemorySensorStorage() {
    }

    @Override
    public void store(Measure measure) {
        this.measuresByComponentAndMetric.row(measure.inputComponent().key()).put(measure.metric().key(), measure);
    }

    @Override
    public void store(Issue issue) {
        this.allIssues.add(issue);
    }

    @Override
    public void store(DefaultHighlighting highlighting) {
        this.highlightingByComponent.put(highlighting.inputFile().key(), highlighting);
    }

    @Override
    public void store(DefaultCoverage defaultCoverage) {
        String key = defaultCoverage.inputFile().key();
        if (!this.coverageByComponent.containsKey(key)) {
            this.coverageByComponent.put(key, new EnumMap(CoverageType.class));
        }
        this.coverageByComponent.get(key).put(defaultCoverage.type(), defaultCoverage);
    }

    @Override
    public void store(DefaultCpdTokens defaultCpdTokens) {
        this.cpdTokensByComponent.put(defaultCpdTokens.inputFile().key(), defaultCpdTokens);
    }

    @Override
    public void store(DefaultSymbolTable symbolTable) {
        this.symbolsPerComponent.put(symbolTable.inputFile().key(), symbolTable);
    }
}

