/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.sensor.internal;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.sonar.api.SonarQubeVersion;
import org.sonar.api.batch.fs.InputModule;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.api.batch.fs.internal.DefaultFileSystem;
import org.sonar.api.batch.fs.internal.DefaultInputModule;
import org.sonar.api.batch.fs.internal.DefaultTextPointer;
import org.sonar.api.batch.rule.ActiveRules;
import org.sonar.api.batch.rule.internal.ActiveRulesBuilder;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.coverage.CoverageType;
import org.sonar.api.batch.sensor.coverage.NewCoverage;
import org.sonar.api.batch.sensor.coverage.internal.DefaultCoverage;
import org.sonar.api.batch.sensor.cpd.NewCpdTokens;
import org.sonar.api.batch.sensor.cpd.internal.DefaultCpdTokens;
import org.sonar.api.batch.sensor.highlighting.NewHighlighting;
import org.sonar.api.batch.sensor.highlighting.TypeOfText;
import org.sonar.api.batch.sensor.highlighting.internal.DefaultHighlighting;
import org.sonar.api.batch.sensor.highlighting.internal.SyntaxHighlightingRule;
import org.sonar.api.batch.sensor.internal.InMemorySensorStorage;
import org.sonar.api.batch.sensor.issue.Issue;
import org.sonar.api.batch.sensor.issue.NewIssue;
import org.sonar.api.batch.sensor.issue.internal.DefaultIssue;
import org.sonar.api.batch.sensor.measure.Measure;
import org.sonar.api.batch.sensor.measure.NewMeasure;
import org.sonar.api.batch.sensor.measure.internal.DefaultMeasure;
import org.sonar.api.batch.sensor.symbol.NewSymbolTable;
import org.sonar.api.batch.sensor.symbol.internal.DefaultSymbolTable;
import org.sonar.api.config.Settings;
import org.sonar.api.internal.SonarQubeVersionFactory;
import org.sonar.api.internal.google.common.annotations.Beta;
import org.sonar.api.measures.Metric;
import org.sonar.api.utils.System2;
import org.sonar.api.utils.Version;
import org.sonar.duplications.internal.pmd.TokensLine;

@Beta
public class SensorContextTester
implements SensorContext {
    private Settings settings = new Settings();
    private DefaultFileSystem fs;
    private ActiveRules activeRules;
    private InMemorySensorStorage sensorStorage;
    private InputModule module;
    private SonarQubeVersion sqVersion;

    private SensorContextTester(Path moduleBaseDir) {
        this.fs = new DefaultFileSystem(moduleBaseDir);
        this.activeRules = new ActiveRulesBuilder().build();
        this.sensorStorage = new InMemorySensorStorage();
        this.module = new DefaultInputModule("projectKey");
        this.sqVersion = SonarQubeVersionFactory.create(System2.INSTANCE);
    }

    public static SensorContextTester create(File moduleBaseDir) {
        return new SensorContextTester(moduleBaseDir.toPath());
    }

    public static SensorContextTester create(Path moduleBaseDir) {
        return new SensorContextTester(moduleBaseDir);
    }

    @Override
    public Settings settings() {
        return this.settings;
    }

    public SensorContextTester setSettings(Settings settings) {
        this.settings = settings;
        return this;
    }

    @Override
    public DefaultFileSystem fileSystem() {
        return this.fs;
    }

    public SensorContextTester setFileSystem(DefaultFileSystem fs) {
        this.fs = fs;
        return this;
    }

    @Override
    public ActiveRules activeRules() {
        return this.activeRules;
    }

    public SensorContextTester setActiveRules(ActiveRules activeRules) {
        this.activeRules = activeRules;
        return this;
    }

    @Override
    public Version getSonarQubeVersion() {
        return this.sqVersion.get();
    }

    public SensorContextTester setSonarQubeVersion(Version version) {
        this.sqVersion = new SonarQubeVersion(version);
        return this;
    }

    @Override
    public InputModule module() {
        return this.module;
    }

    @Override
    public <G extends Serializable> NewMeasure<G> newMeasure() {
        return new DefaultMeasure(this.sensorStorage);
    }

    public Collection<Measure> measures(String componentKey) {
        return this.sensorStorage.measuresByComponentAndMetric.row(componentKey).values();
    }

    public <G extends Serializable> Measure<G> measure(String componetKey, Metric<G> metric) {
        return this.measure(componetKey, metric.key());
    }

    public <G extends Serializable> Measure<G> measure(String componentKey, String metricKey) {
        return this.sensorStorage.measuresByComponentAndMetric.row(componentKey).get(metricKey);
    }

    @Override
    public NewIssue newIssue() {
        return new DefaultIssue(this.sensorStorage);
    }

    public Collection<Issue> allIssues() {
        return this.sensorStorage.allIssues;
    }

    @CheckForNull
    public Integer lineHits(String fileKey, CoverageType type, int line) {
        Map<CoverageType, DefaultCoverage> defaultCoverageByType = this.sensorStorage.coverageByComponent.get(fileKey);
        if (defaultCoverageByType == null) {
            return null;
        }
        if (defaultCoverageByType.containsKey((Object)type)) {
            return (Integer)defaultCoverageByType.get((Object)type).hitsByLine().get(line);
        }
        return null;
    }

    @CheckForNull
    public Integer conditions(String fileKey, CoverageType type, int line) {
        Map<CoverageType, DefaultCoverage> defaultCoverageByType = this.sensorStorage.coverageByComponent.get(fileKey);
        if (defaultCoverageByType == null) {
            return null;
        }
        if (defaultCoverageByType.containsKey((Object)type)) {
            return (Integer)defaultCoverageByType.get((Object)type).conditionsByLine().get(line);
        }
        return null;
    }

    @CheckForNull
    public Integer coveredConditions(String fileKey, CoverageType type, int line) {
        Map<CoverageType, DefaultCoverage> defaultCoverageByType = this.sensorStorage.coverageByComponent.get(fileKey);
        if (defaultCoverageByType == null) {
            return null;
        }
        if (defaultCoverageByType.containsKey((Object)type)) {
            return (Integer)defaultCoverageByType.get((Object)type).coveredConditionsByLine().get(line);
        }
        return null;
    }

    @CheckForNull
    public List<TokensLine> cpdTokens(String componentKey) {
        DefaultCpdTokens defaultCpdTokens = this.sensorStorage.cpdTokensByComponent.get(componentKey);
        return defaultCpdTokens != null ? defaultCpdTokens.getTokenLines() : null;
    }

    @Override
    public NewHighlighting newHighlighting() {
        return new DefaultHighlighting(this.sensorStorage);
    }

    @Override
    public NewCoverage newCoverage() {
        return new DefaultCoverage(this.sensorStorage);
    }

    @Override
    public NewCpdTokens newCpdTokens() {
        return new DefaultCpdTokens(this.settings, this.sensorStorage);
    }

    @Override
    public NewSymbolTable newSymbolTable() {
        return new DefaultSymbolTable(this.sensorStorage);
    }

    public List<TypeOfText> highlightingTypeAt(String componentKey, int line, int lineOffset) {
        DefaultHighlighting syntaxHighlightingData = this.sensorStorage.highlightingByComponent.get(componentKey);
        if (syntaxHighlightingData == null) {
            return Collections.emptyList();
        }
        ArrayList<TypeOfText> result = new ArrayList<TypeOfText>();
        DefaultTextPointer location = new DefaultTextPointer(line, lineOffset);
        for (SyntaxHighlightingRule sortedRule : syntaxHighlightingData.getSyntaxHighlightingRuleSet()) {
            if (sortedRule.range().start().compareTo(location) > 0 || sortedRule.range().end().compareTo(location) <= 0) continue;
            result.add(sortedRule.getTextType());
        }
        return result;
    }

    public Collection<TextRange> referencesForSymbolAt(String componentKey, int line, int lineOffset) {
        DefaultSymbolTable symbolTable = this.sensorStorage.symbolsPerComponent.get(componentKey);
        if (symbolTable == null) {
            return Collections.emptyList();
        }
        DefaultTextPointer location = new DefaultTextPointer(line, lineOffset);
        for (Map.Entry<TextRange, Set<TextRange>> symbol : symbolTable.getReferencesBySymbol().entrySet()) {
            if (symbol.getKey().start().compareTo(location) > 0 || symbol.getKey().end().compareTo(location) <= 0) continue;
            return symbol.getValue();
        }
        return Collections.emptyList();
    }
}

