/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.server.rule;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.sonar.api.ExtensionPoint;
import org.sonar.api.ce.ComputeEngineSide;
import org.sonar.api.internal.apachecommons.io.IOUtils;
import org.sonar.api.internal.apachecommons.lang.StringUtils;
import org.sonar.api.internal.google.common.base.Objects;
import org.sonar.api.internal.google.common.base.Preconditions;
import org.sonar.api.internal.google.common.base.Strings;
import org.sonar.api.internal.google.common.collect.ImmutableList;
import org.sonar.api.internal.google.common.collect.ImmutableMap;
import org.sonar.api.internal.google.common.collect.ImmutableSortedSet;
import org.sonar.api.internal.google.common.collect.Maps;
import org.sonar.api.internal.google.common.collect.Sets;
import org.sonar.api.rule.RuleStatus;
import org.sonar.api.rule.Severity;
import org.sonar.api.rules.RuleType;
import org.sonar.api.server.ServerSide;
import org.sonar.api.server.debt.DebtRemediationFunction;
import org.sonar.api.server.rule.DefaultDebtRemediationFunctions;
import org.sonar.api.server.rule.RuleParamType;
import org.sonar.api.server.rule.RuleTagFormat;
import org.sonar.api.server.rule.RuleTagsToTypeConverter;
import org.sonar.api.utils.log.Loggers;

@ServerSide
@ComputeEngineSide
@ExtensionPoint
public interface RulesDefinition {
    public void define(Context var1);

    @Immutable
    public static class Param {
        private final String key;
        private final String name;
        private final String description;
        private final String defaultValue;
        private final RuleParamType type;

        private Param(NewParam newParam) {
            this.key = newParam.key;
            this.name = newParam.name;
            this.description = newParam.description;
            this.defaultValue = newParam.defaultValue;
            this.type = newParam.type;
        }

        public String key() {
            return this.key;
        }

        public String name() {
            return this.name;
        }

        @Nullable
        public String description() {
            return this.description;
        }

        @Nullable
        public String defaultValue() {
            return this.defaultValue;
        }

        public RuleParamType type() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Param that = (Param)o;
            return this.key.equals(that.key);
        }

        public int hashCode() {
            return this.key.hashCode();
        }
    }

    public static class NewParam {
        private final String key;
        private String name;
        private String description;
        private String defaultValue;
        private RuleParamType type = RuleParamType.STRING;

        private NewParam(String key) {
            this.key = this.name = key;
        }

        public String key() {
            return this.key;
        }

        public NewParam setName(@Nullable String s) {
            this.name = StringUtils.defaultIfBlank(s, this.key);
            return this;
        }

        public NewParam setType(RuleParamType t) {
            this.type = t;
            return this;
        }

        public NewParam setDescription(@Nullable String s) {
            this.description = StringUtils.defaultIfBlank(s, null);
            return this;
        }

        public NewParam setDefaultValue(@Nullable String s) {
            this.defaultValue = Strings.emptyToNull(s);
            return this;
        }
    }

    @Immutable
    public static class Rule {
        private final Repository repository;
        private final String repoKey;
        private final String key;
        private final String name;
        private final RuleType type;
        private final String htmlDescription;
        private final String markdownDescription;
        private final String internalKey;
        private final String severity;
        private final boolean template;
        private final DebtRemediationFunction debtRemediationFunction;
        private final String gapDescription;
        private final Set<String> tags;
        private final Map<String, Param> params;
        private final RuleStatus status;

        private Rule(Repository repository, NewRule newRule) {
            this.repository = repository;
            this.repoKey = newRule.repoKey;
            this.key = newRule.key;
            this.name = newRule.name;
            this.htmlDescription = newRule.htmlDescription;
            this.markdownDescription = newRule.markdownDescription;
            this.internalKey = newRule.internalKey;
            this.severity = newRule.severity;
            this.template = newRule.template;
            this.status = newRule.status;
            this.debtRemediationFunction = newRule.debtRemediationFunction;
            this.gapDescription = newRule.gapDescription;
            this.type = newRule.type == null ? RuleTagsToTypeConverter.convert(newRule.tags) : newRule.type;
            this.tags = ImmutableSortedSet.copyOf(Sets.difference(newRule.tags, RuleTagsToTypeConverter.RESERVED_TAGS));
            ImmutableMap.Builder<String, Param> paramsBuilder = ImmutableMap.builder();
            for (NewParam newParam : newRule.paramsByKey.values()) {
                paramsBuilder.put(newParam.key, new Param(newParam));
            }
            this.params = paramsBuilder.build();
        }

        public Repository repository() {
            return this.repository;
        }

        public String key() {
            return this.key;
        }

        public String name() {
            return this.name;
        }

        public RuleType type() {
            return this.type;
        }

        public String severity() {
            return this.severity;
        }

        @CheckForNull
        public String htmlDescription() {
            return this.htmlDescription;
        }

        @CheckForNull
        public String markdownDescription() {
            return this.markdownDescription;
        }

        public boolean template() {
            return this.template;
        }

        public RuleStatus status() {
            return this.status;
        }

        @CheckForNull
        @Deprecated
        public String debtSubCharacteristic() {
            return null;
        }

        @CheckForNull
        public DebtRemediationFunction debtRemediationFunction() {
            return this.debtRemediationFunction;
        }

        @Deprecated
        @CheckForNull
        public String effortToFixDescription() {
            return this.gapDescription();
        }

        @CheckForNull
        public String gapDescription() {
            return this.gapDescription;
        }

        @CheckForNull
        public Param param(String key) {
            return this.params.get(key);
        }

        public List<Param> params() {
            return ImmutableList.copyOf(this.params.values());
        }

        public Set<String> tags() {
            return this.tags;
        }

        @CheckForNull
        public String internalKey() {
            return this.internalKey;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Rule other = (Rule)o;
            return this.key.equals(other.key) && this.repoKey.equals(other.repoKey);
        }

        public int hashCode() {
            int result = this.repoKey.hashCode();
            result = 31 * result + this.key.hashCode();
            return result;
        }

        public String toString() {
            return String.format("[repository=%s, key=%s]", this.repoKey, this.key);
        }
    }

    public static class NewRule {
        private final String repoKey;
        private final String key;
        private RuleType type;
        private String name;
        private String htmlDescription;
        private String markdownDescription;
        private String internalKey;
        private String severity = "MAJOR";
        private boolean template;
        private RuleStatus status = RuleStatus.defaultStatus();
        private DebtRemediationFunction debtRemediationFunction;
        private String gapDescription;
        private final Set<String> tags = Sets.newTreeSet();
        private final Map<String, NewParam> paramsByKey = Maps.newHashMap();
        private final DebtRemediationFunctions functions;

        private NewRule(String repoKey, String key) {
            this.repoKey = repoKey;
            this.key = key;
            this.functions = new DefaultDebtRemediationFunctions(repoKey, key);
        }

        public String key() {
            return this.key;
        }

        public NewRule setName(String s) {
            this.name = StringUtils.trimToNull(s);
            return this;
        }

        public NewRule setTemplate(boolean template) {
            this.template = template;
            return this;
        }

        public NewRule setSeverity(String s) {
            Preconditions.checkArgument(Severity.ALL.contains(s), "Severity of rule %s is not correct: %s", this, s);
            this.severity = s;
            return this;
        }

        public NewRule setType(RuleType t) {
            this.type = t;
            return this;
        }

        public NewRule setHtmlDescription(@Nullable String s) {
            Preconditions.checkState(this.markdownDescription == null, "Rule '%s' already has a Markdown description", this);
            this.htmlDescription = StringUtils.trimToNull(s);
            return this;
        }

        public NewRule setHtmlDescription(@Nullable URL classpathUrl) {
            if (classpathUrl != null) {
                try {
                    this.setHtmlDescription(IOUtils.toString(classpathUrl));
                }
                catch (IOException e) {
                    throw new IllegalStateException("Fail to read: " + classpathUrl, e);
                }
            } else {
                this.htmlDescription = null;
            }
            return this;
        }

        public NewRule setMarkdownDescription(@Nullable String s) {
            Preconditions.checkState(this.htmlDescription == null, "Rule '%s' already has an HTML description", this);
            this.markdownDescription = StringUtils.trimToNull(s);
            return this;
        }

        public NewRule setMarkdownDescription(@Nullable URL classpathUrl) {
            if (classpathUrl != null) {
                try {
                    this.setMarkdownDescription(IOUtils.toString(classpathUrl));
                }
                catch (IOException e) {
                    throw new IllegalStateException("Fail to read: " + classpathUrl, e);
                }
            } else {
                this.markdownDescription = null;
            }
            return this;
        }

        public NewRule setStatus(RuleStatus status) {
            Preconditions.checkArgument(RuleStatus.REMOVED != status, "Status 'REMOVED' is not accepted on rule '%s'", this);
            this.status = status;
            return this;
        }

        public NewRule setDebtSubCharacteristic(@Nullable String s) {
            return this;
        }

        public DebtRemediationFunctions debtRemediationFunctions() {
            return this.functions;
        }

        public NewRule setDebtRemediationFunction(@Nullable DebtRemediationFunction fn) {
            this.debtRemediationFunction = fn;
            return this;
        }

        @Deprecated
        public NewRule setEffortToFixDescription(@Nullable String s) {
            return this.setGapDescription(s);
        }

        public NewRule setGapDescription(@Nullable String s) {
            this.gapDescription = s;
            return this;
        }

        public NewParam createParam(String paramKey) {
            Preconditions.checkArgument(!this.paramsByKey.containsKey(paramKey), "The parameter '%s' is declared several times on the rule %s", paramKey, this);
            NewParam param = new NewParam(paramKey);
            this.paramsByKey.put(paramKey, param);
            return param;
        }

        @CheckForNull
        public NewParam param(String paramKey) {
            return this.paramsByKey.get(paramKey);
        }

        public Collection<NewParam> params() {
            return this.paramsByKey.values();
        }

        public NewRule addTags(String ... list) {
            for (String tag : list) {
                RuleTagFormat.validate(tag);
                this.tags.add(tag);
            }
            return this;
        }

        public NewRule setTags(String ... list) {
            this.tags.clear();
            this.addTags(list);
            return this;
        }

        public NewRule setInternalKey(@Nullable String s) {
            this.internalKey = s;
            return this;
        }

        private void validate() {
            if (Strings.isNullOrEmpty(this.name)) {
                throw new IllegalStateException(String.format("Name of rule %s is empty", this));
            }
            if (Strings.isNullOrEmpty(this.htmlDescription) && Strings.isNullOrEmpty(this.markdownDescription)) {
                throw new IllegalStateException(String.format("One of HTML description or Markdown description must be defined for rule %s", this));
            }
        }

        public String toString() {
            return String.format("[repository=%s, key=%s]", this.repoKey, this.key);
        }
    }

    public static interface DebtRemediationFunctions {
        public DebtRemediationFunction linear(String var1);

        public DebtRemediationFunction linearWithOffset(String var1, String var2);

        public DebtRemediationFunction constantPerIssue(String var1);

        public DebtRemediationFunction create(DebtRemediationFunction.Type var1, @Nullable String var2, @Nullable String var3);
    }

    @Immutable
    public static class RepositoryImpl
    implements Repository {
        private final String key;
        private final String language;
        private final String name;
        private final Map<String, Rule> rulesByKey;

        private RepositoryImpl(NewRepositoryImpl newRepository, @Nullable Repository mergeInto) {
            this.key = newRepository.key;
            this.language = newRepository.language;
            HashMap<String, Rule> ruleBuilder = new HashMap<String, Rule>();
            if (mergeInto != null) {
                if (!StringUtils.equals(newRepository.language, mergeInto.language()) || !StringUtils.equals(newRepository.key, mergeInto.key())) {
                    throw new IllegalArgumentException(String.format("Bug - language and key of the repositories to be merged should be the sames: %s and %s", newRepository, mergeInto));
                }
                this.name = StringUtils.defaultIfBlank(mergeInto.name(), newRepository.name);
                for (Rule rule : mergeInto.rules()) {
                    if (!newRepository.key().startsWith("common-") && ruleBuilder.containsKey(rule.key())) {
                        Loggers.get(this.getClass()).warn("The rule '{}' of repository '{}' is declared several times", (Object)rule.key(), (Object)mergeInto.key());
                    }
                    ruleBuilder.put(rule.key(), rule);
                }
            } else {
                this.name = newRepository.name;
            }
            for (NewRule newRule : newRepository.newRules.values()) {
                newRule.validate();
                ruleBuilder.put(newRule.key, new Rule(this, newRule));
            }
            this.rulesByKey = ImmutableMap.copyOf(ruleBuilder);
        }

        @Override
        public String key() {
            return this.key;
        }

        @Override
        public String language() {
            return this.language;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        @CheckForNull
        public Rule rule(String ruleKey) {
            return this.rulesByKey.get(ruleKey);
        }

        @Override
        public List<Rule> rules() {
            return ImmutableList.copyOf(this.rulesByKey.values());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RepositoryImpl that = (RepositoryImpl)o;
            return this.key.equals(that.key);
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public String toString() {
            return Objects.toStringHelper(this).add("language", this.language).add("key", this.key).toString();
        }
    }

    public static interface Repository
    extends ExtendedRepository {
        public String name();
    }

    public static interface ExtendedRepository {
        public String key();

        public String language();

        @CheckForNull
        public Rule rule(String var1);

        public List<Rule> rules();
    }

    public static class NewRepositoryImpl
    implements NewRepository {
        private final Context context;
        private final String key;
        private String language;
        private String name;
        private final Map<String, NewRule> newRules = Maps.newHashMap();

        private NewRepositoryImpl(Context context, String key, String language) {
            this.context = context;
            this.key = this.name = key;
            this.language = language;
        }

        @Override
        public String key() {
            return this.key;
        }

        @Override
        public NewRepositoryImpl setName(@Nullable String s) {
            if (StringUtils.isNotEmpty(s)) {
                this.name = s;
            }
            return this;
        }

        @Override
        public NewRule createRule(String ruleKey) {
            Preconditions.checkArgument(!this.newRules.containsKey(ruleKey), "The rule '%s' of repository '%s' is declared several times", ruleKey, this.key);
            NewRule newRule = new NewRule(this.key, ruleKey);
            this.newRules.put(ruleKey, newRule);
            return newRule;
        }

        @Override
        @CheckForNull
        public NewRule rule(String ruleKey) {
            return this.newRules.get(ruleKey);
        }

        @Override
        public Collection<NewRule> rules() {
            return this.newRules.values();
        }

        @Override
        public void done() {
            this.context.registerRepository(this);
        }

        public String toString() {
            return Objects.toStringHelper(this).add("key", this.key).add("language", this.language).toString();
        }
    }

    public static interface NewRepository
    extends NewExtendedRepository {
        public NewRepository setName(String var1);
    }

    public static interface NewExtendedRepository {
        public NewRule createRule(String var1);

        @CheckForNull
        public NewRule rule(String var1);

        public Collection<NewRule> rules();

        public String key();

        public void done();
    }

    public static class Context {
        private final Map<String, Repository> repositoriesByKey = Maps.newHashMap();

        public NewRepository createRepository(String key, String language) {
            return new NewRepositoryImpl(this, key, language);
        }

        @Deprecated
        public NewRepository extendRepository(String key, String language) {
            return this.createRepository(key, language);
        }

        @CheckForNull
        public Repository repository(String key) {
            return this.repositoriesByKey.get(key);
        }

        public List<Repository> repositories() {
            return ImmutableList.copyOf(this.repositoriesByKey.values());
        }

        @Deprecated
        public List<ExtendedRepository> extendedRepositories(String repositoryKey) {
            return Collections.emptyList();
        }

        @Deprecated
        public List<ExtendedRepository> extendedRepositories() {
            return Collections.emptyList();
        }

        private void registerRepository(NewRepositoryImpl newRepository) {
            Repository existing = this.repositoriesByKey.get(newRepository.key());
            if (existing != null) {
                Preconditions.checkState(existing.language().equals(newRepository.language), "The rule repository '%s' must not be defined for two different languages: %s and %s", newRepository.key, existing.language(), newRepository.language);
            }
            this.repositoriesByKey.put(newRepository.key, new RepositoryImpl(newRepository, existing));
        }
    }

    @Deprecated
    public static final class SubCharacteristics {
        public static final String MODULARITY = "MODULARITY";
        public static final String TRANSPORTABILITY = "TRANSPORTABILITY";
        public static final String COMPILER_RELATED_PORTABILITY = "COMPILER_RELATED_PORTABILITY";
        public static final String HARDWARE_RELATED_PORTABILITY = "HARDWARE_RELATED_PORTABILITY";
        public static final String LANGUAGE_RELATED_PORTABILITY = "LANGUAGE_RELATED_PORTABILITY";
        public static final String OS_RELATED_PORTABILITY = "OS_RELATED_PORTABILITY";
        public static final String SOFTWARE_RELATED_PORTABILITY = "SOFTWARE_RELATED_PORTABILITY";
        public static final String TIME_ZONE_RELATED_PORTABILITY = "TIME_ZONE_RELATED_PORTABILITY";
        public static final String READABILITY = "READABILITY";
        public static final String UNDERSTANDABILITY = "UNDERSTANDABILITY";
        public static final String API_ABUSE = "API_ABUSE";
        public static final String ERRORS = "ERRORS";
        public static final String INPUT_VALIDATION_AND_REPRESENTATION = "INPUT_VALIDATION_AND_REPRESENTATION";
        public static final String SECURITY_FEATURES = "SECURITY_FEATURES";
        public static final String CPU_EFFICIENCY = "CPU_EFFICIENCY";
        public static final String MEMORY_EFFICIENCY = "MEMORY_EFFICIENCY";
        public static final String NETWORK_USE = "NETWORK_USE";
        public static final String ARCHITECTURE_CHANGEABILITY = "ARCHITECTURE_CHANGEABILITY";
        public static final String DATA_CHANGEABILITY = "DATA_CHANGEABILITY";
        public static final String LOGIC_CHANGEABILITY = "LOGIC_CHANGEABILITY";
        public static final String ARCHITECTURE_RELIABILITY = "ARCHITECTURE_RELIABILITY";
        public static final String DATA_RELIABILITY = "DATA_RELIABILITY";
        public static final String EXCEPTION_HANDLING = "EXCEPTION_HANDLING";
        public static final String FAULT_TOLERANCE = "FAULT_TOLERANCE";
        public static final String INSTRUCTION_RELIABILITY = "INSTRUCTION_RELIABILITY";
        public static final String LOGIC_RELIABILITY = "LOGIC_RELIABILITY";
        public static final String RESOURCE_RELIABILITY = "RESOURCE_RELIABILITY";
        public static final String SYNCHRONIZATION_RELIABILITY = "SYNCHRONIZATION_RELIABILITY";
        public static final String UNIT_TESTS = "UNIT_TESTS";
        public static final String INTEGRATION_TESTABILITY = "INTEGRATION_TESTABILITY";
        public static final String UNIT_TESTABILITY = "UNIT_TESTABILITY";
        public static final String USABILITY_ACCESSIBILITY = "USABILITY_ACCESSIBILITY";
        public static final String USABILITY_COMPLIANCE = "USABILITY_COMPLIANCE";
        public static final String USABILITY_EASE_OF_USE = "USABILITY_EASE_OF_USE";
        public static final String REUSABILITY_COMPLIANCE = "REUSABILITY_COMPLIANCE";
        public static final String PORTABILITY_COMPLIANCE = "PORTABILITY_COMPLIANCE";
        public static final String MAINTAINABILITY_COMPLIANCE = "MAINTAINABILITY_COMPLIANCE";
        public static final String SECURITY_COMPLIANCE = "SECURITY_COMPLIANCE";
        public static final String EFFICIENCY_COMPLIANCE = "EFFICIENCY_COMPLIANCE";
        public static final String CHANGEABILITY_COMPLIANCE = "CHANGEABILITY_COMPLIANCE";
        public static final String RELIABILITY_COMPLIANCE = "RELIABILITY_COMPLIANCE";
        public static final String TESTABILITY_COMPLIANCE = "TESTABILITY_COMPLIANCE";

        private SubCharacteristics() {
        }
    }
}

