/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import org.sonar.api.batch.BatchSide;
import org.sonar.api.server.ServerSide;
import org.sonar.api.utils.UriReader;

@BatchSide
@ServerSide
public abstract class HttpDownloader
extends UriReader.SchemeProcessor {
    public static final int TIMEOUT_MILLISECONDS = 20000;

    public abstract String downloadPlainText(URI var1, String var2);

    public abstract byte[] download(URI var1);

    public abstract InputStream openStream(URI var1);

    public abstract void download(URI var1, File var2);

    public static class HttpException
    extends RuntimeException {
        private final URI uri;
        private final int responseCode;
        private final String responseContent;

        public HttpException(URI uri, int responseContent) {
            this(uri, responseContent, "");
        }

        public HttpException(URI uri, int responseCode, String responseContent) {
            super("Fail to download [" + uri + "]. Response code: " + responseCode);
            this.uri = uri;
            this.responseCode = responseCode;
            this.responseContent = responseContent;
        }

        public int getResponseCode() {
            return this.responseCode;
        }

        public URI getUri() {
            return this.uri;
        }

        public String getResponseContent() {
            return this.responseContent;
        }
    }
}

